/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.file.transfer.smb;

import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.file.transfer.AbstractFileTransfer;
import com.cognifide.gradle.common.file.transfer.FileDownloader;
import com.cognifide.gradle.common.file.transfer.FileEntry;
import com.cognifide.gradle.common.file.transfer.FileUploader;
import com.cognifide.gradle.common.file.transfer.ProtocolFileTransfer;
import com.cognifide.gradle.common.file.transfer.smb.SmbFileException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0007J \u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00132\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u001a\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J \u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010'\u001a\u00020 H\u0016J\u0012\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0013*\u00020\u001dH\u0002R5\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \b*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR5\u0010\u0010\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R5\u0010\u0016\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\n\u00a8\u0006*"}, d2={"Lcom/cognifide/gradle/common/file/transfer/smb/SmbFileTransfer;", "Lcom/cognifide/gradle/common/file/transfer/ProtocolFileTransfer;", "common", "Lcom/cognifide/gradle/common/CommonExtension;", "(Lcom/cognifide/gradle/common/CommonExtension;)V", "domain", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getDomain", "()Lorg/gradle/api/provider/Property;", "logger", "Lorg/gradle/api/logging/Logger;", "name", "getName", "()Ljava/lang/String;", "password", "getPassword", "protocols", "", "getProtocols", "()Ljava/util/List;", "user", "getUser", "deleteFrom", "", "dirUrl", "fileName", "dir", "Ljcifs/smb/SmbFile;", "downloadFrom", "target", "Ljava/io/File;", "file", "list", "Lcom/cognifide/gradle/common/file/transfer/FileEntry;", "stat", "truncate", "uploadTo", "source", "dirFiles", "Companion", "common-plugin"})
public final class SmbFileTransfer
extends ProtocolFileTransfer {
    private final Logger logger;
    private final Property<String> domain;
    private final Property<String> user;
    private final Property<String> password;
    @NotNull
    public static final String NAME = "smb";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final Property<String> getDomain() {
        return this.domain;
    }

    public final Property<String> getUser() {
        return this.user;
    }

    public final Property<String> getPassword() {
        return this.password;
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public List<String> getProtocols() {
        return CollectionsKt.listOf((Object)"smb://*");
    }

    @Override
    public void downloadFrom(@NotNull String dirUrl, @NotNull String fileName, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String fileUrl = dirUrl + '/' + fileName;
        try {
            SmbFile smbFile = this.file(dirUrl, fileName);
            boolean bl = false;
            boolean bl2 = false;
            SmbFile $this$apply = smbFile;
            boolean bl3 = false;
            this.logger.info("Downloading file from URL '" + fileUrl + '\'');
            FileDownloader fileDownloader = this.downloader((Function1<? super FileDownloader, Unit>)((Function1)new Function1<FileDownloader, Unit>($this$apply){
                final /* synthetic */ SmbFile $this_apply;

                public final void invoke(@NotNull FileDownloader $this$downloader) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloader, (String)"$receiver");
                    $this$downloader.setSize(this.$this_apply.length());
                }
                {
                    this.$this_apply = smbFile;
                    super(1);
                }
            }));
            InputStream inputStream = $this$apply.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            fileDownloader.download(inputStream, target);
        }
        catch (Exception e) {
            throw (Throwable)((Object)new SmbFileException("Cannot download file from URL '" + fileUrl + "' . Cause: '" + e.getMessage()));
        }
    }

    @Override
    public void uploadTo(@NotNull String dirUrl, @NotNull String fileName, @NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String fileUrl = dirUrl + '/' + fileName;
        try {
            SmbFile smbFile = this.file(dirUrl, fileName);
            boolean bl = false;
            boolean bl2 = false;
            SmbFile $this$apply = smbFile;
            boolean bl3 = false;
            this.logger.info("Uploading file to URL '" + fileUrl + '\'');
            FileUploader fileUploader = AbstractFileTransfer.uploader$default(this, null, 1, null);
            OutputStream outputStream = $this$apply.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
            FileUploader.upload$default(fileUploader, source, outputStream, null, 4, null);
        }
        catch (Exception e) {
            throw (Throwable)((Object)new SmbFileException("Cannot upload file '" + source + "' to URL '" + fileUrl + "'. Cause: '" + e.getMessage(), e));
        }
    }

    @Override
    public void deleteFrom(@NotNull String dirUrl, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String fileUrl = dirUrl + '/' + fileName;
        SmbFile smbFile = this.file(dirUrl, fileName);
        boolean bl = false;
        boolean bl2 = false;
        SmbFile $this$apply = smbFile;
        boolean bl3 = false;
        try {
            this.logger.info("Deleting file at URL '" + fileUrl + '\'');
            $this$apply.delete();
        }
        catch (Exception e) {
            throw (Throwable)((Object)new SmbFileException("Cannot delete file at URL '" + fileUrl + "'. Cause: '" + e.getMessage(), e));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FileEntry> list(@NotNull String dirUrl) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        SmbFile smbFile = this.dir(dirUrl);
        boolean bl = false;
        boolean bl2 = false;
        SmbFile $this$run = smbFile;
        boolean bl3 = false;
        try {
            void $this$mapTo$iv$iv;
            this.logger.info("Listing files at URL '" + dirUrl + '\'');
            Iterable $this$map$iv = this.dirFiles($this$run);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SmbFile smbFile2 = (SmbFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                FileEntry fileEntry = new FileEntry(string2, it.length(), it.lastModified());
                collection.add(fileEntry);
            }
            list2 = (List)destination$iv$iv;
        }
        catch (Exception e) {
            throw (Throwable)((Object)new SmbFileException("Cannot list files in directory at URL '" + dirUrl + "'. Cause: '" + e.getMessage(), e));
        }
        return list2;
    }

    @Override
    public void truncate(@NotNull String dirUrl) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        SmbFile smbFile = this.dir(dirUrl);
        boolean bl = false;
        boolean bl2 = false;
        SmbFile $this$apply = smbFile;
        boolean bl3 = false;
        try {
            this.logger.info("Truncating files at URL '" + dirUrl + '\'');
            Iterable $this$forEach$iv = this.dirFiles($this$apply);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SmbFile it = (SmbFile)element$iv;
                boolean bl4 = false;
                it.delete();
            }
        }
        catch (Exception e) {
            throw (Throwable)((Object)new SmbFileException("Cannot truncate directory at URL '" + dirUrl + "'. Cause: '" + e.getMessage(), e));
        }
    }

    @Override
    @Nullable
    public FileEntry stat(@NotNull String dirUrl, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String fileUrl = dirUrl + '/' + fileName;
        this.logger.info("Checking file status at URL '" + fileUrl + '\'');
        try {
            FileEntry fileEntry;
            SmbFile smbFile = this.file(dirUrl, fileName);
            boolean bl = false;
            boolean bl2 = false;
            SmbFile it = smbFile;
            boolean bl3 = false;
            Object object = it.isFile() ? smbFile : null;
            if (object != null) {
                smbFile = object;
                bl = false;
                bl2 = false;
                SmbFile $this$run = smbFile;
                boolean bl4 = false;
                fileEntry = new FileEntry(fileName, $this$run.length(), $this$run.lastModified());
            } else {
                fileEntry = null;
            }
            return fileEntry;
        }
        catch (Exception e) {
            throw (Throwable)((Object)new SmbFileException("Cannot check file status at URL '" + fileUrl + "'. Cause: '" + e.getMessage(), e));
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final SmbFile file(@NotNull String dirUrl, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        dirUrlNormalized = StringUtils.appendIfMissing((String)dirUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        v0 = this.user;
        Intrinsics.checkNotNullExpressionValue(v0, (String)"user");
        var4_4 = (CharSequence)v0.getOrNull();
        var5_5 = false;
        var6_6 = false;
        if (var4_4 == null || StringsKt.isBlank((CharSequence)var4_4) != false) ** GOTO lbl-1000
        v1 = this.password;
        Intrinsics.checkNotNullExpressionValue(v1, (String)"password");
        var4_4 = (CharSequence)v1.getOrNull();
        var5_5 = false;
        var6_6 = false;
        if (!(var4_4 == null || StringsKt.isBlank((CharSequence)var4_4) != false)) {
            v2 = this.domain;
            Intrinsics.checkNotNullExpressionValue(v2, (String)"domain");
            v3 = new SmbFile(dirUrlNormalized, fileName, new NtlmPasswordAuthentication((String)v2.getOrNull(), (String)this.user.get(), (String)this.password.get()));
        } else lbl-1000:
        // 2 sources

        {
            v3 = new SmbFile(dirUrlNormalized, fileName);
        }
        var4_4 = v3;
        var5_5 = false;
        var6_6 = false;
        $this$apply = var4_4;
        $i$a$-apply-SmbFileTransfer$file$1 = false;
        $this$apply.setUseCaches(false);
        return var4_4;
    }

    @NotNull
    public final SmbFile dir(@NotNull String dirUrl) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        SmbFile smbFile = this.file(dirUrl, "");
        boolean bl = false;
        boolean bl2 = false;
        SmbFile $this$apply = smbFile;
        boolean bl3 = false;
        try {
            if (!$this$apply.isDirectory()) {
                throw (Throwable)((Object)new SmbFileException("Path at URL '" + dirUrl + "' is not a directory."));
            }
        }
        catch (Exception e) {
            throw (Throwable)((Object)new SmbFileException("Directory at URL '" + dirUrl + "' does not exist or not accessible. Cause: '" + e.getMessage() + '\'', e));
        }
        return smbFile;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SmbFile> dirFiles(SmbFile $this$dirFiles) {
        void $this$filterTo$iv$iv;
        SmbFile[] smbFileArray = $this$dirFiles.listFiles();
        if (smbFileArray == null) {
            smbFileArray = new SmbFile[]{};
        }
        SmbFile[] $this$filter$iv = smbFileArray;
        boolean $i$f$filter = false;
        SmbFile[] smbFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var7_7[j];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (!v1.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public SmbFileTransfer(@NotNull CommonExtension common) {
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        super(common);
        this.logger = common.getLogger();
        this.domain = common.getObj().string((Function1<? super Property<String>, Unit>)((Function1)new Function1<Property<String>, Unit>(common){
            final /* synthetic */ CommonExtension $common;

            public final void invoke(@NotNull Property<String> $this$string) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$string, (String)"$receiver");
                    String string2 = this.$common.getProp().string("fileTransfer.smb.domain");
                    if (string2 == null) break block0;
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    $this$string.set((Object)it);
                }
            }
            {
                this.$common = commonExtension;
                super(1);
            }
        }));
        this.user = common.getObj().string((Function1<? super Property<String>, Unit>)((Function1)new Function1<Property<String>, Unit>(common){
            final /* synthetic */ CommonExtension $common;

            public final void invoke(@NotNull Property<String> $this$string) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$string, (String)"$receiver");
                    String string2 = this.$common.getProp().string("fileTransfer.smb.user");
                    if (string2 == null) break block0;
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    $this$string.set((Object)it);
                }
            }
            {
                this.$common = commonExtension;
                super(1);
            }
        }));
        this.password = common.getObj().string((Function1<? super Property<String>, Unit>)((Function1)new Function1<Property<String>, Unit>(common){
            final /* synthetic */ CommonExtension $common;

            public final void invoke(@NotNull Property<String> $this$string) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$string, (String)"$receiver");
                    String string2 = this.$common.getProp().string("fileTransfer.smb.password");
                    if (string2 == null) break block0;
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    $this$string.set((Object)it);
                }
            }
            {
                this.$common = commonExtension;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cognifide/gradle/common/file/transfer/smb/SmbFileTransfer$Companion;", "", "()V", "NAME", "", "common-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

