/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.file.transfer;

import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.build.ProgressLogger;
import com.cognifide.gradle.common.utils.Formats;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0006H\u0002J$\u0010\u0015\u001a\u00020\u000f*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/cognifide/gradle/common/file/transfer/FileDownloader;", "", "common", "Lcom/cognifide/gradle/common/CommonExtension;", "(Lcom/cognifide/gradle/common/CommonExtension;)V", "loggedKb", "", "processedBytes", "size", "getSize", "()J", "setSize", "(J)V", "startTime", "download", "", "input", "Ljava/io/InputStream;", "target", "Ljava/io/File;", "remainingTime", "logProgress", "Lcom/cognifide/gradle/common/build/ProgressLogger;", "operation", "", "readBytes", "file", "Companion", "common-plugin"})
public final class FileDownloader {
    private long processedBytes;
    private long loggedKb;
    private long startTime;
    private long size;
    private final CommonExtension common;
    public static final int TRANSFER_CHUNK_100_KB = 102400;
    public static final int KILOBYTE = 1024;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final long getSize() {
        return this.size;
    }

    public final void setSize(long l) {
        this.size = l;
    }

    public final void download(@NotNull InputStream input, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.common.progressLogger((Function1)new Function1<ProgressLogger, Unit>(this, input, target){
            final /* synthetic */ FileDownloader this$0;
            final /* synthetic */ InputStream $input;
            final /* synthetic */ File $target;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull ProgressLogger $this$progressLogger) {
                Intrinsics.checkNotNullParameter((Object)$this$progressLogger, (String)"$receiver");
                Closeable closeable = this.$input;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    InputStream inputStream = (InputStream)closeable;
                    boolean bl3 = false;
                    this.$target.getParentFile().mkdirs();
                    FileDownloader.access$setStartTime$p(this.this$0, System.currentTimeMillis());
                    FileOutputStream output = new FileOutputStream(this.$target);
                    boolean finished = false;
                    try {
                        byte[] buf = new byte[102400];
                        int read = inputStream.read(buf);
                        while (read >= 0) {
                            output.write(buf, 0, read);
                            FileDownloader.access$logProgress(this.this$0, $this$progressLogger, "Downloading", read, this.$target);
                            read = inputStream.read(buf);
                        }
                        output.flush();
                        finished = true;
                    }
                    catch (Throwable throwable2) {
                        output.close();
                        this.$target.delete();
                        throw throwable2;
                    }
                    output.close();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = fileDownloader;
                this.$input = inputStream;
                this.$target = file2;
                super(1);
            }
        });
    }

    private final void logProgress(ProgressLogger $this$logProgress, String operation, long readBytes, File file2) {
        this.processedBytes += readBytes;
        long processedKb = this.processedBytes / (long)1024;
        if (processedKb > this.loggedKb) {
            String string2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
            String fileName = StringsKt.removeSuffix((String)string2, (CharSequence)".tmp");
            String msg = this.size > 0L ? operation + ": " + fileName + " | " + Formats.INSTANCE.fileSizeBytesToHuman(this.processedBytes) + '/' + Formats.INSTANCE.fileSizeBytesToHuman(this.size) + " (" + Formats.INSTANCE.percent(this.processedBytes, this.size) + ',' + " time left: " + Formats.INSTANCE.duration(this.remainingTime()) + ')' : operation + ": " + fileName + " | " + Formats.INSTANCE.fileSizeBytesToHuman(this.processedBytes);
            $this$logProgress.progress(msg);
            this.loggedKb = processedKb;
        }
    }

    private final long remainingTime() {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        long allTime = elapsedTime * this.size / this.processedBytes;
        return RangesKt.coerceAtLeast((long)(allTime - elapsedTime), (long)0L);
    }

    public FileDownloader(@NotNull CommonExtension common) {
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        this.common = common;
        this.startTime = -1L;
    }

    public static final /* synthetic */ long access$getStartTime$p(FileDownloader $this) {
        return $this.startTime;
    }

    public static final /* synthetic */ void access$setStartTime$p(FileDownloader $this, long l) {
        $this.startTime = l;
    }

    public static final /* synthetic */ void access$logProgress(FileDownloader $this, ProgressLogger $this$access_u24logProgress, String operation, long readBytes, File file2) {
        $this.logProgress($this$access_u24logProgress, operation, readBytes, file2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/cognifide/gradle/common/file/transfer/FileDownloader$Companion;", "", "()V", "KILOBYTE", "", "TRANSFER_CHUNK_100_KB", "common-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

