/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.file.resolver;

import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.build.Parallel;
import com.cognifide.gradle.common.build.ProgressIndicator;
import com.cognifide.gradle.common.build.PropertyParser;
import com.cognifide.gradle.common.file.FileException;
import com.cognifide.gradle.common.file.resolver.FileGroup;
import com.cognifide.gradle.common.file.resolver.FileResolution;
import com.cognifide.gradle.common.file.resolver.Resolver;
import com.cognifide.gradle.common.file.transfer.FileTransferHandler;
import com.cognifide.gradle.common.file.transfer.FileTransferManager;
import com.cognifide.gradle.common.file.transfer.http.HttpFileTransfer;
import com.cognifide.gradle.common.file.transfer.resolve.ResolveFileTransfer;
import com.cognifide.gradle.common.file.transfer.sftp.SftpFileTransfer;
import com.cognifide.gradle.common.file.transfer.smb.SmbFileTransfer;
import com.cognifide.gradle.common.utils.Formats;
import com.cognifide.gradle.common.utils.Patterns;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0014\b&\u0018\u0000 d*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001dB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010-\u001a\u00020.2\u0017\u0010/\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020.00\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u00028\u00002\u0006\u00103\u001a\u00020#H&\u00a2\u0006\u0002\u00104J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020#J-\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00112\u0006\u00108\u001a\u00020#2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0:\"\u00020#\u00a2\u0006\u0002\u0010;J\"\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00112\u0006\u00108\u001a\u00020#2\f\u00109\u001a\b\u0012\u0004\u0012\u00020#0<J'\u0010=\u001a\u0002062\u0006\u00107\u001a\u00020#2\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020.00\u00a2\u0006\u0002\b1J'\u0010@\u001a\u0002062\u0006\u00107\u001a\u00020#2\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020.00\u00a2\u0006\u0002\b1J'\u0010B\u001a\u0002062\u0006\u00107\u001a\u00020#2\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020.00\u00a2\u0006\u0002\b1J\u000e\u0010D\u001a\u0002062\u0006\u0010E\u001a\u00020\u0003J\u001f\u0010F\u001a\u00020.2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030:\"\u00020\u0003\u00a2\u0006\u0002\u0010HJ\u0014\u0010F\u001a\u00020.2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00030<J\u0013\u0010\u0015\u001a\u00028\u00002\u0006\u00103\u001a\u00020#\u00a2\u0006\u0002\u00104J-\u0010\u0015\u001a\u00020.2\u0006\u00103\u001a\u00020#2\u001d\u0010/\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020.00\u00a2\u0006\u0002\b1J\u0016\u0010\u0015\u001a\u00020.2\u0006\u00103\u001a\u00020#2\u0006\u0010I\u001a\u00020#J\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u00103\u001a\u00020#J\u0015\u0010K\u001a\u00028\u00002\u0006\u00103\u001a\u00020#H\u0002\u00a2\u0006\u0002\u00104J\u000e\u0010L\u001a\u0002062\u0006\u0010M\u001a\u00020\u0003J,\u0010N\u001a\u0002062\u0006\u0010O\u001a\u00020\u00032\u0006\u0010P\u001a\u00020Q2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\u001200H\u0002J,\u0010S\u001a\u0002062\u0006\u00107\u001a\u00020#2\u0006\u0010P\u001a\u00020Q2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020.00H\u0002J\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010U\u001a\u00020#J\u000e\u0010V\u001a\u0002062\u0006\u0010W\u001a\u00020\u0012J\u0018\u0010V\u001a\u0002062\u0006\u0010W\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QH\u0002J\u000e\u0010V\u001a\u0002062\u0006\u0010X\u001a\u00020#J/\u0010Y\u001a\u0002062\u0006\u0010Z\u001a\u00020\u00032\u001f\u0010[\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120<\u0012\u0006\u0012\u0004\u0018\u00010\u001200\u00a2\u0006\u0002\b1J=\u0010Y\u001a\u0002062\u0006\u0010Z\u001a\u00020\u00032\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020#0<2\u001f\u0010[\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120<\u0012\u0006\u0012\u0004\u0018\u00010\u001200\u00a2\u0006\u0002\b1J\u000e\u0010]\u001a\u0002062\u0006\u0010Z\u001a\u00020\u0003J\u000e\u0010^\u001a\u0002062\u0006\u0010Z\u001a\u00020\u0003J\u000e\u0010_\u001a\u0002062\u0006\u0010Z\u001a\u00020\u0003J,\u0010`\u001a\u00020.*\u00020#2\u001d\u0010a\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020.00\u00a2\u0006\u0002\b1H\u0086\u0002J.\u0010`\u001a\u00020.*\u00020#2\u0006\u0010E\u001a\u00020\u00032\u0017\u0010b\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020.00\u00a2\u0006\u0002\b1H\u0086\u0002J&\u0010`\u001a\u00020.*\u00020#2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030:\"\u00020\u0003H\u0086\u0002\u00a2\u0006\u0002\u0010cJ6\u0010`\u001a\u00020.*\u00020#2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00030<2\u0019\b\u0002\u0010b\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020.00\u00a2\u0006\u0002\b1H\u0086\u0002R\u0012\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u00008B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00028\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R5\u0010!\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010#0# \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010#0#\u0018\u00010\"0\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R5\u0010&\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010(0( \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010(0(\u0018\u00010'0'\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/cognifide/gradle/common/file/resolver/Resolver;", "G", "Lcom/cognifide/gradle/common/file/resolver/FileGroup;", "", "common", "Lcom/cognifide/gradle/common/CommonExtension;", "(Lcom/cognifide/gradle/common/CommonExtension;)V", "_groupCurrent", "Lcom/cognifide/gradle/common/file/resolver/FileGroup;", "getCommon", "()Lcom/cognifide/gradle/common/CommonExtension;", "downloadDir", "Lorg/gradle/api/file/DirectoryProperty;", "kotlin.jvm.PlatformType", "getDownloadDir", "()Lorg/gradle/api/file/DirectoryProperty;", "files", "", "Ljava/io/File;", "getFiles", "()Ljava/util/List;", "group", "groupCurrent", "getGroupCurrent", "()Lcom/cognifide/gradle/common/file/resolver/FileGroup;", "setGroupCurrent", "(Lcom/cognifide/gradle/common/file/resolver/FileGroup;)V", "groupDefault", "getGroupDefault", "groupList", "", "groups", "getGroups", "localFilePatterns", "Lorg/gradle/api/provider/ListProperty;", "", "getLocalFilePatterns", "()Lorg/gradle/api/provider/ListProperty;", "parallelLevel", "Lorg/gradle/api/provider/Property;", "", "getParallelLevel", "()Lorg/gradle/api/provider/Property;", "project", "Lorg/gradle/api/Project;", "config", "", "configurer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "createGroup", "name", "(Ljava/lang/String;)Lcom/cognifide/gradle/common/file/resolver/FileGroup;", "download", "Lcom/cognifide/gradle/common/file/resolver/FileResolution;", "url", "urlDir", "fileNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "", "downloadHttp", "options", "Lcom/cognifide/gradle/common/file/transfer/http/HttpFileTransfer;", "downloadSftp", "Lcom/cognifide/gradle/common/file/transfer/sftp/SftpFileTransfer;", "downloadSmb", "Lcom/cognifide/gradle/common/file/transfer/smb/SmbFileTransfer;", "get", "value", "getAll", "values", "([Ljava/lang/Object;)V", "downloadUrl", "groupFiles", "groupNamed", "resolve", "dependencyNotation", "resolveFile", "hash", "parallel", "", "resolver", "resolveFileUrl", "resolveGroups", "groupName", "useLocal", "sourceFile", "path", "useLocalBy", "dir", "selector", "filePatterns", "useLocalLastModified", "useLocalLastNamed", "useLocalRecent", "invoke", "groupDefiner", "groupOptions", "(Ljava/lang/String;[Ljava/lang/Object;)V", "Companion", "common-plugin"})
public abstract class Resolver<G extends FileGroup> {
    private final DirectoryProperty downloadDir;
    private final Project project;
    private final List<G> groupList;
    private G _groupCurrent;
    private final Property<Integer> parallelLevel;
    private final ListProperty<String> localFilePatterns;
    @NotNull
    private final CommonExtension common;
    @NotNull
    public static final String GROUP_DEFAULT = "default";
    @NotNull
    public static final String DOWNLOAD_DIR_DEFAULT = "download";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final DirectoryProperty getDownloadDir() {
        return this.downloadDir;
    }

    private final G getGroupDefault() {
        return this.groupNamed(GROUP_DEFAULT);
    }

    private final G getGroupCurrent() {
        G g = this._groupCurrent;
        if (g == null) {
            g = this.getGroupDefault();
        }
        return g;
    }

    private final void setGroupCurrent(G group2) {
        this._groupCurrent = group2;
    }

    public final Property<Integer> getParallelLevel() {
        return this.parallelLevel;
    }

    public final ListProperty<String> getLocalFilePatterns() {
        return this.localFilePatterns;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<G> getGroups() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.groupList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileGroup it = (FileGroup)element$iv$iv;
            boolean bl = false;
            Collection collection = it.getResolutions();
            boolean bl2 = false;
            if (!(!collection.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<G> resolveGroups(@NotNull String groupName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Iterable $this$filter$iv = this.getGroups();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileGroup it = (FileGroup)element$iv$iv;
            boolean bl = false;
            if (!Patterns.INSTANCE.wildcard(it.getName(), groupName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        List $this$apply = list2;
        boolean bl3 = false;
        this.common.progress((Function1)new Function1<ProgressIndicator, Unit>($this$apply, this){
            final /* synthetic */ List $this_apply;
            final /* synthetic */ Resolver this$0;
            {
                this.$this_apply = list2;
                this.this$0 = resolver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator $this$progress) {
                Intrinsics.checkNotNullParameter((Object)$this$progress, (String)"$receiver");
                $this$progress.setStep("Resolving files");
                $this$progress.setTotal(this.$this_apply.size());
                if (((Number)this.this$0.getParallelLevel().get()).intValue() <= 1) {
                    Iterable $this$forEach$iv = this.$this_apply;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        FileGroup group2 = (FileGroup)element$iv;
                        boolean bl = false;
                        $this$progress.increment("Group '" + group2.getName() + '\'', (Function0)new Function0<Unit>(group2){
                            final /* synthetic */ FileGroup $group;
                            {
                                this.$group = fileGroup;
                                super(0);
                            }

                            public final void invoke() {
                                this.$group.resolve();
                            }
                        });
                    }
                } else {
                    void parallel;
                    Iterable $this$partition$iv = this.$this_apply;
                    boolean $i$f$partition = false;
                    ArrayList<T> first$iv = new ArrayList<T>();
                    ArrayList<T> second$iv = new ArrayList<T>();
                    for (T element$iv : $this$partition$iv) {
                        FileGroup it = (FileGroup)element$iv;
                        boolean bl = false;
                        if (it.getParallelable$common_plugin()) {
                            first$iv.add(element$iv);
                            continue;
                        }
                        second$iv.add(element$iv);
                    }
                    Pair pair = new Pair(first$iv, second$iv);
                    List $this$forEach$iv = (List)pair.component1();
                    List sequential = (List)pair.component2();
                    Parallel parallel2 = this.this$0.getCommon().getParallel();
                    Object object = this.this$0.getParallelLevel().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parallelLevel.get()");
                    parallel2.poolEach(((Number)object).intValue(), "resolver", (Iterable)parallel, (Function2)new Function2<CoroutineScope, G, Unit>($this$progress){
                        final /* synthetic */ ProgressIndicator $this_progress;
                        {
                            this.$this_progress = progressIndicator;
                            super(2);
                        }

                        public final void invoke(@NotNull CoroutineScope $this$poolEach, @NotNull G group2) {
                            Intrinsics.checkNotNullParameter((Object)$this$poolEach, (String)"$receiver");
                            Intrinsics.checkNotNullParameter(group2, (String)"group");
                            this.$this_progress.increment("Group '" + ((FileGroup)group2).getName() + '\'', (Function0)new Function0<Unit>(group2){
                                final /* synthetic */ FileGroup $group;
                                {
                                    this.$group = fileGroup;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$group.resolve();
                                }
                            });
                        }
                    });
                    Iterable $this$forEach$iv2 = sequential;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv2) {
                        FileGroup group3 = (FileGroup)element$iv;
                        boolean bl = false;
                        $this$progress.increment("Group '" + group3.getName() + '\'', (Function0)new Function0<Unit>(group3){
                            final /* synthetic */ FileGroup $group;
                            {
                                this.$group = fileGroup;
                                super(0);
                            }

                            public final void invoke() {
                                this.$group.resolve();
                            }
                        });
                    }
                }
            }
        });
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> groupFiles(@NotNull String name) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$flatMap$iv = this.resolveGroups(name);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FileGroup it = (FileGroup)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<File> getFiles() {
        return this.groupFiles("*");
    }

    @NotNull
    public final G group(@NotNull String name) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = this.groupList;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                FileGroup it = (FileGroup)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        FileGroup fileGroup = v0;
        if (fileGroup == null) {
            throw (Throwable)((Object)new FileException("File group '" + name + "' is not defined."));
        }
        return (G)fileGroup;
    }

    public final void getAll(Object ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.getAll(ArraysKt.asIterable((Object[])values));
    }

    public final void getAll(@NotNull Iterable<? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Iterable<? extends Object> $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        Iterator<? extends Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            this.get(it);
        }
    }

    @NotNull
    public final FileResolution get(@NotNull Object value) {
        FileResolution fileResolution;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FileTransferManager fileTransferManager = this.common.getFileTransfer();
        boolean bl = false;
        boolean bl2 = false;
        FileTransferManager $this$run = fileTransferManager;
        boolean bl3 = false;
        try {
            ConfigurableFileCollection configurableFileCollection = this.project.files(new Object[]{value});
            Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(value)");
            File file2 = configurableFileCollection.getSingleFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.files(value).singleFile");
            fileResolution = this.useLocal(file2);
        }
        catch (Exception e) {
            FileResolution fileResolution2;
            if (value instanceof String) {
                FileTransferHandler fileTransferHandler = $this$run.handling((String)value);
                boolean bl4 = false;
                boolean bl5 = false;
                FileTransferHandler $this$run2 = fileTransferHandler;
                boolean bl6 = false;
                if ($this$run2 instanceof ResolveFileTransfer) {
                    Object object = $this$run2.getParallelable().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parallelable.get()");
                    fileResolution2 = this.resolveFile(value, (Boolean)object, (Function1<FileResolution, File>)((Function1)new Function1<FileResolution, File>($this$run, this, value){
                        final /* synthetic */ FileTransferManager $this_run$inlined;
                        final /* synthetic */ Resolver this$0;
                        final /* synthetic */ Object $value$inlined;
                        {
                            this.$this_run$inlined = fileTransferManager;
                            this.this$0 = resolver;
                            this.$value$inlined = object;
                            super(1);
                        }

                        @NotNull
                        public final File invoke(@NotNull FileResolution it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.$this_run$inlined.getResolve().resolve(this.$value$inlined);
                        }
                    }));
                } else {
                    String string2 = (String)value;
                    Object object = $this$run2.getParallelable().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parallelable.get()");
                    fileResolution2 = this.resolveFileUrl(string2, (Boolean)object, (Function1<File, Unit>)((Function1)new Function1<File, Unit>($this$run2, $this$run, this, value){
                        final /* synthetic */ FileTransferHandler $this_run;
                        final /* synthetic */ FileTransferManager $this_run$inlined;
                        final /* synthetic */ Resolver this$0;
                        final /* synthetic */ Object $value$inlined;
                        {
                            this.$this_run = fileTransferHandler;
                            this.$this_run$inlined = fileTransferManager;
                            this.this$0 = resolver;
                            this.$value$inlined = object;
                            super(1);
                        }

                        public final void invoke(@NotNull File it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$this_run$inlined.downloadUsing(this.$this_run, (String)this.$value$inlined, it);
                        }
                    }));
                }
            } else {
                fileResolution2 = this.resolveFile(value, false, (Function1<FileResolution, File>)((Function1)new Function1<FileResolution, File>($this$run, this, value){
                    final /* synthetic */ FileTransferManager $this_run;
                    final /* synthetic */ Resolver this$0;
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$this_run = fileTransferManager;
                        this.this$0 = resolver;
                        this.$value$inlined = object;
                        super(1);
                    }

                    @NotNull
                    public final File invoke(@NotNull FileResolution it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$this_run.getResolve().resolve(this.$value$inlined);
                    }
                }));
            }
            fileResolution = fileResolution2;
        }
        return fileResolution;
    }

    @NotNull
    public final FileResolution resolve(@NotNull Object dependencyNotation) {
        Intrinsics.checkNotNullParameter((Object)dependencyNotation, (String)"dependencyNotation");
        return this.get(dependencyNotation);
    }

    @NotNull
    public final List<FileResolution> download(@NotNull String urlDir, String ... fileNames) {
        Intrinsics.checkNotNullParameter((Object)urlDir, (String)"urlDir");
        Intrinsics.checkNotNullParameter((Object)fileNames, (String)"fileNames");
        return this.download(urlDir, ArraysKt.asIterable((Object[])fileNames));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FileResolution> download(@NotNull String urlDir, @NotNull Iterable<String> fileNames) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)urlDir, (String)"urlDir");
        Intrinsics.checkNotNullParameter(fileNames, (String)"fileNames");
        Iterable<String> $this$map$iv = fileNames;
        boolean $i$f$map = false;
        Iterable<String> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void fileName;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FileResolution fileResolution = this.download(urlDir + '/' + (String)fileName);
            collection.add(fileResolution);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final FileResolution download(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.get(url);
    }

    @NotNull
    public final FileResolution downloadHttp(@NotNull String url, @NotNull Function1<? super HttpFileTransfer, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        return this.resolveFileUrl(url, true, (Function1<File, Unit>)((Function1)new Function1<File, Unit>(this, options2, url){
            final /* synthetic */ Resolver this$0;
            final /* synthetic */ Function1 $options;
            final /* synthetic */ String $url;

            public final void invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getCommon().httpFile((Function1)new Function1<HttpFileTransfer, Unit>(this, it){
                    final /* synthetic */ downloadHttp.1 this$0;
                    final /* synthetic */ File $it;

                    public final void invoke(@NotNull HttpFileTransfer $this$httpFile) {
                        Intrinsics.checkNotNullParameter((Object)$this$httpFile, (String)"$receiver");
                        this.this$0.$options.invoke((Object)$this$httpFile);
                        $this$httpFile.download(this.this$0.$url, this.$it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$it = file2;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = resolver;
                this.$options = function1;
                this.$url = string2;
                super(1);
            }
        }));
    }

    @NotNull
    public final FileResolution downloadSftp(@NotNull String url, @NotNull Function1<? super SftpFileTransfer, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        return this.resolveFileUrl(url, true, (Function1<File, Unit>)((Function1)new Function1<File, Unit>(this, options2, url){
            final /* synthetic */ Resolver this$0;
            final /* synthetic */ Function1 $options;
            final /* synthetic */ String $url;

            public final void invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getCommon().sftpFile((Function1)new Function1<SftpFileTransfer, Unit>(this, it){
                    final /* synthetic */ downloadSftp.1 this$0;
                    final /* synthetic */ File $it;

                    public final void invoke(@NotNull SftpFileTransfer $this$sftpFile) {
                        Intrinsics.checkNotNullParameter((Object)$this$sftpFile, (String)"$receiver");
                        this.this$0.$options.invoke((Object)$this$sftpFile);
                        $this$sftpFile.download(this.this$0.$url, this.$it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$it = file2;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = resolver;
                this.$options = function1;
                this.$url = string2;
                super(1);
            }
        }));
    }

    @NotNull
    public final FileResolution downloadSmb(@NotNull String url, @NotNull Function1<? super SmbFileTransfer, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        return this.resolveFileUrl(url, true, (Function1<File, Unit>)((Function1)new Function1<File, Unit>(this, options2, url){
            final /* synthetic */ Resolver this$0;
            final /* synthetic */ Function1 $options;
            final /* synthetic */ String $url;

            public final void invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getCommon().smbFile((Function1)new Function1<SmbFileTransfer, Unit>(this, it){
                    final /* synthetic */ downloadSmb.1 this$0;
                    final /* synthetic */ File $it;

                    public final void invoke(@NotNull SmbFileTransfer $this$smbFile) {
                        Intrinsics.checkNotNullParameter((Object)$this$smbFile, (String)"$receiver");
                        this.this$0.$options.invoke((Object)$this$smbFile);
                        $this$smbFile.download(this.this$0.$url, this.$it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$it = file2;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = resolver;
                this.$options = function1;
                this.$url = string2;
                super(1);
            }
        }));
    }

    @NotNull
    public final FileResolution useLocal(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file2 = this.project.file((Object)path);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.file(path)");
        return this.useLocal(file2);
    }

    @NotNull
    public final FileResolution useLocal(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.useLocal(sourceFile, true);
    }

    @NotNull
    public final FileResolution useLocalBy(@NotNull Object dir2, @NotNull Iterable<String> filePatterns, @NotNull Function1<? super Iterable<? extends File>, ? extends File> selector) {
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter(filePatterns, (String)"filePatterns");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return this.resolveFile(CollectionsKt.listOf((Object[])new Object[]{dir2, filePatterns}), true, (Function1<FileResolution, File>)((Function1)new Function1<FileResolution, File>(this, dir2, filePatterns, selector){
            final /* synthetic */ Resolver this$0;
            final /* synthetic */ Object $dir;
            final /* synthetic */ Iterable $filePatterns;
            final /* synthetic */ Function1 $selector;

            @NotNull
            public final File invoke(@NotNull FileResolution it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ConfigurableFileTree configurableFileTree = this.this$0.getCommon().getProject().fileTree(this.$dir, (Action)new Action<ConfigurableFileTree>(this){
                    final /* synthetic */ useLocalBy.1 this$0;

                    public final void execute(ConfigurableFileTree it) {
                        it.include(this.this$0.$filePatterns);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Function1 function1 = this.$selector;
                boolean bl = false;
                boolean bl2 = false;
                File file2 = (File)function1.invoke((Object)configurableFileTree);
                if (file2 == null) {
                    throw (Throwable)((Object)new FileException("Cannot find any local file under directory '" + this.$dir + "' matching file pattern '" + this.$filePatterns + "'!"));
                }
                return file2;
            }
            {
                this.this$0 = resolver;
                this.$dir = object;
                this.$filePatterns = iterable;
                this.$selector = function1;
                super(1);
            }
        }));
    }

    @NotNull
    public final FileResolution useLocalBy(@NotNull Object dir2, @NotNull Function1<? super Iterable<? extends File>, ? extends File> selector) {
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Object object = this.localFilePatterns.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"localFilePatterns.get()");
        return this.useLocalBy(dir2, (Iterable)object, selector);
    }

    @NotNull
    public final FileResolution useLocalLastNamed(@NotNull Object dir2) {
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        return this.useLocalBy(dir2, (Function1<Iterable<File>, File>)((Function1)useLocalLastNamed.1.INSTANCE));
    }

    @NotNull
    public final FileResolution useLocalLastModified(@NotNull Object dir2) {
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        return this.useLocalBy(dir2, (Function1<Iterable<File>, File>)((Function1)useLocalLastModified.1.INSTANCE));
    }

    @NotNull
    public final FileResolution useLocalRecent(@NotNull Object dir2) {
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        return this.useLocalLastModified(dir2);
    }

    public final void config(@NotNull Function1<? super G, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        G g = this.getGroupCurrent();
        boolean bl = false;
        boolean bl2 = false;
        configurer.invoke(g);
    }

    private final synchronized G groupNamed(String name) {
        Object object;
        Object v0;
        boolean bl;
        Iterable<Object> iterable;
        block2: {
            iterable = this.groupList;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                FileGroup it = (FileGroup)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (FileGroup)v0) == null) {
            iterable = this.createGroup(name);
            bl = false;
            boolean bl4 = false;
            Iterable<Object> $this$apply = iterable;
            boolean bl5 = false;
            this.groupList.add($this$apply);
            object = iterable;
        }
        return (G)object;
    }

    public final synchronized void group(@NotNull String name, @NotNull Function1<? super Resolver<G>, Unit> configurer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        this.setGroupCurrent(this.groupNamed(name));
        Resolver resolver = this;
        boolean bl = false;
        boolean bl2 = false;
        configurer.invoke((Object)resolver);
        this.setGroupCurrent(this.getGroupDefault());
    }

    public final void invoke(@NotNull String $this$invoke, @NotNull Function1<? super Resolver<G>, Unit> groupDefiner) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        Intrinsics.checkNotNullParameter(groupDefiner, (String)"groupDefiner");
        this.group($this$invoke, groupDefiner);
    }

    public final void invoke(@NotNull String $this$invoke, Object ... values) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.group($this$invoke, (Function1)new Function1<Resolver<G>, Unit>(values){
            final /* synthetic */ Object[] $values;

            public final void invoke(@NotNull Resolver<G> $this$group) {
                Intrinsics.checkNotNullParameter($this$group, (String)"$receiver");
                $this$group.getAll(new Object[]{this.$values});
            }
            {
                this.$values = objectArray;
                super(1);
            }
        });
    }

    public final void invoke(@NotNull String $this$invoke, @NotNull Object value, @NotNull Function1<? super G, Unit> groupOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(groupOptions, (String)"groupOptions");
        this.group($this$invoke, (Function1)new Function1<Resolver<G>, Unit>(value, groupOptions){
            final /* synthetic */ Object $value;
            final /* synthetic */ Function1 $groupOptions;

            public final void invoke(@NotNull Resolver<G> $this$group) {
                Intrinsics.checkNotNullParameter($this$group, (String)"$receiver");
                $this$group.get(this.$value);
                $this$group.config(this.$groupOptions);
            }
            {
                this.$value = object;
                this.$groupOptions = function1;
                super(1);
            }
        });
    }

    public final void invoke(@NotNull String $this$invoke, @NotNull Iterable<? extends Object> values, @NotNull Function1<? super G, Unit> groupOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter(groupOptions, (String)"groupOptions");
        this.group($this$invoke, (Function1)new Function1<Resolver<G>, Unit>(values, groupOptions){
            final /* synthetic */ Iterable $values;
            final /* synthetic */ Function1 $groupOptions;

            public final void invoke(@NotNull Resolver<G> $this$group) {
                Intrinsics.checkNotNullParameter($this$group, (String)"$receiver");
                $this$group.getAll(this.$values);
                $this$group.config(this.$groupOptions);
            }
            {
                this.$values = iterable;
                this.$groupOptions = function1;
                super(1);
            }
        });
    }

    public static /* synthetic */ void invoke$default(Resolver resolver, String string2, Iterable iterable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invoke");
        }
        if ((n & 2) != 0) {
            function1 = invoke.3.INSTANCE;
        }
        resolver.invoke(string2, iterable, function1);
    }

    public final void group(@NotNull String name, @NotNull String downloadUrl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
        this.group(name, (Function1)new Function1<Resolver<G>, Unit>(downloadUrl){
            final /* synthetic */ String $downloadUrl;

            public final void invoke(@NotNull Resolver<G> $this$group) {
                Intrinsics.checkNotNullParameter($this$group, (String)"$receiver");
                $this$group.download(this.$downloadUrl);
            }
            {
                this.$downloadUrl = string2;
                super(1);
            }
        });
    }

    @NotNull
    public abstract G createGroup(@NotNull String var1);

    private final FileResolution resolveFile(Object hash, boolean parallel, Function1<? super FileResolution, ? extends File> resolver) {
        String id = Formats.INSTANCE.toHashCodeHex(hash);
        if (!parallel) {
            ((FileGroup)this.getGroupCurrent()).setParallelable$common_plugin(false);
        }
        G g = this.getGroupCurrent();
        String string2 = id;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
        return ((FileGroup)g).resolve(string2, resolver);
    }

    private final FileResolution resolveFileUrl(String url, boolean parallel, Function1<? super File, Unit> resolver) {
        return this.resolveFile(url, parallel, (Function1<FileResolution, File>)((Function1)new Function1<FileResolution, File>(url, resolver){
            final /* synthetic */ String $url;
            final /* synthetic */ Function1 $resolver;

            @NotNull
            public final File invoke(@NotNull FileResolution it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                File file2 = new File(it.getDir(), FilenameUtils.getName((String)this.$url));
                boolean bl = false;
                boolean bl2 = false;
                File $this$apply = file2;
                boolean bl3 = false;
                this.$resolver.invoke((Object)$this$apply);
                return file2;
            }
            {
                this.$url = string2;
                this.$resolver = function1;
                super(1);
            }
        }));
    }

    private final FileResolution useLocal(File sourceFile, boolean parallel) {
        String string2 = sourceFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceFile.absolutePath");
        return this.resolveFile(string2, parallel, (Function1<FileResolution, File>)((Function1)new Function1<FileResolution, File>(sourceFile){
            final /* synthetic */ File $sourceFile;

            @NotNull
            public final File invoke(@NotNull FileResolution it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$sourceFile;
            }
            {
                this.$sourceFile = file2;
                super(1);
            }
        }));
    }

    @NotNull
    public final CommonExtension getCommon() {
        return this.common;
    }

    public Resolver(@NotNull CommonExtension common) {
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        this.common = common;
        this.downloadDir = this.common.getObj().buildDir(DOWNLOAD_DIR_DEFAULT);
        this.project = this.common.getProject();
        boolean bl = false;
        this.groupList = new ArrayList();
        this.parallelLevel = this.common.getObj().int((Function1<? super Property<Integer>, Unit>)((Function1)new Function1<Property<Integer>, Unit>(this){
            final /* synthetic */ Resolver this$0;

            public final void invoke(@NotNull Property<Integer> $this$int) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$int, (String)"$receiver");
                    $this$int.convention((Object)3);
                    Integer n = this.this$0.getCommon().getProp().int("resolver.parallelLevel");
                    if (n == null) break block0;
                    Integer n2 = n;
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = ((Number)n2).intValue();
                    boolean bl3 = false;
                    $this$int.set((Object)it);
                }
            }
            {
                this.this$0 = resolver;
                super(1);
            }
        }));
        this.localFilePatterns = this.common.getObj().strings((Function1<? super ListProperty<String>, Unit>)((Function1)new Function1<ListProperty<String>, Unit>(this){
            final /* synthetic */ Resolver this$0;

            public final void invoke(@NotNull ListProperty<String> $this$strings) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$strings, (String)"$receiver");
                    $this$strings.convention((Iterable)CollectionsKt.listOf((Object[])new String[]{"**/*.zip", "**/*.jar"}));
                    List list2 = PropertyParser.list$default(this.this$0.getCommon().getProp(), "resolver.localFilePatterns", null, 2, null);
                    if (list2 == null) break block0;
                    List list3 = list2;
                    boolean bl = false;
                    boolean bl2 = false;
                    List it = list3;
                    boolean bl3 = false;
                    $this$strings.set((Iterable)it);
                }
            }
            {
                this.this$0 = resolver;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/cognifide/gradle/common/file/resolver/Resolver$Companion;", "", "()V", "DOWNLOAD_DIR_DEFAULT", "", "GROUP_DEFAULT", "common-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

