/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common;

import com.cognifide.gradle.common.CommonException;
import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.build.BuildScope;
import com.cognifide.gradle.common.build.ObjectFactory;
import com.cognifide.gradle.common.build.Parallel;
import com.cognifide.gradle.common.build.ProgressCountdown;
import com.cognifide.gradle.common.build.ProgressIndicator;
import com.cognifide.gradle.common.build.ProgressLogger;
import com.cognifide.gradle.common.build.PropertyParser;
import com.cognifide.gradle.common.build.Retry;
import com.cognifide.gradle.common.build.ServiceAccessor;
import com.cognifide.gradle.common.file.FileWatcher;
import com.cognifide.gradle.common.file.resolver.FileResolver;
import com.cognifide.gradle.common.file.transfer.FileTransferManager;
import com.cognifide.gradle.common.file.transfer.http.HttpFileTransfer;
import com.cognifide.gradle.common.file.transfer.sftp.SftpFileTransfer;
import com.cognifide.gradle.common.file.transfer.smb.SmbFileTransfer;
import com.cognifide.gradle.common.health.HealthChecker;
import com.cognifide.gradle.common.health.HealthStatus;
import com.cognifide.gradle.common.http.HttpClient;
import com.cognifide.gradle.common.java.JavaSupport;
import com.cognifide.gradle.common.mvn.MvnInvoker;
import com.cognifide.gradle.common.notifier.NotifierFacade;
import com.cognifide.gradle.common.tasks.TaskFacade;
import com.cognifide.gradle.common.utils.Formats;
import com.cognifide.gradle.common.utils.Patterns;
import com.cognifide.gradle.common.utils.UtilsKt;
import com.cognifide.gradle.common.zip.ZipFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u008e\u00012\u00020\u0001:\u0002\u008e\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020;2\b\b\u0002\u0010F\u001a\u00020GJ\u001f\u0010\t\u001a\u00020H2\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ%\u0010L\u001a\b\u0012\u0004\u0012\u00020N0M2\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ*\u0010P\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0017\u0010R\u001a\u0013\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u0002HQ0J\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010TJ*\u0010U\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0017\u0010R\u001a\u0013\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u0002HQ0J\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010TJ\u001f\u0010\u0011\u001a\u00020H2\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ\u001f\u0010W\u001a\u00020H2\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ\u001f\u0010\u001c\u001a\u00020H2\u0017\u0010Y\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ*\u0010Z\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0017\u0010[\u001a\u0013\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u0002HQ0J\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010TJ2\u0010Z\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0006\u0010]\u001a\u00020^2\u0017\u0010[\u001a\u0013\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u0002HQ0J\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010_J2\u0010Z\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0006\u0010]\u001a\u00020`2\u0017\u0010[\u001a\u0013\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u0002HQ0J\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010aJ\u001f\u0010b\u001a\u00020H2\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020c\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ\u000e\u0010b\u001a\u00020H2\u0006\u0010d\u001a\u00020`J*\u0010e\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0017\u0010[\u001a\u0013\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u0002HQ0J\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010TJ*\u0010f\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0017\u0010[\u001a\u0013\u0012\u0004\u0012\u00020g\u0012\u0004\u0012\u0002HQ0J\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010TJ3\u0010h\u001a\n \u0019*\u0004\u0018\u00010i0i2\u001e\u0010j\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020;0l0k\"\b\u0012\u0004\u0012\u00020;0l\u00a2\u0006\u0002\u0010mJ\"\u0010h\u001a\n \u0019*\u0004\u0018\u00010i0i2\u0012\u0010j\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0l0nJ\u000e\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020DJ\u001e\u0010o\u001a\u00020p\"\b\b\u0000\u0010Q*\u00020\u00012\f\u0010r\u001a\b\u0012\u0004\u0012\u0002HQ0lJ\u001e\u0010s\u001a\u00020;2\u0006\u0010t\u001a\u00020;2\u000e\b\u0002\u0010u\u001a\b\u0012\u0004\u0012\u00020D0nJ\u001e\u0010s\u001a\u00020;2\u0006\u0010v\u001a\u00020D2\u000e\b\u0002\u0010u\u001a\b\u0012\u0004\u0012\u00020D0nJ$\u0010w\u001a\b\u0012\u0004\u0012\u00020;0l2\u0006\u0010t\u001a\u00020;2\u000e\b\u0002\u0010u\u001a\b\u0012\u0004\u0012\u00020D0nJ$\u0010w\u001a\b\u0012\u0004\u0012\u00020;0l2\u0006\u0010v\u001a\u00020D2\u000e\b\u0002\u0010u\u001a\b\u0012\u0004\u0012\u00020D0nJ/\u0010x\u001a\u00020i2\u0012\u0010y\u001a\n\u0012\u0006\b\u0001\u0012\u00020;0k\"\u00020;2\u000e\b\u0002\u0010u\u001a\b\u0012\u0004\u0012\u00020D0n\u00a2\u0006\u0002\u0010zJ$\u0010x\u001a\u00020i2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020;0n2\u000e\b\u0002\u0010u\u001a\b\u0012\u0004\u0012\u00020D0nJ\u001f\u0010{\u001a\u00020;2\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020|\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ\u000e\u0010{\u001a\u00020;2\u0006\u0010}\u001a\u00020\u0001J%\u0010~\u001a\b\u0012\u0004\u0012\u00020;0M2\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020|\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ&\u0010~\u001a\b\u0012\u0004\u0012\u00020;0M2\u0012\u0010\u007f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010k\"\u00020\u0001\u00a2\u0006\u0003\u0010\u0080\u0001J\u001a\u0010~\u001a\b\u0012\u0004\u0012\u00020;0M2\f\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020\u00010nJ$\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u001a\b\u0002\u0010I\u001a\u0014\u0012\u0005\u0012\u00030\u0082\u0001\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ,\u0010\u0083\u0001\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0018\u0010R\u001a\u0014\u0012\u0005\u0012\u00030\u0084\u0001\u0012\u0004\u0012\u0002HQ0J\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010TJ,\u0010\u0085\u0001\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0018\u0010R\u001a\u0014\u0012\u0005\u0012\u00030\u0086\u0001\u0012\u0004\u0012\u0002HQ0J\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010TJ\u001f\u00106\u001a\u00020H2\u0017\u0010Y\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ\u0010\u0010\u0087\u0001\u001a\u00020;2\u0007\u0010\u0088\u0001\u001a\u00020DJ\u000f\u0010\u0089\u0001\u001a\u00020H2\u0006\u0010d\u001a\u00020`J!\u0010\u008a\u0001\u001a\u00020H2\u0018\u0010I\u001a\u0014\u0012\u0005\u0012\u00030\u008b\u0001\u0012\u0004\u0012\u00020H0J\u00a2\u0006\u0002\bKJ\u0010\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u0010E\u001a\u00020;J\u0011\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0007\u0010\u0088\u0001\u001a\u00020DR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u000207\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010:\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u001b\u0010>\u001a\u00020?8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010\u0016\u001a\u0004\b@\u0010A\u00a8\u0006\u008f\u0001"}, d2={"Lcom/cognifide/gradle/common/CommonExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "buildScope", "Lcom/cognifide/gradle/common/build/BuildScope;", "getBuildScope", "()Lcom/cognifide/gradle/common/build/BuildScope;", "fileTransfer", "Lcom/cognifide/gradle/common/file/transfer/FileTransferManager;", "getFileTransfer", "()Lcom/cognifide/gradle/common/file/transfer/FileTransferManager;", "formats", "Lcom/cognifide/gradle/common/utils/Formats;", "getFormats", "()Lcom/cognifide/gradle/common/utils/Formats;", "javaSupport", "Lcom/cognifide/gradle/common/java/JavaSupport;", "getJavaSupport", "()Lcom/cognifide/gradle/common/java/JavaSupport;", "javaSupport$delegate", "Lkotlin/Lazy;", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "notifier", "Lcom/cognifide/gradle/common/notifier/NotifierFacade;", "getNotifier", "()Lcom/cognifide/gradle/common/notifier/NotifierFacade;", "obj", "Lcom/cognifide/gradle/common/build/ObjectFactory;", "getObj", "()Lcom/cognifide/gradle/common/build/ObjectFactory;", "parallel", "Lcom/cognifide/gradle/common/build/Parallel;", "getParallel", "()Lcom/cognifide/gradle/common/build/Parallel;", "patterns", "Lcom/cognifide/gradle/common/utils/Patterns;", "getPatterns", "()Lcom/cognifide/gradle/common/utils/Patterns;", "getProject", "()Lorg/gradle/api/Project;", "prop", "Lcom/cognifide/gradle/common/build/PropertyParser;", "getProp", "()Lcom/cognifide/gradle/common/build/PropertyParser;", "services", "Lcom/cognifide/gradle/common/build/ServiceAccessor;", "getServices", "()Lcom/cognifide/gradle/common/build/ServiceAccessor;", "tasks", "Lcom/cognifide/gradle/common/tasks/TaskFacade;", "getTasks", "()Lcom/cognifide/gradle/common/tasks/TaskFacade;", "temporaryDir", "Ljava/io/File;", "getTemporaryDir", "()Ljava/io/File;", "userInput", "Lorg/gradle/api/internal/tasks/userinput/UserInputHandler;", "getUserInput", "()Lorg/gradle/api/internal/tasks/userinput/UserInputHandler;", "userInput$delegate", "checksumFile", "", "file", "recalculate", "", "", "options", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "healthCheck", "", "Lcom/cognifide/gradle/common/health/HealthStatus;", "Lcom/cognifide/gradle/common/health/HealthChecker;", "http", "T", "consumer", "Lcom/cognifide/gradle/common/http/HttpClient;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "httpFile", "Lcom/cognifide/gradle/common/file/transfer/http/HttpFileTransfer;", "mvn", "Lcom/cognifide/gradle/common/mvn/MvnInvoker;", "configurer", "progress", "action", "Lcom/cognifide/gradle/common/build/ProgressIndicator;", "total", "", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "", "(JLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "progressCountdown", "Lcom/cognifide/gradle/common/build/ProgressCountdown;", "time", "progressIndicator", "progressLogger", "Lcom/cognifide/gradle/common/build/ProgressLogger;", "providedFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "providers", "", "Lorg/gradle/api/provider/Provider;", "([Lorg/gradle/api/provider/Provider;)Lorg/gradle/api/file/ConfigurableFileCollection;", "", "publicationArtifact", "Lorg/gradle/api/internal/artifacts/dsl/LazyPublishArtifact;", "taskPath", "provider", "recentFile", "dir", "filePatterns", "dirPath", "recentFileProvider", "recentFiles", "dirs", "([Ljava/io/File;Ljava/lang/Iterable;)Lorg/gradle/api/file/ConfigurableFileCollection;", "resolveFile", "Lcom/cognifide/gradle/common/file/resolver/FileResolver;", "value", "resolveFiles", "values", "([Ljava/lang/Object;)Ljava/util/List;", "retry", "Lcom/cognifide/gradle/common/build/Retry;", "sftpFile", "Lcom/cognifide/gradle/common/file/transfer/sftp/SftpFileTransfer;", "smbFile", "Lcom/cognifide/gradle/common/file/transfer/smb/SmbFileTransfer;", "temporaryFile", "path", "waitFor", "watchFiles", "Lcom/cognifide/gradle/common/file/FileWatcher;", "zip", "Lcom/cognifide/gradle/common/zip/ZipFile;", "Companion", "common-plugin"})
public class CommonExtension {
    private final Logger logger;
    @NotNull
    private final PropertyParser prop;
    @NotNull
    private final ObjectFactory obj;
    @NotNull
    private final ServiceAccessor services;
    @NotNull
    private final FileTransferManager fileTransfer;
    @NotNull
    private final NotifierFacade notifier;
    @NotNull
    private final TaskFacade tasks;
    @NotNull
    private final Lazy javaSupport$delegate;
    @NotNull
    private final Lazy userInput$delegate;
    @NotNull
    private final Parallel parallel;
    @NotNull
    private final Formats formats;
    @NotNull
    private final Patterns patterns;
    @NotNull
    private final BuildScope buildScope;
    @NotNull
    private final Project project;
    @NotNull
    public static final String NAME = "common";
    @NotNull
    public static final String TEMPORARY_DIR = "tmp";
    @NotNull
    private static final List<String> RECENT_FILE_PATTERNS;
    private static final List<String> PLUGIN_IDS;
    @NotNull
    public static final Companion Companion;

    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final PropertyParser getProp() {
        return this.prop;
    }

    @NotNull
    public final ObjectFactory getObj() {
        return this.obj;
    }

    @NotNull
    public final ServiceAccessor getServices() {
        return this.services;
    }

    @NotNull
    public final FileTransferManager getFileTransfer() {
        return this.fileTransfer;
    }

    public final void fileTransfer(@NotNull Function1<? super FileTransferManager, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        UtilsKt.using(this.fileTransfer, options2);
    }

    @NotNull
    public final NotifierFacade getNotifier() {
        return this.notifier;
    }

    public final void notifier(@NotNull Function1<? super NotifierFacade, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        UtilsKt.using(this.notifier, configurer);
    }

    @NotNull
    public final TaskFacade getTasks() {
        return this.tasks;
    }

    public final void tasks(@NotNull Function1<? super TaskFacade, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        TaskFacade taskFacade = this.tasks;
        boolean bl = false;
        boolean bl2 = false;
        configurer.invoke((Object)taskFacade);
    }

    @NotNull
    public final JavaSupport getJavaSupport() {
        Lazy lazy = this.javaSupport$delegate;
        CommonExtension commonExtension = this;
        Object var3_3 = null;
        boolean bl = false;
        return (JavaSupport)lazy.getValue();
    }

    public final void javaSupport(@NotNull Function1<? super JavaSupport, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        UtilsKt.using(this.getJavaSupport(), options2);
    }

    @NotNull
    public final <T> LazyPublishArtifact publicationArtifact(@NotNull Provider<T> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        return new LazyPublishArtifact(provider);
    }

    @NotNull
    public final LazyPublishArtifact publicationArtifact(@NotNull String taskPath) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        TaskProvider taskProvider = this.project.getTasks().named(taskPath);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.named(taskPath)");
        return this.publicationArtifact((Provider)taskProvider);
    }

    public final <T> T progress(int total, @NotNull Function1<? super ProgressIndicator, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.progress((long)total, action);
    }

    public final <T> T progress(long total, @NotNull Function1<? super ProgressIndicator, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ProgressIndicator progressIndicator = new ProgressIndicator(this.project);
        boolean bl = false;
        boolean bl2 = false;
        ProgressIndicator $this$apply = progressIndicator;
        boolean bl3 = false;
        $this$apply.setTotal(total);
        return progressIndicator.launch(action);
    }

    public final <T> T progress(@NotNull Function1<? super ProgressIndicator, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.progressIndicator(action);
    }

    public final <T> T progressIndicator(@NotNull Function1<? super ProgressIndicator, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return new ProgressIndicator(this.project).launch(action);
    }

    public final <T> T progressLogger(@NotNull Function1<? super ProgressLogger, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return ProgressLogger.Companion.of(this.project).launch(action);
    }

    @NotNull
    public final UserInputHandler getUserInput() {
        Lazy lazy = this.userInput$delegate;
        CommonExtension commonExtension = this;
        Object var3_3 = null;
        boolean bl = false;
        return (UserInputHandler)lazy.getValue();
    }

    public final void waitFor(long time) {
        this.progressCountdown(time);
    }

    public final void progressCountdown(long time) {
        this.progressCountdown((Function1<? super ProgressCountdown, Unit>)((Function1)new Function1<ProgressCountdown, Unit>(time){
            final /* synthetic */ long $time;

            public final void invoke(@NotNull ProgressCountdown $this$progressCountdown) {
                Intrinsics.checkNotNullParameter((Object)$this$progressCountdown, (String)"$receiver");
                $this$progressCountdown.setTime(this.$time);
            }
            {
                this.$time = l;
                super(1);
            }
        }));
    }

    public final void progressCountdown(@NotNull Function1<? super ProgressCountdown, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        ProgressCountdown progressCountdown2 = new ProgressCountdown(this.project);
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)progressCountdown2);
        progressCountdown2.run();
    }

    @NotNull
    public final File temporaryFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FilesKt.resolve((File)this.getTemporaryDir(), (String)path);
    }

    @NotNull
    public final String checksumFile(@NotNull File file2, boolean recalculate) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object t = this.progress((Function1)new Function1<ProgressIndicator, String>(file2, recalculate){
            final /* synthetic */ File $file;
            final /* synthetic */ boolean $recalculate;

            public final String invoke(@NotNull ProgressIndicator $this$progress) {
                Intrinsics.checkNotNullParameter((Object)$this$progress, (String)"$receiver");
                $this$progress.setStep("Calculating checksum");
                $this$progress.setMessage("File '" + this.$file.getName() + '\'');
                return Formats.INSTANCE.checksum(this.$file, this.$recalculate);
            }
            {
                this.$file = file2;
                this.$recalculate = bl;
                super(1);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"progress {\n        step \u2026(file, recalculate)\n    }");
        return (String)t;
    }

    public static /* synthetic */ String checksumFile$default(CommonExtension commonExtension, File file2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checksumFile");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return commonExtension.checksumFile(file2, bl);
    }

    @NotNull
    public final File getTemporaryDir() {
        File file2 = this.project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.buildDir");
        return FilesKt.resolve((File)file2, (String)TEMPORARY_DIR);
    }

    @NotNull
    public final File recentFile(@NotNull String dirPath, @NotNull Iterable<String> filePatterns) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        Intrinsics.checkNotNullParameter(filePatterns, (String)"filePatterns");
        File file2 = this.project.file((Object)dirPath);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.file(dirPath)");
        return this.recentFile(file2, filePatterns);
    }

    public static /* synthetic */ File recentFile$default(CommonExtension commonExtension, String string2, Iterable iterable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: recentFile");
        }
        if ((n & 2) != 0) {
            iterable = RECENT_FILE_PATTERNS;
        }
        return commonExtension.recentFile(string2, (Iterable<String>)iterable);
    }

    @NotNull
    public final File recentFile(@NotNull File dir2, @NotNull Iterable<String> filePatterns) {
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter(filePatterns, (String)"filePatterns");
        File file2 = (File)this.recentFileProvider(dir2, filePatterns).getOrNull();
        if (file2 == null) {
            throw (Throwable)((Object)new CommonException("No recent files available in directory '" + dir2 + "' matching file pattern(s): " + filePatterns + '!'));
        }
        return file2;
    }

    public static /* synthetic */ File recentFile$default(CommonExtension commonExtension, File file2, Iterable iterable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: recentFile");
        }
        if ((n & 2) != 0) {
            iterable = RECENT_FILE_PATTERNS;
        }
        return commonExtension.recentFile(file2, (Iterable<String>)iterable);
    }

    @NotNull
    public final Provider<File> recentFileProvider(@NotNull String dirPath, @NotNull Iterable<String> filePatterns) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        Intrinsics.checkNotNullParameter(filePatterns, (String)"filePatterns");
        File file2 = this.project.file((Object)dirPath);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.file(dirPath)");
        return this.recentFileProvider(file2, filePatterns);
    }

    public static /* synthetic */ Provider recentFileProvider$default(CommonExtension commonExtension, String string2, Iterable iterable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: recentFileProvider");
        }
        if ((n & 2) != 0) {
            iterable = RECENT_FILE_PATTERNS;
        }
        return commonExtension.recentFileProvider(string2, (Iterable<String>)iterable);
    }

    @NotNull
    public final Provider<File> recentFileProvider(@NotNull File dir2, @NotNull Iterable<String> filePatterns) {
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter(filePatterns, (String)"filePatterns");
        FileTree fileTree = this.project.fileTree((Object)dir2).matching((Action)new Action<PatternFilterable>(filePatterns){
            final /* synthetic */ Iterable $filePatterns;

            public final void execute(PatternFilterable it) {
                it.include(this.$filePatterns);
            }
            {
                this.$filePatterns = iterable;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"project.fileTree(dir)\n  \u2026t.include(filePatterns) }");
        Provider provider = fileTree.getElements().map((Transformer)recentFileProvider.2.INSTANCE).map((Transformer)recentFileProvider.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.fileTree(dir)\n  \u2026l { it.lastModified() } }");
        return provider;
    }

    public static /* synthetic */ Provider recentFileProvider$default(CommonExtension commonExtension, File file2, Iterable iterable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: recentFileProvider");
        }
        if ((n & 2) != 0) {
            iterable = RECENT_FILE_PATTERNS;
        }
        return commonExtension.recentFileProvider(file2, (Iterable<String>)iterable);
    }

    @NotNull
    public final ConfigurableFileCollection recentFiles(@NotNull File[] dirs, @NotNull Iterable<String> filePatterns) {
        Intrinsics.checkNotNullParameter((Object)dirs, (String)"dirs");
        Intrinsics.checkNotNullParameter(filePatterns, (String)"filePatterns");
        return this.recentFiles(ArraysKt.asIterable((Object[])dirs), filePatterns);
    }

    public static /* synthetic */ ConfigurableFileCollection recentFiles$default(CommonExtension commonExtension, File[] fileArray, Iterable iterable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: recentFiles");
        }
        if ((n & 2) != 0) {
            iterable = RECENT_FILE_PATTERNS;
        }
        return commonExtension.recentFiles(fileArray, (Iterable<String>)iterable);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConfigurableFileCollection recentFiles(@NotNull Iterable<? extends File> dirs, @NotNull Iterable<String> filePatterns) {
        Collection<Provider<File>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(dirs, (String)"dirs");
        Intrinsics.checkNotNullParameter(filePatterns, (String)"filePatterns");
        Iterable<? extends File> iterable = dirs;
        CommonExtension commonExtension = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Provider<File> provider = this.recentFileProvider((File)it, filePatterns);
            collection.add(provider);
        }
        collection = (List)destination$iv$iv;
        ConfigurableFileCollection configurableFileCollection = commonExtension.providedFiles((Iterable<? extends Provider<File>>)collection);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"providedFiles(dirs.map {\u2026ider(it, filePatterns) })");
        return configurableFileCollection;
    }

    public static /* synthetic */ ConfigurableFileCollection recentFiles$default(CommonExtension commonExtension, Iterable iterable, Iterable iterable2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: recentFiles");
        }
        if ((n & 2) != 0) {
            iterable2 = RECENT_FILE_PATTERNS;
        }
        return commonExtension.recentFiles(iterable, (Iterable<String>)iterable2);
    }

    public final ConfigurableFileCollection providedFiles(Provider<File> ... providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        return this.providedFiles(ArraysKt.asIterable((Object[])providers));
    }

    public final ConfigurableFileCollection providedFiles(@NotNull Iterable<? extends Provider<File>> providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        return this.obj.files((Function1<? super ConfigurableFileCollection, Unit>)((Function1)new Function1<ConfigurableFileCollection, Unit>(this, providers){
            final /* synthetic */ CommonExtension this$0;
            final /* synthetic */ Iterable $providers;

            public final void invoke(@NotNull ConfigurableFileCollection $this$files) {
                Intrinsics.checkNotNullParameter((Object)$this$files, (String)"$receiver");
                $this$files.from(new Object[]{this.this$0.getObj().provider((Function0)new Function0<List<? extends File>>(this){
                    final /* synthetic */ providedFiles.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<File> invoke() {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = this.this$0.$providers;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            File file2;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            Provider it = (Provider)element$iv$iv;
                            boolean bl2 = false;
                            if ((File)it.getOrNull() == null) continue;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            File it$iv$iv = file2;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                })});
            }
            {
                this.this$0 = commonExtension;
                this.$providers = iterable;
                super(1);
            }
        }));
    }

    @NotNull
    public final Retry retry(@NotNull Function1<? super Retry, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        Retry retry2 = new Retry(this);
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)retry2);
        return retry2;
    }

    public static /* synthetic */ Retry retry$default(CommonExtension commonExtension, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: retry");
        }
        if ((n & 1) != 0) {
            function1 = retry.1.INSTANCE;
        }
        return commonExtension.retry((Function1<? super Retry, Unit>)function1);
    }

    public final void watchFiles(@NotNull Function1<? super FileWatcher, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        FileWatcher fileWatcher = new FileWatcher(this);
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)fileWatcher);
        fileWatcher.start();
    }

    @NotNull
    public final File resolveFile(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.resolveFile((Function1<? super FileResolver, Unit>)((Function1)new Function1<FileResolver, Unit>(value){
            final /* synthetic */ Object $value;

            public final void invoke(@NotNull FileResolver $this$resolveFile) {
                Intrinsics.checkNotNullParameter((Object)$this$resolveFile, (String)"$receiver");
                $this$resolveFile.get(this.$value);
            }
            {
                this.$value = object;
                super(1);
            }
        }));
    }

    @NotNull
    public final File resolveFile(@NotNull Function1<? super FileResolver, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        File file2 = (File)CollectionsKt.firstOrNull(this.resolveFiles(options2));
        if (file2 == null) {
            throw (Throwable)((Object)new CommonException("File not resolved!"));
        }
        return file2;
    }

    @NotNull
    public final List<File> resolveFiles(Object ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.resolveFiles(ArraysKt.asIterable((Object[])values));
    }

    @NotNull
    public final List<File> resolveFiles(@NotNull Iterable<? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.resolveFiles((Function1<? super FileResolver, Unit>)((Function1)new Function1<FileResolver, Unit>(values){
            final /* synthetic */ Iterable $values;

            public final void invoke(@NotNull FileResolver $this$resolveFiles) {
                Intrinsics.checkNotNullParameter((Object)$this$resolveFiles, (String)"$receiver");
                Iterable $this$forEach$iv = this.$values;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    $this$resolveFiles.get(it);
                }
            }
            {
                this.$values = iterable;
                super(1);
            }
        }));
    }

    @NotNull
    public final List<File> resolveFiles(@NotNull Function1<? super FileResolver, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        FileResolver fileResolver = new FileResolver(this);
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)fileResolver);
        return fileResolver.getFiles();
    }

    public final <T> T http(@NotNull Function1<? super HttpClient, ? extends T> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        HttpClient httpClient = new HttpClient(this);
        boolean bl = false;
        boolean bl2 = false;
        return (T)consumer.invoke((Object)httpClient);
    }

    public final <T> T httpFile(@NotNull Function1<? super HttpFileTransfer, ? extends T> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return this.fileTransfer.getFactory().http(consumer);
    }

    public final <T> T sftpFile(@NotNull Function1<? super SftpFileTransfer, ? extends T> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return this.fileTransfer.getFactory().sftp(consumer);
    }

    public final <T> T smbFile(@NotNull Function1<? super SmbFileTransfer, ? extends T> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return this.fileTransfer.getFactory().smb(consumer);
    }

    @NotNull
    public final ZipFile zip(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new ZipFile(file2);
    }

    @NotNull
    public final ZipFile zip(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file2 = this.project.file((Object)path);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.file(path)");
        return this.zip(file2);
    }

    @NotNull
    public final List<HealthStatus> healthCheck(@NotNull Function1<? super HealthChecker, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        HealthChecker healthChecker = new HealthChecker(this);
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)healthChecker);
        return HealthChecker.start$default(healthChecker, false, null, 3, null);
    }

    public final void mvn(@NotNull Function1<? super MvnInvoker, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        MvnInvoker mvnInvoker = new MvnInvoker(this);
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)mvnInvoker);
        mvnInvoker.invoke();
    }

    @NotNull
    public final Parallel getParallel() {
        return this.parallel;
    }

    @NotNull
    public final Formats getFormats() {
        return this.formats;
    }

    @NotNull
    public final Patterns getPatterns() {
        return this.patterns;
    }

    @NotNull
    public final BuildScope getBuildScope() {
        return this.buildScope;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public CommonExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.logger = this.project.getLogger();
        this.prop = new PropertyParser(this.project);
        this.obj = new ObjectFactory(this.project);
        this.services = new ServiceAccessor(this.project);
        this.fileTransfer = new FileTransferManager(this);
        this.notifier = NotifierFacade.Companion.of(this);
        this.tasks = new TaskFacade(this.project);
        this.javaSupport$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JavaSupport>(this){
            final /* synthetic */ CommonExtension this$0;

            @NotNull
            public final JavaSupport invoke() {
                return new JavaSupport(this.this$0);
            }
            {
                this.this$0 = commonExtension;
                super(0);
            }
        }));
        this.userInput$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UserInputHandler>(this){
            final /* synthetic */ CommonExtension this$0;

            @NotNull
            public final UserInputHandler invoke() {
                ServiceAccessor this_$iv = new ServiceAccessor(this.this$0.getProject());
                boolean $i$f$get = false;
                Object object = this_$iv.invoke(this_$iv.getServiceFactory(), "get", UserInputHandler.class);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.internal.tasks.userinput.UserInputHandler");
                }
                return (UserInputHandler)object;
            }
            {
                this.this$0 = commonExtension;
                super(0);
            }
        }));
        this.parallel = Parallel.INSTANCE;
        this.formats = Formats.INSTANCE;
        this.patterns = Patterns.INSTANCE;
        this.buildScope = BuildScope.Companion.of(this.project);
    }

    static {
        Companion = new Companion(null);
        RECENT_FILE_PATTERNS = CollectionsKt.listOf((Object[])new String[]{"*.jar", "*.zip", "*.war", "*.ear"});
        PLUGIN_IDS = CollectionsKt.listOf((Object)"com.cognifide.common");
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/cognifide/gradle/common/CommonExtension$Companion;", "", "()V", "NAME", "", "PLUGIN_IDS", "", "RECENT_FILE_PATTERNS", "getRECENT_FILE_PATTERNS", "()Ljava/util/List;", "TEMPORARY_DIR", "of", "Lcom/cognifide/gradle/common/CommonExtension;", "project", "Lorg/gradle/api/Project;", "common-plugin"})
    public static final class Companion {
        @NotNull
        public final List<String> getRECENT_FILE_PATTERNS() {
            return RECENT_FILE_PATTERNS;
        }

        @NotNull
        public final CommonExtension of(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            CommonExtension commonExtension = (CommonExtension)project.getExtensions().findByType(CommonExtension.class);
            if (commonExtension == null) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = project.getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.displayName");
                throw (Throwable)((Object)new CommonException(stringBuilder.append(StringsKt.capitalize((String)string2)).append(" must have at least one of following plugins applied: ").append(PLUGIN_IDS).toString()));
            }
            return commonExtension;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

