/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.services;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.IntentService;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import com.cogknit.fovea.dataModel.App;
import com.cogknit.fovea.providers.FoveaContract;
import com.cogknit.fovea.providers.FoveaDatabaseManager;
import com.cogknit.fovea.receivers.AlarmReceiver;
import com.cogknit.fovea.utils.FoveaLog;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScanAppUsageService
extends IntentService {
    private static final String TAG = "ScanAppUsageService";
    private HashMap<String, App> appUsage = null;
    private HashMap<String, App> newApps = null;
    private Uri mUri = FoveaContract.Apps.CONTENT_APP_URI;

    public ScanAppUsageService() {
        super(TAG);
        this.appUsage = new HashMap();
        this.newApps = new HashMap();
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=21)
    void pollAppLollipop() {
        String taskAppName = null;
        String taskPackageName = null;
        PackageInfo appPackageInfo = null;
        String usageStats = "usagestats";
        long foreground = 0L;
        long today = new Date().getTime();
        long yesterday = today - 86400000L;
        Date yesterdayDate = new Date(yesterday);
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(yesterdayDate);
        Calendar endCal = Calendar.getInstance();
        PackageManager pm = this.getPackageManager();
        UsageStatsManager mUsageStatsManager = (UsageStatsManager)this.getSystemService(usageStats);
        List stats = mUsageStatsManager.queryUsageStats(0, beginCal.getTimeInMillis(), endCal.getTimeInMillis());
        for (UsageStats usageStats2 : stats) {
            try {
                App app;
                taskPackageName = usageStats2.getPackageName();
                appPackageInfo = pm.getPackageInfo(taskPackageName, 0);
                taskAppName = appPackageInfo.applicationInfo.loadLabel(pm).toString();
                foreground = usageStats2.getTotalTimeInForeground() / 1000L;
                if (this.appUsage.containsKey(taskAppName)) {
                    app = this.appUsage.get(taskAppName);
                    app.addForegroundTime(foreground);
                    continue;
                }
                if (this.newApps.containsKey(taskAppName)) {
                    app = this.newApps.get(taskAppName);
                    app.addForegroundTime(foreground);
                    continue;
                }
                App newApp = new App(taskAppName, taskPackageName, foreground, "");
                this.newApps.put(taskAppName, newApp);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : this.appUsage.entrySet()) {
            String selection = "packageName = \"" + ((App)entry.getValue()).getPackageName() + "\"";
            FoveaDatabaseManager.update(this.getApplicationContext(), this.mUri, ((App)entry.getValue()).getContentValues(), selection, null);
        }
        for (Map.Entry entry : this.newApps.entrySet()) {
            FoveaDatabaseManager.insert(this.getApplicationContext(), this.mUri, ((App)entry.getValue()).getContentValues());
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected void onHandleIntent(Intent intent) {
        Cursor c = FoveaDatabaseManager.query(this.getApplicationContext(), this.mUri, null, null, null, null);
        while (c.moveToNext()) {
            String name = c.getString(c.getColumnIndex("name"));
            String pkgNm = c.getString(c.getColumnIndex("packageName"));
            long foreground = c.getLong(c.getColumnIndex("foregroundTime"));
            App app = new App(name, pkgNm, foreground, "");
            this.appUsage.put(name, app);
        }
        c.close();
        FoveaLog.v(TAG, "Capturing..");
        this.pollAppLollipop();
        AlarmReceiver.completeWakefulIntent((Intent)intent);
    }
}

