/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.services;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.os.IBinder;
import android.support.v4.content.LocalBroadcastManager;
import com.cogknit.fovea.dataModel.UserLocation;
import com.cogknit.fovea.providers.FoveaContract;
import com.cogknit.fovea.providers.FoveaDatabaseManager;
import com.cogknit.fovea.utils.FoveaLog;
import com.cogknit.fovea.utils.FusedLocationManager;
import com.cogknit.fovea.utils.LocationConstants;
import java.util.Iterator;
import java.util.LinkedList;

public class LocationController
extends Service {
    private FusedLocationManager manager;
    private ActivityQueue activityQueue;
    private int currentActivity;
    private ResponseReceiver receiver;
    public static final int QUEUE_SIZE = 3;
    private static final String TAG = "LocationController";

    public void onCreate() {
        super.onCreate();
        this.manager = new FusedLocationManager((Context)this);
        this.receiver = new ResponseReceiver();
        LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)this);
        broadcastManager.registerReceiver((BroadcastReceiver)this.receiver, new IntentFilter("com.cogknit.locationmodule.action.ACTIVITY_RESPONSE"));
        broadcastManager.registerReceiver((BroadcastReceiver)this.receiver, new IntentFilter("com.cogknit.locationmodule.action.LOCATION_RESPONSE"));
        this.activityQueue = new ActivityQueue();
        FoveaLog.v(TAG, "Initialized..");
    }

    public void onDestroy() {
        super.onDestroy();
        this.manager.shutDown();
        LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)this);
        broadcastManager.unregisterReceiver((BroadcastReceiver)this.receiver);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        FoveaLog.v(TAG, "Invoked..");
        this.manager.requestActivityUpdate(30000L);
        return 1;
    }

    public IBinder onBind(Intent arg0) {
        return null;
    }

    private void pushToQueue(int activity) {
        if (this.activityQueue.isQueueFull()) {
            this.activityQueue.remove();
        }
        this.activityQueue.add(activity);
        if (this.activityQueue.isQueueFull() && this.activityQueue.isHomogeneous()) {
            if (activity != this.currentActivity) {
                this.manager.requestLocationUpdate(LocationConstants.activityInterval[activity]);
                this.currentActivity = activity;
                FoveaLog.v(TAG, "New Activity: " + LocationConstants.activityText[activity]);
            }
            this.activityQueue.clear();
        }
    }

    private class ResponseReceiver
    extends BroadcastReceiver {
        private ResponseReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Location location;
            if (intent.getAction() == "com.cogknit.locationmodule.action.ACTIVITY_RESPONSE") {
                int activity = intent.getIntExtra("com.cogknit.locationmodule.extras.EXTRA_ACTIVITY", 4);
                LocationController.this.pushToQueue(activity);
            } else if (intent.getAction() == "com.cogknit.locationmodule.action.LOCATION_RESPONSE" && (location = (Location)intent.getExtras().get("com.google.android.location.LOCATION")) != null) {
                Long tsLong = location.getTime();
                UserLocation uLocation = new UserLocation(location.getLatitude(), location.getLongitude(), LocationController.this.currentActivity, tsLong.toString());
                FoveaDatabaseManager.insert(context, FoveaContract.Location.CONTENT_LOCATION_URI, uLocation.getContentValues());
            }
        }
    }

    private class ActivityQueue
    extends LinkedList<Integer> {
        private static final long serialVersionUID = 1L;

        private ActivityQueue() {
        }

        private boolean isQueueFull() {
            return this.size() >= 3;
        }

        private boolean isHomogeneous() {
            int key = (Integer)this.peek();
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (i == key) continue;
                return false;
            }
            return true;
        }
    }
}

