/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.services;

import android.annotation.TargetApi;
import android.app.IntentService;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.Browser;
import android.provider.CallLog;
import android.provider.ContactsContract;
import com.cogknit.fovea.dataModel.Call;
import com.cogknit.fovea.dataModel.History;
import com.cogknit.fovea.dataModel.Person;
import com.cogknit.fovea.dataModel.Sms;
import com.cogknit.fovea.providers.FoveaContract;
import com.cogknit.fovea.providers.FoveaDatabaseManager;
import com.cogknit.fovea.receivers.AlarmReceiver;
import com.cogknit.fovea.utils.FoveaLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LocalDataFetchService
extends IntentService {
    private static final String TAG = "LDFS";
    private static final int TOP_CONNECTED_PEOPLE_COUNT = 25;

    public LocalDataFetchService() {
        super("LocalDataFetchService");
    }

    protected void onHandleIntent(Intent intent) {
        if (intent.getAction() == "com.cogknit.goglocallibrary.actions.fetch.calllogs") {
            FoveaLog.v(TAG, "Call logs fetch begin!");
            this.updateCallLogs();
            this.deleteOldCallLogs();
            FoveaLog.v(TAG, "Call logs Updated!");
        }
        if (intent.getAction() == "com.cogknit.goglocallibrary.actions.fetch.people") {
            FoveaLog.v(TAG, "People fetch begin!");
            this.repopulatePeopleTables();
            FoveaLog.v(TAG, "People Updated!");
        } else if (intent.getAction() == "com.cogknit.goglocallibrary.actions.fetch.history;") {
            this.updateHistoryProvider();
            FoveaLog.v(TAG, "History Updated!");
        } else if (intent.getAction() == "com.cogknit.goglocallibrary.actions.fetch.sms") {
            this.updateSmsProvider();
            FoveaLog.v(TAG, "Messages Updated!");
        }
        AlarmReceiver.completeWakefulIntent((Intent)intent);
    }

    @TargetApi(value=21)
    private void updateCallLogs() {
        String[] p;
        Uri mUri = FoveaContract.Calls.CONTENT_CALLS_URI;
        long latestEntry = this.getLatestTimeStamp(mUri);
        String[] projection = null;
        projection = Build.VERSION.SDK_INT < 21 ? (p = new String[]{"number", "duration", "name", "date"}) : (p = new String[]{"number", "duration", "name", "lookup_uri", "date"});
        String selection = "date>" + latestEntry + " AND " + "duration" + ">" + "0";
        Cursor c = this.getContentResolver().query(CallLog.Calls.CONTENT_URI, projection, selection, null, "date DESC");
        ArrayList<Call> newLogs = new ArrayList<Call>();
        if (c.moveToNext()) {
            do {
                String name;
                if ((name = c.getString(c.getColumnIndex("name"))) == null || name == "") {
                    name = "Unknown";
                }
                String number = c.getString(c.getColumnIndex("number"));
                long duration = c.getLong(c.getColumnIndex("duration"));
                long timeStamp = c.getLong(c.getColumnIndex("date"));
                String uri = null;
                uri = Build.VERSION.SDK_INT >= 21 ? c.getString(c.getColumnIndex("lookup_uri")) : "";
                Call log = new Call(name, duration, number, timeStamp, uri, "");
                newLogs.add(log);
            } while (c.moveToNext());
        }
        c.close();
        for (Call log : newLogs) {
            FoveaDatabaseManager.insert(this.getApplicationContext(), FoveaContract.Calls.CONTENT_CALLS_URI, log.getContentValues());
        }
        this.setLatestTimeStamp(mUri);
    }

    private long getLatestTimeStamp(Uri uri) {
        SharedPreferences prefs = this.getSharedPreferences("LastMined", 0);
        long timestamp = prefs.getLong(uri.getLastPathSegment(), 0L);
        return timestamp;
    }

    private void setLatestTimeStamp(Uri uri) {
        long timestamp = 0L;
        SharedPreferences prefs = this.getSharedPreferences("LastMined", 0);
        String[] projection = new String[]{"timestamp"};
        String sortOrder = "timestamp DESC";
        String selection = "timestamp=(SELECT MAX(timestamp) from " + uri.getLastPathSegment() + ")";
        Cursor c = FoveaDatabaseManager.query(this.getApplicationContext(), uri, projection, selection, null, sortOrder);
        if (c != null && c.moveToNext()) {
            timestamp = c.getLong(c.getColumnIndex("timestamp"));
            c.close();
        }
        prefs.edit().putLong(uri.getLastPathSegment(), timestamp).commit();
        FoveaLog.d(TAG, "SET -> KEY: " + uri.getLastPathSegment() + " TIMESTAMP: " + timestamp);
    }

    private void setLatestSmsTimeStamp(Uri uri, long timestamp) {
        SharedPreferences prefs = this.getSharedPreferences("LastMined", 0);
        prefs.edit().putLong(uri.getLastPathSegment(), timestamp).commit();
        FoveaLog.d(TAG, "SET -> KEY: " + uri.getLastPathSegment() + " TIMESTAMP: " + timestamp);
    }

    private void repopulatePeopleTables() {
        String[] timeframes;
        ArrayList<Person> people = new ArrayList<Person>();
        long now = new Date().getTime();
        long day = 86400000L;
        long week = 7L * day;
        long month = 30L * day;
        long quarter = 3L * month;
        FoveaDatabaseManager.delete(this.getApplicationContext(), FoveaContract.People.CONTENT_PEOPLE_URI, null, null);
        for (String timeframe : timeframes = new String[]{"DQUARTERLY"}) {
            long after = timeframe == "ADAILY" ? now - day : (timeframe == "BWEEKLY" ? now - week : (timeframe == "CMONTHLY" ? now - month : now - quarter));
            String[] projection = new String[]{"name", "number", "timestamp", "duration", "contact_uri"};
            String selection = "timestamp>" + after;
            Cursor c = FoveaDatabaseManager.query(this.getApplicationContext(), FoveaContract.Calls.CONTENT_CALLS_URI, projection, selection, null, null);
            HashMap<String, Person> map = new HashMap<String, Person>();
            double max_frequency = 0.0;
            double max_duration = 0.0;
            while (c.moveToNext()) {
                long duration;
                String name = c.getString(c.getColumnIndex("name"));
                if (map.containsKey(name)) {
                    duration = c.getLong(c.getColumnIndex("duration"));
                    Person person = (Person)map.get(name);
                    person.addDuration(duration);
                    person.addFrequency(1);
                    max_frequency = (double)person.getFrequency() > max_frequency ? (double)person.getFrequency() : max_frequency;
                    max_duration = (double)person.getDuration() > max_duration ? (double)person.getDuration() : max_duration;
                    continue;
                }
                duration = c.getLong(c.getColumnIndex("duration"));
                String number = c.getString(c.getColumnIndex("number"));
                String uri = c.getString(c.getColumnIndex("contact_uri"));
                Person person = new Person(name, number, duration, 1L, 0.0, uri, timeframe, "");
                map.put(name, person);
                max_frequency = (double)person.getFrequency() > max_frequency ? (double)person.getFrequency() : max_frequency;
                max_duration = (double)person.getDuration() > max_duration ? (double)person.getDuration() : max_duration;
            }
            c.close();
            for (Map.Entry entry : map.entrySet()) {
                Person person = (Person)entry.getValue();
                double norm_freq = (double)person.getFrequency() / max_frequency;
                double norm_duration = (double)person.getDuration() / max_duration;
                double sqrSum = Math.pow(norm_freq, 2.0) + Math.pow(norm_duration, 2.0);
                double weight = Math.sqrt(sqrSum) / 2.0;
                person.setWeight(weight * 100.0);
                people.add(person);
            }
            Collections.sort(people, new Comparator<Person>(){

                @Override
                public int compare(Person p1, Person p2) {
                    return (int)((double)((int)p2.getWeight()) - p1.getWeight());
                }
            });
            int count = 0;
            for (Person person : people) {
                if (person.isNameKnown()) {
                    FoveaDatabaseManager.insert(this.getApplicationContext(), FoveaContract.People.CONTENT_PEOPLE_URI, person.getContentValues());
                    count = (byte)(count + 1);
                }
                if (count != 25) continue;
                break;
            }
            people.clear();
        }
    }

    private void deleteOldCallLogs() {
        long now = new Date().getTime();
        long day = 86400000L;
        long month = 30L * day;
        long quarter = 3L * month;
        long before = now - quarter;
        String selection = "timestamp<" + before;
        FoveaDatabaseManager.delete(this.getApplicationContext(), FoveaContract.Calls.CONTENT_CALLS_URI, selection, null);
    }

    private void updateHistoryProvider() {
        ArrayList<History> historyList = new ArrayList<History>();
        Uri mUri = FoveaContract.History.CONTENT_HISTORY_URI;
        long latestEntry = this.getLatestTimeStamp(mUri);
        String selection = "created>" + latestEntry;
        String[] projection = new String[]{"title", "url", "bookmark", "created"};
        Cursor c = this.getContentResolver().query(Browser.BOOKMARKS_URI, projection, selection, null, null);
        String title = null;
        String url = null;
        int bookmarks = 0;
        String timestamp = null;
        while (c.moveToNext()) {
            title = c.getString(c.getColumnIndex("title"));
            url = c.getString(c.getColumnIndex("url"));
            bookmarks = c.getInt(c.getColumnIndex("bookmark"));
            timestamp = c.getString(c.getColumnIndex("created"));
            historyList.add(new History(title, url, timestamp, bookmarks, ""));
        }
        c.close();
        for (History history : historyList) {
            FoveaDatabaseManager.insert(this.getApplicationContext(), FoveaContract.History.CONTENT_HISTORY_URI, history.getContentValues());
        }
        this.setLatestTimeStamp(mUri);
    }

    private boolean contactExists(String number) {
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.PhoneLookup.CONTENT_FILTER_URI, (String)Uri.encode((String)number));
        Cursor c = this.getContentResolver().query(uri, null, null, null, null);
        boolean val = c.moveToNext();
        c.close();
        return val;
    }

    private void updateSmsProvider() {
        Uri CONTENT_SMS_INBOX = Uri.parse((String)"content://sms/inbox");
        Uri CONTENT_SMS_SENT = Uri.parse((String)"content://sms/sent");
        String SMS_COLUMN_DATE = "date";
        String SMS_COLUMN_NUMBER = "address";
        String SMS_COLUMN_BODY = "body";
        ArrayList<Sms> smsList = new ArrayList<Sms>();
        Uri mUri = FoveaContract.Sms.CONTENT_SMS_URI;
        Uri[] dirs = new Uri[]{CONTENT_SMS_INBOX, CONTENT_SMS_SENT};
        String[] projection = new String[]{SMS_COLUMN_DATE, SMS_COLUMN_BODY, SMS_COLUMN_NUMBER};
        for (Uri uri : dirs) {
            long latestEntry = this.getLatestTimeStamp(uri);
            String selection = SMS_COLUMN_DATE + " > " + latestEntry;
            Cursor c = this.getContentResolver().query(uri, projection, selection, null, null);
            String number = null;
            String body = null;
            String timestamp = null;
            while (c.moveToNext()) {
                number = c.getString(c.getColumnIndex(SMS_COLUMN_NUMBER));
                body = c.getString(c.getColumnIndex(SMS_COLUMN_BODY));
                timestamp = c.getString(c.getColumnIndex(SMS_COLUMN_DATE));
                long ts = Long.parseLong(timestamp);
                long l = latestEntry = latestEntry > ts ? latestEntry : ts;
                if (!this.contactExists(number)) continue;
                smsList.add(new Sms(number, body, timestamp, ""));
            }
            c.close();
            this.setLatestSmsTimeStamp(uri, latestEntry);
        }
        for (Sms sms : smsList) {
            FoveaDatabaseManager.insert(this.getApplicationContext(), FoveaContract.Sms.CONTENT_SMS_URI, sms.getContentValues());
        }
    }
}

