/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.services;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import com.cogknit.fovea.utils.FoveaLog;
import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.DetectedActivity;

public class FusedIntentService
extends IntentService {
    private static final String TAG = "FusedIntentService";

    public FusedIntentService() {
        super("ActivityIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        if (ActivityRecognitionResult.hasResult((Intent)intent)) {
            FoveaLog.d(TAG, "Incoming activity intent...");
            ActivityRecognitionResult result = ActivityRecognitionResult.extractResult((Intent)intent);
            DetectedActivity activity = result.getMostProbableActivity();
            int activityType = activity.getType();
            int activityConfidence = activity.getConfidence();
            if (activityConfidence > 50) {
                Intent dispatch = new Intent("com.cogknit.locationmodule.action.ACTIVITY_RESPONSE");
                dispatch.putExtra("com.cogknit.locationmodule.extras.EXTRA_ACTIVITY", activityType);
                LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)this);
                manager.sendBroadcast(dispatch);
            }
        } else {
            FoveaLog.d(TAG, "Incoming location intent...");
            intent.setAction("com.cogknit.locationmodule.action.LOCATION_RESPONSE");
            LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)this);
            manager.sendBroadcast(intent);
        }
    }
}

