/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.remote;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.support.v4.content.LocalBroadcastManager;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.cogknit.fovea.FoveaUserProfile;
import com.cogknit.fovea.dataModel.AuthRequest;
import com.cogknit.fovea.receivers.RefreshTokenReceiver;
import com.cogknit.fovea.remote.APIConstants;
import com.cogknit.fovea.remote.FoveaResponse;
import com.cogknit.fovea.utils.FoveaLog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FoveaRequestResponseManager {
    private Context context;
    private String TAG = "FoveaRequestResponseManager";
    private String ACCESS_TOKEN = "access_token";
    private String FOVEAUSERID = "foveaUserID";
    private static RequestQueue queue;
    public static String REFRESHTOKEN_ACTION_TAG;
    public static String CONEXTPUSH_ACTION_TYPE;
    private static RefreshTokenReceiver refreshTokenListener;

    public FoveaRequestResponseManager(Context c) {
        this.context = c;
        if (queue == null) {
            queue = Volley.newRequestQueue((Context)this.context);
        }
        VolleyLog.DEBUG = false;
        if (refreshTokenListener == null) {
            refreshTokenListener = new RefreshTokenReceiver();
            LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)this.context);
            broadcastManager.registerReceiver((BroadcastReceiver)refreshTokenListener, new IntentFilter(REFRESHTOKEN_ACTION_TAG));
        }
    }

    public void sendAuthorizationRequest(String appKey, String clientKey, final FoveaResponse.FoveaResponseListener authListener, final FoveaResponse.FoveaErrorListener authErrorListener) {
        AuthRequest authReq = new AuthRequest(appKey, clientKey, this.context);
        Gson gson = new Gson();
        final String authJson = gson.toJson((Object)authReq);
        FoveaLog.v(this.TAG, "Sending a authorization request..." + authJson);
        String url = APIConstants.getAPIClientURL(this.context) + "authorizeSDK";
        JsonObjectRequest authorizationRequest = new JsonObjectRequest(1, url, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "Auth Response: " + response.toString());
                    SharedPreferences settings = FoveaRequestResponseManager.this.context.getSharedPreferences("FoveaPrefsFile", 0);
                    String accessToken = response.get(FoveaRequestResponseManager.this.ACCESS_TOKEN).toString();
                    settings.edit().putString("accessToken", accessToken).commit();
                    authListener.onSuccessResponse();
                }
                catch (JSONException exception) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "exception: " + exception.getLocalizedMessage());
                    authErrorListener.onFoveaErrorResponse(new Exception(exception.getLocalizedMessage()));
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if (response != null && response.statusCode == APIConstants.AUTHE_ERROR_CODE) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    authErrorListener.onFoveaErrorResponse(new Exception("Invalid app key or client key or package name mismatch"));
                } else if (error instanceof TimeoutError) {
                    authErrorListener.onFoveaErrorResponse(new Exception("Unable to connect Fovea server, please check the network connectivity"));
                } else {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    authErrorListener.onFoveaErrorResponse(new Exception("Unable to authorize, due to internal issues"));
                }
            }
        }){

            public String getBodyContentType() {
                return "application/json";
            }

            public byte[] getBody() {
                try {
                    return authJson.getBytes(this.getParamsEncoding());
                }
                catch (UnsupportedEncodingException uee) {
                    FoveaLog.i(FoveaRequestResponseManager.this.TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }
        };
        this.processRequest((Request)authorizationRequest);
    }

    public void submitUserProfile(FoveaUserProfile userProfile, final FoveaResponse.FoveaResponseListener userProfileResponseListener, final FoveaResponse.FoveaErrorListener userProfileErrorListener) {
        Gson gson = new Gson();
        final String userProfileJson = gson.toJson((Object)userProfile);
        FoveaLog.v(this.TAG, "Sending a user profile request..." + userProfileJson);
        SharedPreferences settings = this.context.getSharedPreferences("FoveaPrefsFile", 0);
        String accessToken = settings.getString("accessToken", "");
        if (accessToken.equalsIgnoreCase("")) {
            Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
            LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)this.context);
            manager.sendBroadcast(dispatch);
            return;
        }
        String url = APIConstants.getAPIClientURL(this.context) + "customerProfile" + "?" + this.ACCESS_TOKEN + "=" + accessToken;
        JsonObjectRequest userProfileRequest = new JsonObjectRequest(1, url, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "User profile Response: " + response.toString());
                    SharedPreferences settings = FoveaRequestResponseManager.this.context.getSharedPreferences("FoveaPrefsFile", 0);
                    settings.edit().putString("accessToken", response.get(FoveaRequestResponseManager.this.ACCESS_TOKEN).toString()).commit();
                    userProfileResponseListener.onSuccessResponse();
                }
                catch (JSONException exception) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "exception: " + exception.getLocalizedMessage());
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if (response != null && response.statusCode == APIConstants.AUTHE_ERROR_CODE) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    userProfileErrorListener.onFoveaErrorResponse((Exception)error);
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "sending refresh token request ");
                    Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
                    LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)FoveaRequestResponseManager.this.context);
                    manager.sendBroadcast(dispatch);
                } else if (error instanceof TimeoutError) {
                    String networkError = "No internet Access, Check your internet connection.";
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + networkError);
                } else {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                }
            }
        }){

            public Map<String, String> getParams() {
                HashMap<String, String> mParams = new HashMap<String, String>();
                return mParams;
            }

            public String getBodyContentType() {
                return "application/json";
            }

            public byte[] getBody() {
                try {
                    return userProfileJson.getBytes(this.getParamsEncoding());
                }
                catch (UnsupportedEncodingException uee) {
                    FoveaLog.i(FoveaRequestResponseManager.this.TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }
        };
        this.processRequest((Request)userProfileRequest);
    }

    void processRequest(Request request) {
        int socketTimeout = 10000;
        DefaultRetryPolicy policy = new DefaultRetryPolicy(socketTimeout, 1, 1.0f);
        request.setRetryPolicy((RetryPolicy)policy);
        queue.add(request);
    }

    public void submitContextData(String serviceEndPoint, List items, final FoveaResponse.FoveaResponseListener dataResponseListener, final FoveaResponse.FoveaErrorListener dataErrorListener) {
        SharedPreferences settings = this.context.getSharedPreferences("FoveaPrefsFile", 0);
        String accessToken = settings.getString("accessToken", "");
        String finalUrl = APIConstants.getAPIClientURL(this.context) + serviceEndPoint + "?" + this.ACCESS_TOKEN + "=" + accessToken;
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("data", items);
        GsonBuilder builder = new GsonBuilder();
        Gson mapGson = builder.create();
        final String appJson = mapGson.toJson(data);
        FoveaLog.v(this.TAG, "Sending a request..." + appJson);
        JsonObjectRequest authorizationRequest = new JsonObjectRequest(1, finalUrl, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                FoveaLog.v(FoveaRequestResponseManager.this.TAG, response.toString());
                try {
                    SharedPreferences settings = FoveaRequestResponseManager.this.context.getSharedPreferences("FoveaPrefsFile", 0);
                    settings.edit().putString("accessToken", response.get(FoveaRequestResponseManager.this.ACCESS_TOKEN).toString()).commit();
                    dataResponseListener.onSuccessResponse();
                }
                catch (JSONException exception) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "AppContextException: " + exception.getLocalizedMessage());
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if (response != null && response.statusCode == APIConstants.AUTHE_ERROR_CODE) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "sending refresh token request ");
                    Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
                    LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)FoveaRequestResponseManager.this.context);
                    dispatch.putExtra(CONEXTPUSH_ACTION_TYPE, true);
                    manager.sendBroadcast(dispatch);
                } else if (error instanceof TimeoutError) {
                    String networkError = "No internet Access, Check your internet connection.";
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + networkError);
                } else {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    dataErrorListener.onFoveaErrorResponse((Exception)error);
                }
            }
        }){

            public String getBodyContentType() {
                return "application/json";
            }

            public byte[] getBody() {
                try {
                    return appJson.getBytes(this.getParamsEncoding());
                }
                catch (UnsupportedEncodingException uee) {
                    FoveaLog.i(FoveaRequestResponseManager.this.TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }
        };
        this.processRequest((Request)authorizationRequest);
    }

    public void submitInvitesContextData(String serviceEndPoint, List items, final FoveaResponse.FoveaResponseListener dataResponseListener, final FoveaResponse.FoveaErrorListener dataErrorListener) {
        SharedPreferences settings = this.context.getSharedPreferences("FoveaPrefsFile", 0);
        String accessToken = settings.getString("accessToken", "");
        String finalUrl = APIConstants.getAPIClientURL(this.context) + serviceEndPoint + "?" + this.ACCESS_TOKEN + "=" + accessToken;
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("data", items);
        GsonBuilder builder = new GsonBuilder();
        builder.excludeFieldsWithoutExposeAnnotation();
        Gson mapGson = builder.create();
        final String appJson = mapGson.toJson(data);
        FoveaLog.v(this.TAG, "Sending a request..." + appJson);
        JsonObjectRequest authorizationRequest = new JsonObjectRequest(1, finalUrl, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                FoveaLog.v(FoveaRequestResponseManager.this.TAG, response.toString());
                try {
                    SharedPreferences settings = FoveaRequestResponseManager.this.context.getSharedPreferences("FoveaPrefsFile", 0);
                    settings.edit().putString("accessToken", response.get(FoveaRequestResponseManager.this.ACCESS_TOKEN).toString()).commit();
                    dataResponseListener.onSuccessResponse();
                }
                catch (JSONException exception) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "AppContextException: " + exception.getLocalizedMessage());
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if (response != null && response.statusCode == APIConstants.AUTHE_ERROR_CODE) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "sending refresh token request ");
                    Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
                    LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)FoveaRequestResponseManager.this.context);
                    dispatch.putExtra(CONEXTPUSH_ACTION_TYPE, true);
                    manager.sendBroadcast(dispatch);
                } else if (error instanceof TimeoutError) {
                    String networkError = "No internet Access, Check your internet connection.";
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + networkError);
                } else {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    dataErrorListener.onFoveaErrorResponse((Exception)error);
                }
            }
        }){

            public String getBodyContentType() {
                return "application/json";
            }

            public byte[] getBody() {
                try {
                    return appJson.getBytes(this.getParamsEncoding());
                }
                catch (UnsupportedEncodingException uee) {
                    FoveaLog.i(FoveaRequestResponseManager.this.TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }
        };
        this.processRequest((Request)authorizationRequest);
    }

    public void sendFbData(String urlString, String payload) {
        String KEY_DATA = "data";
        SharedPreferences prefs = this.context.getSharedPreferences("FoveaPrefsFile", 0);
        String accessToken = prefs.getString("accessToken", "token");
        String url = urlString + "?access_token=" + accessToken;
        JSONObject json = new JSONObject();
        try {
            json.put("data", (Object)payload);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        final String reqJson = json.toString();
        FoveaLog.d(this.TAG, "Sending a FB request..." + reqJson);
        JsonObjectRequest fbRequest = new JsonObjectRequest(1, url, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if (response != null && response.statusCode == APIConstants.AUTHE_ERROR_CODE) {
                    FoveaLog.d(FoveaRequestResponseManager.this.TAG, "FB ErrorResponse: " + error.getLocalizedMessage());
                } else if (error instanceof TimeoutError) {
                    FoveaLog.d(FoveaRequestResponseManager.this.TAG, "FB Timeout: " + error.getLocalizedMessage());
                } else {
                    FoveaLog.d(FoveaRequestResponseManager.this.TAG, "FB Unknown Error: " + error.getLocalizedMessage());
                }
            }
        }){

            public String getBodyContentType() {
                return "application/json";
            }

            public byte[] getBody() {
                try {
                    return reqJson.getBytes(this.getParamsEncoding());
                }
                catch (UnsupportedEncodingException uee) {
                    FoveaLog.i(FoveaRequestResponseManager.this.TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }
        };
        this.processRequest((Request)fbRequest);
    }

    public void executeJsonRequest(String URL2, JSONObject jsonRequest, Response.Listener<JSONObject> successCallback, Response.ErrorListener errorCallback) {
        JsonObjectRequest request = new JsonObjectRequest(URL2, jsonRequest, successCallback, errorCallback);
        this.processRequest((Request)request);
    }

    public void sendDeviceUserDetailsRequest(Object deviceUserDetailsObj, final FoveaResponse.FoveaResponseListener responseListner, final FoveaResponse.FoveaErrorListener responseErrorListener) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", deviceUserDetailsObj);
        GsonBuilder builder = new GsonBuilder();
        Gson mapGson = builder.create();
        final String userDetailsJSON = mapGson.toJson(data);
        SharedPreferences settings = this.context.getSharedPreferences("FoveaPrefsFile", 0);
        String accessToken = settings.getString("accessToken", "");
        FoveaLog.v(this.TAG, "Sending a device user info request..." + userDetailsJSON);
        String url = APIConstants.getAPIClientURL(this.context) + "appInviteStatus" + "?" + this.ACCESS_TOKEN + "=" + accessToken;
        JsonObjectRequest authorizationRequest = new JsonObjectRequest(1, url, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                FoveaLog.v(FoveaRequestResponseManager.this.TAG, "DeviceUser Response: " + response.toString());
                try {
                    SharedPreferences settings = FoveaRequestResponseManager.this.context.getSharedPreferences("FoveaPrefsFile", 0);
                    settings.edit().putString("accessToken", response.get(FoveaRequestResponseManager.this.ACCESS_TOKEN).toString()).commit();
                    responseListner.onSuccessResponse();
                }
                catch (JSONException exception) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "AppContextException: " + exception.getLocalizedMessage());
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if (response != null && response.statusCode == APIConstants.AUTHE_ERROR_CODE) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "sending refresh token request ");
                    LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)FoveaRequestResponseManager.this.context);
                    Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
                    manager.sendBroadcast(dispatch);
                } else if (error instanceof TimeoutError) {
                    String networkError = "No internet Access, Check your internet connection.";
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + networkError);
                } else {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    responseErrorListener.onFoveaErrorResponse((Exception)error);
                }
            }
        }){

            public String getBodyContentType() {
                return "application/json";
            }

            public byte[] getBody() {
                try {
                    return userDetailsJSON.getBytes(this.getParamsEncoding());
                }
                catch (UnsupportedEncodingException uee) {
                    FoveaLog.i(FoveaRequestResponseManager.this.TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }
        };
        this.processRequest((Request)authorizationRequest);
    }

    public void getInfluenceGraphRequest(final FoveaResponse.FoveaDataResponseListener responseListner, final FoveaResponse.FoveaErrorListener responseErrorListener) {
        FoveaLog.v(this.TAG, "Sending influence graph request...");
        SharedPreferences settings = this.context.getSharedPreferences("FoveaPrefsFile", 0);
        String accessToken = settings.getString("accessToken", "");
        String url = APIConstants.getAPIClientURL(this.context) + "influenceGraph" + "?" + this.ACCESS_TOKEN + "=" + accessToken;
        JsonObjectRequest authorizationRequest = new JsonObjectRequest(0, url, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                FoveaLog.v(FoveaRequestResponseManager.this.TAG, "Influence graph Response: " + response.toString());
                try {
                    JSONArray influenceList = response.getJSONArray("data");
                    SharedPreferences settings = FoveaRequestResponseManager.this.context.getSharedPreferences("FoveaPrefsFile", 0);
                    settings.edit().putString("accessToken", response.get(FoveaRequestResponseManager.this.ACCESS_TOKEN).toString()).commit();
                    responseListner.onSuccessResponse(influenceList.toString());
                }
                catch (JSONException exception) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "Influencegraph exception: " + exception.getLocalizedMessage());
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if (response != null && response.statusCode == APIConstants.AUTHE_ERROR_CODE) {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "sending refresh token request ");
                    Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
                    LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)FoveaRequestResponseManager.this.context);
                    dispatch.putExtra(CONEXTPUSH_ACTION_TYPE, true);
                    manager.sendBroadcast(dispatch);
                } else if (error instanceof TimeoutError) {
                    String networkError = "No internet Access, Check your internet connection.";
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + networkError);
                } else {
                    FoveaLog.v(FoveaRequestResponseManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    responseErrorListener.onFoveaErrorResponse((Exception)error);
                }
            }
        }){

            public String getBodyContentType() {
                return "application/json";
            }
        };
        this.processRequest((Request)authorizationRequest);
    }

    static {
        REFRESHTOKEN_ACTION_TAG = "RefreshToken";
        CONEXTPUSH_ACTION_TYPE = "CONEXTPUSH_ACTION_TYPE";
        refreshTokenListener = null;
    }
}

