/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.cogknit.fovea.providers.FoveaUserProfileManager;
import com.cogknit.fovea.services.FoveaSyncService;
import com.cogknit.fovea.utils.FoveaLog;

public class ConnectionChangeReceiver
extends BroadcastReceiver {
    public static String SYNC_IF_NEEDED = "SyncIfNeeded";
    private static boolean firstConnect = true;

    public void onReceive(Context context, Intent intent) {
        boolean isConnected;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        boolean bl = isConnected = activeNetInfo != null && activeNetInfo.isConnected();
        if (isConnected) {
            if (firstConnect) {
                boolean hasPendingContextSync;
                firstConnect = false;
                FoveaLog.v("Network event", "Network event changed");
                SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
                boolean hasPendingUPSync = settings.getBoolean("hasPendingUPSync", false);
                if (hasPendingUPSync) {
                    FoveaUserProfileManager userProfileManager = new FoveaUserProfileManager();
                    userProfileManager.performUserProfileSynchronization(context);
                }
                if (hasPendingContextSync = settings.getBoolean("hasPendingContextDataSync", false)) {
                    Intent intent1 = new Intent(context, FoveaSyncService.class);
                    intent1.setAction("com.cogknit.goglocallibrary.actions.remote.push");
                    context.startService(intent1);
                }
            }
        } else {
            firstConnect = true;
        }
    }
}

