/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.receivers;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.cogknit.fovea.FoveaConstants;
import com.cogknit.fovea.receivers.AlarmReceiver;
import com.cogknit.fovea.receivers.ScreenEventReceiver;
import com.cogknit.fovea.utils.FoveaLog;
import java.util.Calendar;

public class BootEventReceiver
extends WakefulBroadcastReceiver {
    private static final String TAG = "BOOT";
    private static final int DeviceDetailsAlarmReqCode = 9000;

    public void onReceive(Context context, Intent intent) {
        FoveaLog.v(TAG, "BootScheduleReceiver: Device booted, scheduling..");
        if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {
            BootEventReceiver.bootInit(context);
        }
    }

    public static void bootInit(Context context) {
        PendingIntent alarmIntent;
        SharedPreferences prefs = context.getSharedPreferences("FoveaPrefsFile", 0);
        FoveaLog.v(TAG, "Setting Alarms..");
        AlarmManager alarmMgr = (AlarmManager)context.getSystemService("alarm");
        Intent iAlarm = new Intent(context, AlarmReceiver.class);
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        boolean hasSyncedDeviceDetails = settings.getBoolean("hasSyncedDeviceUserDetails", false);
        if (!hasSyncedDeviceDetails) {
            FoveaLog.v(TAG, "Setting Alarms..ACTION_DEVICE_USER_SYNC");
            iAlarm.setAction("com.cogknit.goglocallibrary.actions.deviceUser.sync");
            alarmIntent = PendingIntent.getBroadcast((Context)context, (int)9000, (Intent)iAlarm, (int)0x8000000);
            alarmMgr.setInexactRepeating(3, 1000L, 43200000L, alarmIntent);
        }
        if (prefs.getBoolean("com.cogknit.fovea.context.people", false)) {
            iAlarm.setAction("com.cogknit.goglocallibrary.actions.fetch.calllogs");
            if (PendingIntent.getBroadcast((Context)context, (int)1000, (Intent)iAlarm, (int)0x20000000) == null) {
                alarmIntent = PendingIntent.getBroadcast((Context)context, (int)1000, (Intent)iAlarm, (int)0x8000000);
                alarmMgr.setInexactRepeating(3, 1000L, 86400000L, alarmIntent);
            }
            iAlarm.setAction("com.cogknit.goglocallibrary.actions.fetch.people");
            if (PendingIntent.getBroadcast((Context)context, (int)10000, (Intent)iAlarm, (int)0x20000000) == null) {
                alarmIntent = PendingIntent.getBroadcast((Context)context, (int)10000, (Intent)iAlarm, (int)0x8000000);
                alarmMgr.setInexactRepeating(3, 20000L, 604800000L, alarmIntent);
            }
        }
        if (prefs.getBoolean("com.cogknit.fovea.context.history", false)) {
            iAlarm.setAction("com.cogknit.goglocallibrary.actions.fetch.history;");
            if (PendingIntent.getBroadcast((Context)context, (int)2000, (Intent)iAlarm, (int)0x20000000) == null) {
                alarmIntent = PendingIntent.getBroadcast((Context)context, (int)2000, (Intent)iAlarm, (int)0x8000000);
                alarmMgr.setInexactRepeating(3, 0L, 86400000L, alarmIntent);
            }
        }
        if (prefs.getBoolean("com.cogknit.fovea.context.sms", false)) {
            iAlarm.setAction("com.cogknit.goglocallibrary.actions.fetch.sms");
            if (PendingIntent.getBroadcast((Context)context, (int)3000, (Intent)iAlarm, (int)0x20000000) == null) {
                alarmIntent = PendingIntent.getBroadcast((Context)context, (int)3000, (Intent)iAlarm, (int)0x8000000);
                alarmMgr.setInexactRepeating(3, 0L, 86400000L, alarmIntent);
            }
        }
        if (prefs.getBoolean("com.cogknit.fovea.context.locations", false)) {
            iAlarm.setAction("com.cogknit.goglocallibrary.actions.location.track");
            if (PendingIntent.getBroadcast((Context)context, (int)4000, (Intent)iAlarm, (int)0x20000000) == null) {
                alarmIntent = PendingIntent.getBroadcast((Context)context, (int)4000, (Intent)iAlarm, (int)0x8000000);
                alarmMgr.setInexactRepeating(3, 0L, 86400000L, alarmIntent);
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        iAlarm.setAction("com.cogknit.goglocallibrary.actions.remote.push");
        if (PendingIntent.getBroadcast((Context)context, (int)5000, (Intent)iAlarm, (int)0x20000000) == null) {
            alarmIntent = PendingIntent.getBroadcast((Context)context, (int)5000, (Intent)iAlarm, (int)0x8000000);
            alarmMgr.setInexactRepeating(1, calendar.getTimeInMillis() + 120000L, 43200000L, alarmIntent);
        }
        if (prefs.getBoolean("com.cogknit.fovea.context.apps", false)) {
            iAlarm.setAction("com.cogknit.goglocallibrary.actions.fetch.app");
            if (PendingIntent.getBroadcast((Context)context, (int)6000, (Intent)iAlarm, (int)0x20000000) == null) {
                alarmIntent = PendingIntent.getBroadcast((Context)context, (int)6000, (Intent)iAlarm, (int)0x8000000);
                if (Build.VERSION.SDK_INT < 21) {
                    alarmMgr.setRepeating(3, 0L, 5000L, alarmIntent);
                } else {
                    alarmMgr.setInexactRepeating(3, 0L, 86400000L, alarmIntent);
                }
            }
        }
        if (prefs.getBoolean(FoveaConstants.Services.FB.name(), false)) {
            iAlarm.setAction("com.cogknit.fovea.fb.friends");
            if (PendingIntent.getBroadcast((Context)context, (int)30000, (Intent)iAlarm, (int)0x20000000) == null) {
                alarmIntent = PendingIntent.getBroadcast((Context)context, (int)30000, (Intent)iAlarm, (int)0x8000000);
                alarmMgr.setInexactRepeating(3, 0L, 86400000L, alarmIntent);
            }
            iAlarm.setAction("com.cogknit.fovea.fb.likes");
            if (PendingIntent.getBroadcast((Context)context, (int)7000, (Intent)iAlarm, (int)0x20000000) == null) {
                alarmIntent = PendingIntent.getBroadcast((Context)context, (int)7000, (Intent)iAlarm, (int)0x8000000);
                alarmMgr.setInexactRepeating(3, 30000L, 86400000L, alarmIntent);
            }
            iAlarm.setAction("com.cogknit.fovea.fb.me");
            if (PendingIntent.getBroadcast((Context)context, (int)8000, (Intent)iAlarm, (int)0x20000000) == null) {
                alarmIntent = PendingIntent.getBroadcast((Context)context, (int)8000, (Intent)iAlarm, (int)0x8000000);
                alarmMgr.setInexactRepeating(3, 30000L, 86400000L, alarmIntent);
            }
        }
    }

    public static void initialize(Context context) {
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        if (settings.getBoolean("my_first_time", true)) {
            settings.edit().putBoolean("my_first_time", false).commit();
        }
        BootEventReceiver.bootInit(context);
        if (Build.VERSION.SDK_INT < 21) {
            IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_ON");
            filter.addAction("android.intent.action.SCREEN_OFF");
            ScreenEventReceiver mReceiver = new ScreenEventReceiver();
            context.registerReceiver((BroadcastReceiver)mReceiver, filter);
        }
    }

    public static void disarmAlarm(Context context, String action) {
        Intent intent = new Intent(context, AlarmReceiver.class);
        intent.setAction(action);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)9000, (Intent)intent, (int)0);
        if (pendingIntent != null) {
            FoveaLog.v(TAG, "Removing Alarms..ACTION_DEVICE_USER_SYNC");
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            alarmManager.cancel(pendingIntent);
        }
    }
}

