/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.providers;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import com.cogknit.fovea.providers.FoveaContract;
import com.cogknit.fovea.utils.FoveaLog;
import java.util.ArrayList;

public class FoveaDatabaseManager {
    private static final String dbName = "cogknit_fovea.db";
    private static final int dbVersion = 1;
    private static SQLiteDatabase db;
    private static String TAG;
    static final int PEOPLE = 1;
    static final int PERSON_ID = 2;
    static final int PEOPLE_FILTER = 3;
    static final int CALLS = 4;
    static final int CALL_ID = 5;
    static final int SMS = 6;
    static final int SMS_ID = 7;
    static final int HISTORY = 8;
    static final int HISTORY_ID = 9;
    static final int APP = 10;
    static final int APP_ID = 11;
    static final int LOCATIONS = 12;
    static final int LOCATION_ID = 14;
    static final int LIKES = 15;
    static final int LIKES_ID = 16;
    static final int USERPROFILE = 17;
    static final int APPINVITES = 18;
    static final UriMatcher uriMatcher;

    private static void initializeFoveaDatabase(Context context) {
        DatabaseHelper dbHelper = new DatabaseHelper(context);
        db = dbHelper.getWritableDatabase();
    }

    public static synchronized Cursor query(Context context, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        if (db == null) {
            FoveaDatabaseManager.initializeFoveaDatabase(context);
        }
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        switch (uriMatcher.match(uri)) {
            case 17: {
                qb.setTables("userProfile");
                if (sortOrder != null && sortOrder != "") break;
                sortOrder = "timestamp DESC";
                break;
            }
            case 4: {
                qb.setTables("calls");
                if (sortOrder != null && sortOrder != "") break;
                sortOrder = "timestamp DESC";
                break;
            }
            case 5: {
                qb.setTables("calls");
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
                break;
            }
            case 1: {
                qb.setTables("people");
                if (sortOrder != null && sortOrder != "") break;
                sortOrder = "timeframe";
                break;
            }
            case 2: {
                qb.setTables("people");
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
                break;
            }
            case 3: {
                qb.setTables("people");
                String filter = "'" + uri.getLastPathSegment() + "'";
                qb.appendWhere((CharSequence)("timeframe=" + filter));
                break;
            }
            case 6: {
                qb.setTables("sms");
                if (sortOrder != null && sortOrder != "") break;
                sortOrder = "timestamp DESC";
                break;
            }
            case 7: {
                qb.setTables("sms");
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
                break;
            }
            case 8: {
                qb.setTables("history");
                if (sortOrder != null && sortOrder != "") break;
                sortOrder = "timestamp DESC";
                break;
            }
            case 9: {
                qb.setTables("history");
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
                break;
            }
            case 10: {
                qb.setTables("app");
                if (sortOrder != null && sortOrder != "") break;
                sortOrder = "foregroundTime DESC";
                break;
            }
            case 11: {
                qb.setTables("app");
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
                break;
            }
            case 12: {
                qb.setTables("location");
                if (sortOrder != null && sortOrder != "") break;
                sortOrder = "timestamp DESC";
                break;
            }
            case 14: {
                qb.setTables("location");
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
                break;
            }
            case 15: {
                qb.setTables("likes");
                if (sortOrder != null && sortOrder != "") break;
                sortOrder = "timestamp DESC";
                break;
            }
            case 16: {
                qb.setTables("likes");
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
                break;
            }
            case 18: {
                qb.setTables("appInvites");
                if (sortOrder != null && sortOrder != "") break;
                sortOrder = "timestamp DESC";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI " + uri);
            }
        }
        Cursor c = qb.query(db, projection, selection, selectionArgs, null, null, sortOrder);
        return c;
    }

    public String getType(Uri uri) {
        String dirType = "vnd.android.cursor.dir/vnd.";
        String itemType = "vnd.android.cursor.item/vnd.";
        switch (uriMatcher.match(uri)) {
            case 17: {
                return dirType + "com.cogknit.fovea.providers.FoveaContract" + "." + "userProfile";
            }
            case 4: {
                return dirType + "com.cogknit.fovea.providers.FoveaContract" + "." + "calls";
            }
            case 5: {
                return itemType + "com.cogknit.fovea.providers.FoveaContract" + "." + "calls";
            }
            case 1: 
            case 3: {
                return dirType + "com.cogknit.fovea.providers.FoveaContract" + "." + "people";
            }
            case 2: {
                return itemType + "com.cogknit.fovea.providers.FoveaContract" + "." + "people";
            }
            case 6: {
                return dirType + "com.cogknit.fovea.providers.FoveaContract" + "." + "sms";
            }
            case 7: {
                return itemType + "com.cogknit.fovea.providers.FoveaContract" + "." + "sms";
            }
            case 8: {
                return dirType + "com.cogknit.fovea.providers.FoveaContract" + "." + "history";
            }
            case 9: {
                return itemType + "com.cogknit.fovea.providers.FoveaContract" + "." + "history";
            }
            case 10: {
                return dirType + "com.cogknit.fovea.providers.FoveaContract" + "." + "app";
            }
            case 11: {
                return itemType + "com.cogknit.fovea.providers.FoveaContract" + "." + "app";
            }
            case 12: {
                return dirType + "com.cogknit.fovea.providers.FoveaContract" + "." + "location";
            }
            case 14: {
                return itemType + "com.cogknit.fovea.providers.FoveaContract" + "." + "location";
            }
            case 15: {
                return dirType + "com.cogknit.fovea.providers.FoveaContract" + "." + "likes";
            }
            case 16: {
                return itemType + "com.cogknit.fovea.providers.FoveaContract" + "." + "likes";
            }
            case 18: {
                return itemType + "com.cogknit.fovea.providers.FoveaContract" + "." + "appInvites";
            }
        }
        throw new IllegalArgumentException("Unknown URI " + uri);
    }

    public static synchronized Uri insert(Context context, Uri uri, ContentValues values) {
        if (db == null) {
            FoveaDatabaseManager.initializeFoveaDatabase(context);
        }
        SharedPreferences prefs = context.getSharedPreferences("FoveaPrefsFile", 0);
        String userId = prefs.getString("Fovea_userID", "");
        values.put("foveaUserID", userId);
        long rowID = -1L;
        Uri _uri = null;
        switch (uriMatcher.match(uri)) {
            case 17: {
                rowID = db.insert("userProfile", "", values);
                _uri = ContentUris.withAppendedId((Uri)FoveaContract.UserProfile.CONTENT_USERPROFILE_URI, (long)rowID);
                break;
            }
            case 4: {
                rowID = db.insert("calls", "", values);
                _uri = ContentUris.withAppendedId((Uri)FoveaContract.Calls.CONTENT_CALLS_URI, (long)rowID);
                break;
            }
            case 1: 
            case 3: {
                rowID = db.insert("people", "", values);
                _uri = ContentUris.withAppendedId((Uri)FoveaContract.People.CONTENT_PEOPLE_URI, (long)rowID);
                break;
            }
            case 6: {
                rowID = db.insert("sms", "", values);
                _uri = ContentUris.withAppendedId((Uri)FoveaContract.Sms.CONTENT_SMS_URI, (long)rowID);
                break;
            }
            case 8: {
                rowID = db.insert("history", "", values);
                _uri = ContentUris.withAppendedId((Uri)FoveaContract.History.CONTENT_HISTORY_URI, (long)rowID);
                break;
            }
            case 10: {
                rowID = db.insert("app", "", values);
                _uri = ContentUris.withAppendedId((Uri)FoveaContract.Apps.CONTENT_APP_URI, (long)rowID);
                break;
            }
            case 12: {
                rowID = db.insert("location", "", values);
                _uri = ContentUris.withAppendedId((Uri)FoveaContract.Location.CONTENT_LOCATION_URI, (long)rowID);
                break;
            }
            case 15: {
                rowID = db.insert("likes", "", values);
                _uri = ContentUris.withAppendedId((Uri)FoveaContract.Likes.CONTENT_LIKES_URI, (long)rowID);
                break;
            }
            case 18: {
                rowID = db.insert("appInvites", "", values);
                _uri = ContentUris.withAppendedId((Uri)FoveaContract.AppInvites.CONTENT_APPINVITES_URI, (long)rowID);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI " + uri);
            }
        }
        if (rowID > 0L) {
            return _uri;
        }
        throw new SQLException("Failed to add a record into " + uri);
    }

    public static synchronized int delete(Context context, Uri uri, String selection, String[] selectionArgs) {
        if (db == null) {
            FoveaDatabaseManager.initializeFoveaDatabase(context);
        }
        int count = 0;
        String id = null;
        switch (uriMatcher.match(uri)) {
            case 17: {
                count = db.delete("userProfile", selection, selectionArgs);
                break;
            }
            case 4: {
                count = db.delete("calls", selection, selectionArgs);
                break;
            }
            case 5: {
                id = uri.getLastPathSegment();
                count = db.delete("calls", "_id = " + id + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 1: 
            case 3: {
                count = db.delete("people", selection, selectionArgs);
                break;
            }
            case 2: {
                id = uri.getLastPathSegment();
                count = db.delete("people", "_id = " + id + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 6: {
                count = db.delete("sms", selection, selectionArgs);
                break;
            }
            case 7: {
                id = uri.getLastPathSegment();
                count = db.delete("sms", "_id = " + id + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 8: {
                count = db.delete("history", selection, selectionArgs);
                FoveaLog.d(TAG, "History items deleted: " + count);
                break;
            }
            case 9: {
                id = uri.getLastPathSegment();
                count = db.delete("history", "_id = " + id + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 10: {
                count = db.delete("app", selection, selectionArgs);
                break;
            }
            case 11: {
                id = uri.getLastPathSegment();
                count = db.delete("app", "_id = " + id + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 12: {
                count = db.delete("location", selection, selectionArgs);
                break;
            }
            case 14: {
                id = uri.getLastPathSegment();
                count = db.delete("location", "_id = " + id + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
            }
            case 15: {
                count = db.delete("likes", selection, selectionArgs);
                break;
            }
            case 16: {
                id = uri.getLastPathSegment();
                count = db.delete("likes", "_id = " + id + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 18: {
                count = db.delete("appInvites", selection, selectionArgs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI " + uri);
            }
        }
        return count;
    }

    public static synchronized int update(Context context, Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        if (db == null) {
            FoveaDatabaseManager.initializeFoveaDatabase(context);
        }
        int count = 0;
        SharedPreferences prefs = context.getSharedPreferences("FoveaPrefsFile", 0);
        String userId = prefs.getString("Fovea_userID", "");
        values.put("foveaUserID", userId);
        switch (uriMatcher.match(uri)) {
            case 17: {
                count = db.update("userProfile", values, selection, selectionArgs);
                break;
            }
            case 4: {
                count = db.update("calls", values, selection, selectionArgs);
                break;
            }
            case 5: {
                count = db.update("calls", values, "_id = " + uri.getLastPathSegment() + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 1: 
            case 3: {
                count = db.update("people", values, selection, selectionArgs);
                break;
            }
            case 2: {
                count = db.update("people", values, "_id = " + uri.getLastPathSegment() + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 6: {
                count = db.update("sms", values, selection, selectionArgs);
                break;
            }
            case 7: {
                count = db.update("sms", values, "_id = " + uri.getLastPathSegment() + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 8: {
                count = db.update("history", values, selection, selectionArgs);
                break;
            }
            case 9: {
                count = db.update("history", values, "_id = " + uri.getLastPathSegment() + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 10: {
                count = db.update("app", values, selection, selectionArgs);
                break;
            }
            case 11: {
                count = db.update("app", values, "_id = " + uri.getLastPathSegment() + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 12: {
                count = db.update("location", values, selection, selectionArgs);
                break;
            }
            case 14: {
                count = db.update("location", values, "_id = " + uri.getLastPathSegment() + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
            }
            case 15: {
                count = db.update("likes", values, selection, selectionArgs);
                break;
            }
            case 16: {
                count = db.update("likes", values, "_id = " + uri.getLastPathSegment() + (!TextUtils.isEmpty((CharSequence)selection) ? " AND (" + selection + ')' : ""), selectionArgs);
                break;
            }
            case 18: {
                count = db.update("appInvites", values, selection, selectionArgs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI " + uri);
            }
        }
        return count;
    }

    static {
        TAG = "FoveaRequestResponseManager";
        uriMatcher = new UriMatcher(-1);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "people", 1);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "people/#", 2);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "people/*", 3);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "calls", 4);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "calls/#", 5);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "sms", 6);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "sms/#", 7);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "history", 8);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "history/#", 9);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "app", 10);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "app/#", 11);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "location", 12);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "location/#", 14);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "likes", 15);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "likes/#", 16);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "userProfile", 17);
        uriMatcher.addURI("com.cogknit.fovea.providers.FoveaContract", "appInvites", 18);
    }

    private static class TableStructures {
        public static final String userProfile = "create table if not exists userProfile(_id INTEGER primary key AUTOINCREMENT,uniqueUserID uniqueBizUserID,emailID TEXT,phoneNumber TEXT,dateOfBirth TEXT,gender NUMBER,timestamp NUMBER,name TEXT,foveaUserID TEXT not null)";
        public static final String calls = "create table if not exists calls(_id INTEGER primary key AUTOINCREMENT,duration NUMBER not null,number TEXT not null,contact_uri TEXT,timestamp NUMBER not null,name TEXT not null,foveaUserID TEXT not null)";
        public static final String people = "create table if not exists people(_id INTEGER primary key AUTOINCREMENT,duration NUMBER not null,number TEXT not null,timeframe TEXT not null,contact_uri TEXT,frequency NUMBER not null,weight NUMBER not null,name TEXT not null,foveaUserID TEXT not null)";
        public static final String sms = "create table if not exists sms(_id INTEGER primary key AUTOINCREMENT,number TEXT not null,body TEXT,timestamp NUMBER not null,foveaUserID TEXT not null);";
        public static final String history = "create table if not exists history(_id INTEGER primary key AUTOINCREMENT,title TEXT not null,url TEXT,timestamp NUMBER not null,bookmarks INTEGER not null,foveaUserID TEXT not null);";
        public static final String apps = "create table if not exists app(_id INTEGER primary key AUTOINCREMENT,name TEXT not null,packageName TEXT not null,foregroundTime NUMBER not null,foveaUserID TEXT not null)";
        public static final String location = "create table if not exists location(_id INTEGER primary key AUTOINCREMENT,activity INTEGER not null,latitude NUMBER not null,longitude NUMBER not null,timestamp NUMBER not null,foveaUserID TEXT not null);";
        public static final String likes = "create table if not exists likes(_id INTEGER primary key AUTOINCREMENT,id TEXT UNIQUE not null ,name TEXT not null,category TEXT,category_other TEXT,timestamp NUMBER not null,foveaUserID TEXT not null);";
        public static final String appInvites = "create table if not exists appInvites(_id INTEGER primary key AUTOINCREMENT,deviceFamilyID NUMBER,inviteePh TEXT not null,inviteeEmail TEXT,inviteeWeight NUMBER not null,platformID NUMBER,inviteeName TEXT not null,statusID NUMBER not null,timestamp NUMBER,foveaUserID TEXT not null)";

        private TableStructures() {
        }
    }

    public static class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context) {
            super(context, FoveaDatabaseManager.dbName, null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("create table if not exists userProfile(_id INTEGER primary key AUTOINCREMENT,uniqueUserID uniqueBizUserID,emailID TEXT,phoneNumber TEXT,dateOfBirth TEXT,gender NUMBER,timestamp NUMBER,name TEXT,foveaUserID TEXT not null)");
            db.execSQL("create table if not exists people(_id INTEGER primary key AUTOINCREMENT,duration NUMBER not null,number TEXT not null,timeframe TEXT not null,contact_uri TEXT,frequency NUMBER not null,weight NUMBER not null,name TEXT not null,foveaUserID TEXT not null)");
            db.execSQL("create table if not exists appInvites(_id INTEGER primary key AUTOINCREMENT,deviceFamilyID NUMBER,inviteePh TEXT not null,inviteeEmail TEXT,inviteeWeight NUMBER not null,platformID NUMBER,inviteeName TEXT not null,statusID NUMBER not null,timestamp NUMBER,foveaUserID TEXT not null)");
            db.execSQL("create table if not exists calls(_id INTEGER primary key AUTOINCREMENT,duration NUMBER not null,number TEXT not null,contact_uri TEXT,timestamp NUMBER not null,name TEXT not null,foveaUserID TEXT not null)");
            db.execSQL("create table if not exists sms(_id INTEGER primary key AUTOINCREMENT,number TEXT not null,body TEXT,timestamp NUMBER not null,foveaUserID TEXT not null);");
            db.execSQL("create table if not exists history(_id INTEGER primary key AUTOINCREMENT,title TEXT not null,url TEXT,timestamp NUMBER not null,bookmarks INTEGER not null,foveaUserID TEXT not null);");
            db.execSQL("create table if not exists app(_id INTEGER primary key AUTOINCREMENT,name TEXT not null,packageName TEXT not null,foregroundTime NUMBER not null,foveaUserID TEXT not null)");
            db.execSQL("create table if not exists location(_id INTEGER primary key AUTOINCREMENT,activity INTEGER not null,latitude NUMBER not null,longitude NUMBER not null,timestamp NUMBER not null,foveaUserID TEXT not null);");
            db.execSQL("create table if not exists likes(_id INTEGER primary key AUTOINCREMENT,id TEXT UNIQUE not null ,name TEXT not null,category TEXT,category_other TEXT,timestamp NUMBER not null,foveaUserID TEXT not null);");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE IF EXISTS userProfile");
            db.execSQL("DROP TABLE IF EXISTS calls");
            db.execSQL("DROP TABLE IF EXISTS people");
            db.execSQL("DROP TABLE IF EXISTS sms");
            db.execSQL("DROP TABLE IF EXISTS history");
            db.execSQL("DROP TABLE IF EXISTS app");
            db.execSQL("DROP TABLE IF EXISTS location");
            this.onCreate(db);
            db.execSQL("DROP TABLE IF EXISTS likes");
            this.onCreate(db);
        }

        public ArrayList<Cursor> getData(String Query) {
            SQLiteDatabase sqlDB = this.getWritableDatabase();
            String[] columns = new String[]{"mesage"};
            ArrayList<Cursor> alc = new ArrayList<Cursor>(2);
            MatrixCursor Cursor2 = new MatrixCursor(columns);
            alc.add(null);
            alc.add(null);
            try {
                String maxQuery = Query;
                Cursor c = sqlDB.rawQuery(maxQuery, null);
                Cursor2.addRow(new Object[]{"Success"});
                alc.set(1, (Cursor)Cursor2);
                if (null != c && c.getCount() > 0) {
                    alc.set(0, c);
                    c.moveToFirst();
                    return alc;
                }
                return alc;
            }
            catch (SQLException sqlEx) {
                FoveaLog.d("printing exception", sqlEx.getMessage());
                Cursor2.addRow(new Object[]{"" + sqlEx.getMessage()});
                alc.set(1, (Cursor)Cursor2);
                return alc;
            }
            catch (Exception ex) {
                FoveaLog.d("printing exception", ex.getMessage());
                Cursor2.addRow(new Object[]{"" + ex.getMessage()});
                alc.set(1, (Cursor)Cursor2);
                return alc;
            }
        }
    }
}

