/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.providers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.cogknit.fovea.dataModel.App;
import com.cogknit.fovea.dataModel.History;
import com.cogknit.fovea.dataModel.Person;
import com.cogknit.fovea.dataModel.Sms;
import com.cogknit.fovea.dataModel.UserLocation;
import com.cogknit.fovea.providers.AppInvite;
import com.cogknit.fovea.providers.FoveaAppInvitee;
import com.cogknit.fovea.providers.FoveaContract;
import com.cogknit.fovea.providers.FoveaDatabaseManager;
import java.util.ArrayList;
import java.util.List;

class FoveaDataFetchHelper {
    private Context context;

    public FoveaDataFetchHelper(Context context) {
        this.context = context;
    }

    public List getAppsData(String userID) {
        ArrayList<App> content = new ArrayList<App>();
        Uri mUri = FoveaContract.Apps.CONTENT_APP_URI;
        String selection = "foveaUserID=\"" + userID + "\"";
        Cursor c = FoveaDatabaseManager.query(this.context, mUri, null, selection, null, null);
        while (c.moveToNext()) {
            String name = c.getString(c.getColumnIndex("name"));
            String pkgNm = c.getString(c.getColumnIndex("packageName"));
            long foreground = c.getLong(c.getColumnIndex("foregroundTime"));
            String foveaUserID = c.getString(c.getColumnIndex("foveaUserID"));
            App app = new App(name, pkgNm, foreground, foveaUserID);
            content.add(app);
        }
        c.close();
        return content;
    }

    public List getSmsData(String userID) {
        ArrayList<Sms> content = new ArrayList<Sms>();
        Uri mUri = FoveaContract.Sms.CONTENT_SMS_URI;
        String selection = "foveaUserID=\"" + userID + "\"";
        Cursor c = FoveaDatabaseManager.query(this.context, mUri, null, selection, null, null);
        while (c.moveToNext()) {
            String number = c.getString(c.getColumnIndex("number"));
            String body = c.getString(c.getColumnIndex("body"));
            String timestamp = c.getString(c.getColumnIndex("timestamp"));
            String foveaUserID = c.getString(c.getColumnIndex("foveaUserID"));
            Sms sms = new Sms(number, body, timestamp, foveaUserID);
            content.add(sms);
        }
        c.close();
        return content;
    }

    List getPeopleData(String userID) {
        ArrayList<Person> content = new ArrayList<Person>();
        Uri mUri = FoveaContract.People.CONTENT_PEOPLE_URI;
        String selection = "foveaUserID=\"" + userID + "\"";
        Cursor c = FoveaDatabaseManager.query(this.context, mUri, null, selection, null, null);
        while (c.moveToNext()) {
            String name = c.getString(c.getColumnIndex("name"));
            String number = c.getString(c.getColumnIndex("number"));
            long duration = c.getLong(c.getColumnIndex("duration"));
            long frequency = c.getLong(c.getColumnIndex("frequency"));
            Double weight = c.getDouble(c.getColumnIndex("weight"));
            String timeStamp = c.getString(c.getColumnIndex("timeframe"));
            String foveauserID = c.getString(c.getColumnIndex("foveaUserID"));
            Person person = new Person(name, number, duration, frequency, weight, timeStamp, foveauserID);
            content.add(person);
        }
        c.close();
        return content;
    }

    List getHistoryData(String userID) {
        ArrayList<History> content = new ArrayList<History>();
        Uri mUri = FoveaContract.History.CONTENT_HISTORY_URI;
        String selection = "foveaUserID=\"" + userID + "\"";
        Cursor c = FoveaDatabaseManager.query(this.context, mUri, null, selection, null, null);
        while (c.moveToNext()) {
            String title = c.getString(c.getColumnIndex("title"));
            String url = c.getString(c.getColumnIndex("url"));
            String timestamp = c.getString(c.getColumnIndex("timestamp"));
            int isBookmark = c.getInt(c.getColumnIndex("bookmarks"));
            String foveaUserID = c.getString(c.getColumnIndex("foveaUserID"));
            History history = new History(title, url, timestamp, isBookmark, foveaUserID);
            content.add(history);
        }
        c.close();
        return content;
    }

    List getLocationsData(String userID) {
        ArrayList<UserLocation> content = new ArrayList<UserLocation>();
        Uri mUri = FoveaContract.Location.CONTENT_LOCATION_URI;
        String selection = "foveaUserID=\"" + userID + "\"";
        Cursor c = FoveaDatabaseManager.query(this.context, mUri, null, selection, null, null);
        while (c.moveToNext()) {
            double longitude = c.getDouble(c.getColumnIndex("longitude"));
            double latitude = c.getDouble(c.getColumnIndex("latitude"));
            String timestamp = c.getString(c.getColumnIndex("timestamp"));
            int activity = c.getInt(c.getColumnIndex("activity"));
            Long tsLong = System.currentTimeMillis() / 1000L;
            String ts = tsLong.toString();
            String foveaUserID = c.getString(c.getColumnIndex("foveaUserID"));
            UserLocation location = new UserLocation(latitude, longitude, activity, timestamp);
            content.add(location);
        }
        c.close();
        return content;
    }

    private List<AppInvite> getAppInvitesWithCriteria(String selection, String sortOrder) {
        ArrayList<AppInvite> content = new ArrayList<AppInvite>();
        Uri mUri = FoveaContract.AppInvites.CONTENT_APPINVITES_URI;
        Cursor c = FoveaDatabaseManager.query(this.context, mUri, null, selection, null, sortOrder);
        while (c.moveToNext()) {
            String inviteeName = c.getString(c.getColumnIndex("inviteeName"));
            String inviteeEmail = c.getString(c.getColumnIndex("inviteeEmail"));
            String inviteePh = c.getString(c.getColumnIndex("inviteePh"));
            int status = c.getInt(c.getColumnIndex("statusID"));
            int platformID = c.getInt(c.getColumnIndex("platformID"));
            int devicefamilyID = c.getInt(c.getColumnIndex("deviceFamilyID"));
            double inviteeWeight = c.getInt(c.getColumnIndex("inviteeWeight"));
            String timestamp = c.getString(c.getColumnIndex("timestamp"));
            String foveaUserID = c.getString(c.getColumnIndex("foveaUserID"));
            AppInvite.InviteStatus inviteStatus = AppInvite.InviteStatus.values()[status];
            AppInvite.PlatformID platformEnumID = AppInvite.PlatformID.values()[platformID];
            AppInvite.DeviceFamilyID deviceFamilyEnumID = AppInvite.DeviceFamilyID.values()[devicefamilyID];
            AppInvite invite = new AppInvite(inviteeName, inviteeEmail, inviteePh, inviteStatus, inviteeWeight, platformEnumID, deviceFamilyEnumID);
            content.add(invite);
        }
        c.close();
        return content;
    }

    List<AppInvite> getAppInvitesPendingSubmission(String userID) {
        String selection = "foveaUserID=\"" + userID + "\"" + " AND " + "statusID" + "!=" + "\"" + AppInvite.InviteStatus.NoEvent.ordinal() + "\"";
        List<AppInvite> invites = this.getAppInvitesWithCriteria(selection, null);
        return invites;
    }

    List<FoveaAppInvitee> getAppInvites(String userID, int recordCount) {
        String sortOrder;
        List<AppInvite> invites;
        String selection = "foveaUserID=\"" + userID + "\"" + " AND " + "statusID" + "=" + "\"" + AppInvite.InviteStatus.NoEvent.ordinal() + "\"";
        List<FoveaAppInvitee> topRecommendations = invites.subList(0, recordCount > (invites = this.getAppInvitesWithCriteria(selection, sortOrder = "inviteeWeight DESC")).size() ? invites.size() : recordCount);
        return topRecommendations;
    }

    void purgeAppInvitesData(String userID) {
        String selection = "foveaUserID=\"" + userID + "\"";
        this.purgeData(FoveaContract.AppInvites.CONTENT_APPINVITES_URI, selection);
    }

    void purgeAppsData(String userID) {
        String selection = "foveaUserID=\"" + userID + "\"";
        this.purgeData(FoveaContract.Apps.CONTENT_APP_URI, selection);
    }

    void purgeSmsData(String userID) {
        String selection = "foveaUserID=\"" + userID + "\"";
        this.purgeData(FoveaContract.Sms.CONTENT_SMS_URI, selection);
    }

    void purgePeopleData(String userID) {
        String selection = "foveaUserID=\"" + userID + "\"";
        this.purgeData(FoveaContract.People.CONTENT_PEOPLE_URI, selection);
    }

    void purgeHistoryData(String userID) {
        String selection = "foveaUserID=\"" + userID + "\"";
        this.purgeData(FoveaContract.History.CONTENT_HISTORY_URI, selection);
    }

    void purgeLocationsData(String userID) {
        String selection = "foveaUserID=\"" + userID + "\"";
        this.purgeData(FoveaContract.Location.CONTENT_LOCATION_URI, selection);
    }

    int purgeData(Uri uri, String selections) {
        int count = FoveaDatabaseManager.delete(this.context, uri, selections, null);
        return count;
    }

    void saveInfluenceGraph(List<AppInvite> graph) {
        for (AppInvite invite : graph) {
            FoveaDatabaseManager.insert(this.context, FoveaContract.AppInvites.CONTENT_APPINVITES_URI, invite.getContentValues());
        }
    }

    void updateInviteesStatus(AppInvite invite) {
        String selection = "inviteeName=\"" + invite.getInviteeName() + "\"" + " AND " + "inviteePh" + "=" + "\"" + invite.getInviteePhoneNumber() + "\"";
        FoveaDatabaseManager.update(this.context, FoveaContract.AppInvites.CONTENT_APPINVITES_URI, invite.getContentValues(), selection, null);
    }

    void updateInviteesStatusWithDetails(String inviteeName, String inviteePh, AppInvite.InviteStatus status) {
        String selection = "inviteeName=\"" + inviteeName + "\"" + " AND " + "inviteePh" + "=" + "\"" + inviteePh + "\"";
        ContentValues values = new ContentValues();
        values.put("statusID", Integer.valueOf(status.ordinal()));
        FoveaDatabaseManager.update(this.context, FoveaContract.AppInvites.CONTENT_APPINVITES_URI, values, selection, null);
    }
}

