/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.providers;

import android.content.ContentValues;
import com.cogknit.fovea.providers.FoveaAppInvitee;
import com.google.gson.annotations.Expose;
import java.io.Serializable;

class AppInvite
extends FoveaAppInvitee
implements Serializable {
    @Expose
    private String inviteeName;
    @Expose
    private String inviteePh;
    @Expose
    private String inviteeEmail;
    @Expose
    private PlatformID platformID;
    @Expose
    private DeviceFamilyID deviceFamilyID;
    @Expose
    private int statusID;
    @Expose(serialize=false, deserialize=false)
    private double weight;
    private transient String foveaUserID;

    public AppInvite(String name, String email, String phone, Double weight, InviteStatus status) {
        this.inviteeName = name;
        this.inviteeEmail = email;
        this.inviteePh = phone;
        this.weight = weight;
        this.statusID = status.ordinal();
    }

    public AppInvite(String name, String email, String phone, InviteStatus status, Double weight, PlatformID platformID, DeviceFamilyID deviceFamilyID) {
        this.inviteeName = name;
        this.inviteeEmail = email;
        this.inviteePh = phone;
        this.statusID = status.ordinal();
        this.platformID = platformID;
        this.deviceFamilyID = deviceFamilyID;
        this.weight = weight;
    }

    public void setStatus(InviteStatus status) {
        this.statusID = status.ordinal();
    }

    @Override
    public String getInviteeName() {
        return this.inviteeName;
    }

    @Override
    String getInviteePhoneNumber() {
        return this.inviteePh;
    }

    public ContentValues getContentValues() {
        ContentValues values = new ContentValues();
        values.put("inviteeName", this.inviteeName);
        values.put("inviteeEmail", this.inviteeEmail);
        values.put("inviteePh", this.inviteePh);
        values.put("statusID", Integer.valueOf(this.statusID));
        values.put("inviteeWeight", Double.valueOf(this.weight));
        values.put("platformID", Integer.valueOf(this.platformID.getValue()));
        values.put("deviceFamilyID", Integer.valueOf(this.deviceFamilyID.getValue()));
        values.put("foveaUserID", this.foveaUserID);
        return values;
    }

    public static enum DeviceFamilyID {
        UNKNOWN(0),
        SMART_PHONE(1),
        TABLET(2),
        OTHER(3);

        private final int id;

        private DeviceFamilyID(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }
    }

    public static enum PlatformID {
        UNKNOWN(0),
        ANDROID(1),
        IOS(2),
        WEB(3);

        private final int id;

        private PlatformID(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }
    }

    public static enum InviteStatus {
        NoEvent,
        Installed,
        Invited,
        Reminded,
        InviteDeniedByuser;

    }
}

