/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea;

import android.content.Context;
import android.content.SharedPreferences;
import com.cogknit.fovea.FoveaCallback;
import com.cogknit.fovea.FoveaConstants;
import com.cogknit.fovea.FoveaManager;
import com.cogknit.fovea.FoveaUserProfile;
import com.cogknit.fovea.providers.FoveaAppInvitee;
import com.cogknit.fovea.utils.DeviceUtility;
import com.cogknit.fovea.utils.FoveaLog;
import java.util.List;

public class Fovea {
    private static FoveaManager foveaManager = null;
    private static final String TAG = "Fovea";

    public static void initialize(Context context, String appKey, String clientKey, FoveaConstants.Services[] services, FoveaCallback foveaCallback) {
        if (null == foveaManager) {
            foveaManager = new FoveaManager(appKey, clientKey, context);
        }
        if (services != null) {
            for (FoveaConstants.Services service : services) {
                if (DeviceUtility.checkIfPermissionsGrantedAndEnableContexts(context, service)) {
                    service.activateService(context);
                    continue;
                }
                foveaCallback.onFailure(new Exception("Necessary permissions for " + service.name() + " service is missing from the manifest or not granted by the user! Please add and retry."));
            }
            for (FoveaConstants.Services service : FoveaConstants.Services.values()) {
                FoveaLog.d(TAG, service.name() + ": " + service.getStatus(context));
            }
        }
        foveaManager.initialize(context, foveaCallback);
    }

    public static void setCustomerProfileDetails(FoveaUserProfile customerProfile, FoveaCallback callback) {
        if (null == foveaManager) {
            callback.onFailure(new UninitializedException());
        }
        foveaManager.setUserProfileDetails(customerProfile);
        callback.onCompletion();
    }

    public static void setFacebookAccessToken(Context context, String token) throws UninitializedException {
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        Boolean hasAuthenticated = settings.getBoolean("isSDKAuthorized", false);
        if (!hasAuthenticated.booleanValue()) {
            throw new UninitializedException();
        }
        if (null == foveaManager) {
            Fovea.initializeFoveaManager(context);
        }
        foveaManager.setFbAccessToken(token);
    }

    public static List<FoveaAppInvitee> getAppInvitees(Context context) throws UninitializedException {
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        Boolean hasAuthenticated = settings.getBoolean("isSDKAuthorized", false);
        if (!hasAuthenticated.booleanValue()) {
            throw new UninitializedException();
        }
        if (null == foveaManager) {
            Fovea.initializeFoveaManager(context);
        }
        return foveaManager.getAppInvitees();
    }

    public static void proceedWithAppInvites(Context context, List<FoveaAppInvitee> approvedInvitees, List<FoveaAppInvitee> deniedInvitees, String inviteMessage) throws UninitializedException, AppInviteException {
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        Boolean hasAuthenticated = settings.getBoolean("isSDKAuthorized", false);
        if (!hasAuthenticated.booleanValue()) {
            throw new UninitializedException();
        }
        if (null == foveaManager) {
            Fovea.initializeFoveaManager(context);
        }
        foveaManager.feedbackOnAppInvites(approvedInvitees, deniedInvitees, inviteMessage);
    }

    private static void initializeFoveaManager(Context context) {
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        String appkey = settings.getString("appKey", "");
        String clientKey = settings.getString("clientKey", "");
        foveaManager = new FoveaManager(appkey, clientKey, context);
    }

    public static class AppInviteException
    extends Exception {
        public AppInviteException(String reason) {
            super(reason);
        }
    }

    public static class UninitializedException
    extends Exception {
        public UninitializedException() {
            super("Please invoke initialize and successfully authorize with keys before accessing this service");
        }
    }
}

