package com.cogknit.fovea.utils;


public abstract class SchedulerConstants {

	/**
	 * ACTION values for the AlarmManageer
	 */
	
	public static final class AlarmActions{

		/**
		 * Action value to fetch local data
		 */
		public static final String ACTION_LOCAL_DATA_FETCH="com.cogknit.goglocallibrary.actions.fetch.local";
		/**
		 * Action value to fetch app data
		 */
		public static final String ACTION_APP_FETCH="com.cogknit.goglocallibrary.actions.fetch.app";
		/**
		 * Action value to push app data to back-end
		 */
		public static final String ACTION_REMOTE_PUSH="com.cogknit.goglocallibrary.actions.remote.push";
		/**
		 * Action value to push app data to back-end
		 */
		public static final String ACTION_LOCATION_TRACK="com.cogknit.goglocallibrary.actions.location.track";
		/**
		 * Action value to push app data to back-end
		 */
		public static final String ACTION_CONFIG_SYNC="com.cogknit.goglocallibrary.actions.config.sync";
		/**
		 * Action value to push device details to the back-end
		 */
		public static final String ACTION_DEVICE_USER_SYNC="com.cogknit.goglocallibrary.actions.deviceUser.sync";

	}
	
	public static final class LocalFetch{

		/**
		 * Action value for fetching call logs data
		 */
		public static final String ACTION_CALLLOGS="com.cogknit.goglocallibrary.actions.fetch.calllogs";
		/**
		 * Action value for fetching people data
		 */
		public static final String ACTION_PEOPLE="com.cogknit.goglocallibrary.actions.fetch.people";
		/**
		 * Action value for history items
		 */
		public static final String ACTION_HISTORY="com.cogknit.goglocallibrary.actions.fetch.history;";
		/**
		 * Action value for sms
		 */
		public static final String ACTION_SMS="com.cogknit.goglocallibrary.actions.fetch.sms";
		
		
	}

	public static final class FacebookSync{
		/**
		 * Action value for a facebook ME request
		 */
		public static final String ACTION_FB_ME="com.cogknit.fovea.fb.me";

		/**
		 * Action value for a facebook LIKES request
		 */
		public static final String ACTION_FB_LIKES="com.cogknit.fovea.fb.likes";

		/**
		 * Action value for a facebook FRIENDS request
		 */
		public static final String ACTION_FB_FRIENDS="com.cogknit.fovea.fb.friends";
	}

	public static final class MiningContexts{
		/**
		 * Action value for People Context
		 */
		public static final String PEOPLE_CONTEXT ="com.cogknit.fovea.context.people";

		/**
		 * Action value for Apps Context
		 */
		public static final String APPS_CONTEXT ="com.cogknit.fovea.context.apps";

		/**
		 * Action value for Locations Context
		 */
		public static final String LOCATIONS_CONTEXT ="com.cogknit.fovea.context.locations";

		/**
		 * Action value for History Context
		 */
		public static final String HISTORY_CONTEXT ="com.cogknit.fovea.context.history";

		/**
		 * Action value for SMS Context
		 */
		public static final String SMS_CONTEXT ="com.cogknit.fovea.context.sms";
	}
	
}
