package com.cogknit.fovea.utils;

/**
 * Constants for the Location Module
 * @author Chirag
 *
 */
public class LocationConstants {
	/**
	 * The confidence threshold for accepting an activity update
	 */
	public static final int CONFIDENCE_THRESHOLD = 50;
	/**
	 * The activity sampling rate. Activity update requests will be made with this value.
	 */
	public static final long ACTIVITY_SAMPLE_RATE = 1000 * 30;
	/**
	 * EXTRA NAME for the extrav containing the detected activity
	 */
	public static final String EXTRA_ACTIVITY = "com.cogknit.locationmodule.extras.EXTRA_ACTIVITY";
	/**
	 * ACTION for activity broadcast from FusedIntent service to LocationController
	 */
	public static final String ACTION_ACTIVITY_RESPONSE = "com.cogknit.locationmodule.action.ACTIVITY_RESPONSE";
	/**
	 * ACTION for location broadcast from FusedIntent service to LocationController
	 */
	public static final String ACTION_LOCATION_RESPONSE = "com.cogknit.locationmodule.action.LOCATION_RESPONSE";
	
	/**
	 * Interval constants expressed in milliseconds
	 * @author Chirag
	 *
	 */
	public static class Intervals {

		public static final long TEN_SECONDS = 1000 * 10;
		public static final long TWENTY_SECONDS = 1000 * 20;
		public static final long FORTY_SECONDS = 1000 * 40;
		public static final long ONE_MINUTE = 1000 * 60;
		public static final long NONE = -1;
		
	}
	/**
	 * Array to map an activity(index) to the desired location update value(value)
	 */
	public static final long[] activityInterval = { Intervals.TEN_SECONDS,
			Intervals.TWENTY_SECONDS, Intervals.ONE_MINUTE, Intervals.NONE,
			Intervals.NONE, Intervals.NONE, Intervals.NONE,
			Intervals.ONE_MINUTE, Intervals.FORTY_SECONDS };
	/**
	 * Array to map an activity(index) to a human readable String(value)
	 */
	public static final String[] activityText = { "Vehicle", "Cycle", "Foot",
			"Still", "Unknown", "Tilt", "Undefined", "Walking", "Running", "Homogenous Matching, Activity changed!" };
}
