package com.cogknit.fovea.utils;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Patterns;

import com.cogknit.fovea.FoveaConstants;
import com.cogknit.fovea.FoveaSharedPreferences;

import java.util.regex.Pattern;

/**
 * Created by Maithri V M on 08/10/15.
 */
public class DeviceUtility {
    private static String PERMISSION_PHONE_STATE = "android.permission.READ_PHONE_STATE";
    private static String PERMISSION_CALL_LOG = "android.permission.READ_CALL_LOG";
    private static String PERMISSION_SEND_SMS = "android.permission.SEND_SMS";
    private static String PERMISSION_APPS_USAGE = "android.permission.PACKAGE_USAGE_STATS";
    private static String PERMISSION__LEGACY_APPS_USAGE = "android.permission.GET_TASKS";
    private static String PERMISSION_LOCATION = "android.permission.ACCESS_COARSE_LOCATION";
    private static String ACTIVITY_RECOGNITION = "com.google.android.gms.permission.ACTIVITY_RECOGNITION";
    private static String PERMISSION_BROWSER_HISTORY = "com.android.browser.permission.READ_HISTORY_BOOKMARKS";

    public static String getDevicePhoneNumber (Context context)
    {
        String mPhoneNumber = "Unknown";

        String permission = PERMISSION_PHONE_STATE;
        if(DeviceUtility.isPermissionGranted(context,permission))
        {
            TelephonyManager tMgr = (TelephonyManager)context.getSystemService(Context.TELEPHONY_SERVICE);
            mPhoneNumber = tMgr.getLine1Number();
            if ((mPhoneNumber == null) || mPhoneNumber.equals(""))
            {
                mPhoneNumber = "Unknown";
            }
        }
        return mPhoneNumber;
    }

    public static String getDeviceEmail (Context context)
    {
        Pattern emailPattern = Patterns.EMAIL_ADDRESS; // API level 8+
        Account[] accounts = AccountManager.get(context).getAccounts();
        for (Account account : accounts) {
            if (emailPattern.matcher(account.name).matches()) {
                String possibleEmail = account.name;
                return possibleEmail;
            }
        }
        return null;
    }

    private static boolean isPermissionGranted (Context context, String permission)
    {
        int res = context.checkCallingOrSelfPermission(permission);
        if (res == PackageManager.PERMISSION_GRANTED)
        {
            return true;
        }
        return false;
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    private static boolean isAppUsageStatsPermissionGranted(Context context){

        //check if Apps usage permissions are granted
        if (Build.VERSION.SDK_INT < 21)
        {
            if(DeviceUtility.isPermissionGranted(context, PERMISSION__LEGACY_APPS_USAGE))
                return true;
        }
        else
        {
            AppOpsManager appOps=(AppOpsManager)(context.getSystemService(Context.APP_OPS_SERVICE));
            boolean granted=appOps.checkOpNoThrow("android:get_usage_stats",android.os.Process.myUid(),context.getPackageName())==AppOpsManager.MODE_ALLOWED;
            return granted;
        }
        return false;
    }

    public static boolean checkIfPermissionsGrantedAndEnableContexts(Context context, FoveaConstants.Services service){
        boolean permissible = false;
        SharedPreferences pref = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, 0);
        switch (service){
            case APP_VIRALITY:
                //check if call log permissions are granted
                if((DeviceUtility.isPermissionGranted(context, PERMISSION_CALL_LOG)) &&
                        (DeviceUtility.isPermissionGranted(context, PERMISSION_SEND_SMS)))
                {
                    permissible = true;
                    pref.edit().putBoolean(SchedulerConstants.MiningContexts.PEOPLE_CONTEXT,true).commit();
                }
                break;
            case APP_USAGE_DASHBOARD:
                //check if Apps usage permissions are granted
                if(DeviceUtility.isAppUsageStatsPermissionGranted(context))
                {
                    permissible = true;
                    pref.edit().putBoolean(SchedulerConstants.MiningContexts.APPS_CONTEXT,true).commit();
                }
                break;
            case APP_USERLOCATION_DASHBOARD:
                //check if Location permissions are granted
                if((DeviceUtility.isPermissionGranted(context, PERMISSION_LOCATION))&&
                        (DeviceUtility.isPermissionGranted(context, ACTIVITY_RECOGNITION)))
                {
                    permissible = true;
                    pref.edit().putBoolean(SchedulerConstants.MiningContexts.LOCATIONS_CONTEXT,true).commit();
                }
                break;
            case DISCOVERY:
                //check if any of the permissions are granted
                if((DeviceUtility.isPermissionGranted(context, PERMISSION_APPS_USAGE)) ||
                        (DeviceUtility.isPermissionGranted(context, PERMISSION_CALL_LOG)) ||
                        (DeviceUtility.isPermissionGranted(context, PERMISSION_BROWSER_HISTORY)))
                {
                    permissible = true;
                    if(DeviceUtility.isPermissionGranted(context, PERMISSION_BROWSER_HISTORY))
                        pref.edit().putBoolean(SchedulerConstants.MiningContexts.HISTORY_CONTEXT,true).commit();
                    if(DeviceUtility.isPermissionGranted(context, PERMISSION_CALL_LOG))
                        pref.edit().putBoolean(SchedulerConstants.MiningContexts.PEOPLE_CONTEXT,true).commit();
                    if(DeviceUtility.isAppUsageStatsPermissionGranted(context))
                        pref.edit().putBoolean(SchedulerConstants.MiningContexts.APPS_CONTEXT,true).commit();
                }
                break;
            case FB:
                return true;
        }
        return permissible;
    }
}
