package com.cogknit.fovea.services;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.IntentService;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.IBinder;

import com.cogknit.fovea.dataModel.App;
import com.cogknit.fovea.providers.FoveaContract;
import com.cogknit.fovea.providers.FoveaContract.Apps;
import com.cogknit.fovea.providers.FoveaDatabaseManager;
import com.cogknit.fovea.receivers.AlarmReceiver;
import com.cogknit.fovea.utils.FoveaLog;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * Service to get the apps running and update the content provider for API level 21 and above
 * 
 * @author Aastha
 * 
 */
public class ScanAppUsageService extends IntentService {

	private static final String TAG = "ScanAppUsageService";
	/**
	 * HashMap to save app name and the value object App
	 */
	private HashMap<String, App> appUsage = null;
	private HashMap<String, App> newApps = null;

	/**
	 * URI of the table in the database
	 */
	private Uri mUri = FoveaContract.Apps.CONTENT_APP_URI;

	public ScanAppUsageService() {
		super("ScanAppUsageService");
		appUsage = new HashMap<String, App>();
		newApps = new HashMap<String, App>();

	}

	/**
	 * Function to get apps from android and put them in the HashMap(if apps are
	 * already not in there, else update the timing of the apps) for
	 * API level 21 and above
	 */
	@SuppressLint("NewApi")
	@TargetApi(Build.VERSION_CODES.LOLLIPOP)
	void pollAppLollipop() {

		PackageManager pm;
		String taskAppName = null;
		String taskPackageName = null;
		PackageInfo appPackageInfo = null;
		String usageStats = "usagestats";
		long foreground = 0;
		List<UsageStats> stats;

		long today = new Date().getTime();
		long yesterday = today - 24 * 60 * 60 * 1000;
		Date yesterdayDate = new Date(yesterday);

		Calendar beginCal = Calendar.getInstance();
		beginCal.setTime(yesterdayDate);

		Calendar endCal = Calendar.getInstance();

		pm = this.getPackageManager();
		UsageStatsManager mUsageStatsManager = (UsageStatsManager) getSystemService(usageStats);
		stats = mUsageStatsManager.queryUsageStats(
				UsageStatsManager.INTERVAL_DAILY, beginCal.getTimeInMillis(),
				endCal.getTimeInMillis());

		
		for (UsageStats task : stats) {
			try {
				taskPackageName = task.getPackageName();
				appPackageInfo = pm.getPackageInfo(taskPackageName, 0);
				taskAppName = appPackageInfo.applicationInfo.loadLabel(pm)
						.toString();
				foreground = task.getTotalTimeInForeground() / 1000;
				if (appUsage.containsKey(taskAppName)) {
					App app = appUsage.get(taskAppName);
					app.addForegroundTime(foreground);
				} else if (newApps.containsKey(taskAppName)) {
					App app = newApps.get(taskAppName);
					app.addForegroundTime(foreground);
				} else {
					App newApp = new App(taskAppName, taskPackageName,
							foreground,"");
					newApps.put(taskAppName, newApp);
				}

			} catch (NameNotFoundException e) {
				e.printStackTrace();
			}
		}

		for (HashMap.Entry<String, App> entry : appUsage.entrySet()) {
			String selection = Apps.Columns.PACKAGE_NAME + " = \""
					+ entry.getValue().getPackageName()+"\"";
			/*getContentResolver().update(mUri,
					entry.getValue().getContentValues(), selection, null);*/
			FoveaDatabaseManager.update(this.getApplicationContext(),mUri,
					entry.getValue().getContentValues(), selection, null);

		}

		for (HashMap.Entry<String, App> entry : newApps.entrySet()) {

			/*getContentResolver().insert(mUri,
					entry.getValue().getContentValues());*/
			FoveaDatabaseManager.insert(this.getApplicationContext(),mUri,
					entry.getValue().getContentValues());

		}
	}

	@Override
	public IBinder onBind(Intent intent) {
		return null;
	}

	@Override
	protected void onHandleIntent(Intent intent) {
		Cursor c;

		/*c = getContentResolver().query(mUri, null, null, null, null);*/
		c = FoveaDatabaseManager.query(this.getApplicationContext(),mUri, null, null, null, null);
		while (c.moveToNext()) {
			/**
			 * Get the list of apps and the info about them from the content
			 * provider and put them into the HashMap appUsage
			 */
			String name = c.getString(c
					.getColumnIndex(FoveaContract.Apps.Columns.NAME));
			String pkgNm = c
					.getString(c
							.getColumnIndex(FoveaContract.Apps.Columns.PACKAGE_NAME));
			long foreground = c
					.getLong(c
							.getColumnIndex(FoveaContract.Apps.Columns.FOREGROUND_TIME));

			App app = new App(name, pkgNm, foreground,"");
			appUsage.put(name, app);
		}
		c.close();
		FoveaLog.v(TAG, "Capturing..");
		pollAppLollipop();
		AlarmReceiver.completeWakefulIntent(intent);

	}

}
