package com.cogknit.fovea.services;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.os.IBinder;
import android.support.v4.content.LocalBroadcastManager;

import com.cogknit.fovea.dataModel.UserLocation;
import com.cogknit.fovea.providers.FoveaContract;
import com.cogknit.fovea.providers.FoveaDatabaseManager;
import com.cogknit.fovea.utils.FoveaLog;
import com.cogknit.fovea.utils.FusedLocationManager;
import com.cogknit.fovea.utils.LocationConstants;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.FusedLocationProviderApi;

import java.util.LinkedList;

/**
 * Background controller service to manage location logging. Responsible for
 * connecting to Google Play Services, requesting for activity/location updates
 * and handle incoming activity/location updates
 * 
 * @author Chirag
 * 
 */
public class LocationController extends Service {

	//private static final String QTAG = "Q";
	//private static final String TAG = "Controller";
	private FusedLocationManager manager;
	private ActivityQueue activityQueue;
	private int currentActivity;
	private ResponseReceiver receiver;
	public static final int QUEUE_SIZE = 3;
	private static final String TAG = "LocationController";

	@Override
	public void onCreate() {
		super.onCreate();
		manager = new FusedLocationManager(this);
		receiver = new ResponseReceiver();
		LocalBroadcastManager broadcastManager = LocalBroadcastManager
				.getInstance(this);
		broadcastManager.registerReceiver(receiver, new IntentFilter(
				LocationConstants.ACTION_ACTIVITY_RESPONSE));
		broadcastManager.registerReceiver(receiver, new IntentFilter(
				LocationConstants.ACTION_LOCATION_RESPONSE));
		activityQueue = new ActivityQueue();
		FoveaLog.v(TAG, "Initialized..");
	}

	@Override
	public void onDestroy() {
		super.onDestroy();
		manager.shutDown();
		LocalBroadcastManager broadcastManager = LocalBroadcastManager
				.getInstance(this);
		broadcastManager.unregisterReceiver(receiver);
	}

	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		FoveaLog.v(TAG, "Invoked..");
		manager.requestActivityUpdate(LocationConstants.ACTIVITY_SAMPLE_RATE);
		//deleteOldLocations();
		return START_STICKY;

	}

	@Override
	public IBinder onBind(Intent arg0) {
		return null;
	}

	/**
	 * Method used to add an activity to the queue, check for homogeneity and
	 * perform required actions
	 * 
	 * @param activity
	 *            : The new activity which needs to be processed.
	 */
	private void pushToQueue(int activity) {
		if (activityQueue.isQueueFull()) {
			activityQueue.remove();
		}
		activityQueue.add(activity);
		if (activityQueue.isQueueFull()) {

			if (activityQueue.isHomogeneous()) {
				if (activity != currentActivity) {
					manager.requestLocationUpdate(LocationConstants.activityInterval[activity]);
					currentActivity = activity;
					FoveaLog.v(TAG,"New Activity: "+LocationConstants.activityText[activity]);
				}

				activityQueue.clear();
			}

		}
	}
	/**
	 * Class to handle custom queue operations
	 * @author Chirag
	 *
	 */
	private class ActivityQueue extends LinkedList<Integer> {

		private static final long serialVersionUID = 1L;

		/**
		 * Helper method to check if queue has reached it's limit.
		 * @return true if the queue has reached the limit set by LocationController.QUEUE_SIZE
		 */
		private boolean isQueueFull() {
			if (this.size() >= LocationController.QUEUE_SIZE) {
				return true;
			}
			return false;
		}
		
		/**
		 * Helper method to check if all the elements in the queue are the same
		 * @return true if the queue is made up completely of the same elements
		 */
		private boolean isHomogeneous() {

			int key = this.peek();
			for (int i : this) {
				if (i != key)
					return false;
			}
			return true;
		}
	}

	/**
	 * BroadcastReceiver to handle incoming activity and location updates
	 * @author Chirag
	 *
	 */
	private class ResponseReceiver extends BroadcastReceiver {

		@Override
		public void onReceive(Context context, Intent intent) {
			if (intent.getAction() == LocationConstants.ACTION_ACTIVITY_RESPONSE) {
				int activity = intent.getIntExtra(
						LocationConstants.EXTRA_ACTIVITY,
						DetectedActivity.UNKNOWN);
				pushToQueue(activity);
			} else if (intent.getAction() == LocationConstants.ACTION_LOCATION_RESPONSE) {
				Location location = (Location) intent.getExtras().get(
						FusedLocationProviderApi.KEY_LOCATION_CHANGED);
				if(location != null)
				{
					Long tsLong = location.getTime();
					UserLocation uLocation = new UserLocation(
							location.getLatitude(), location.getLongitude(),
							currentActivity, tsLong.toString());
				/*context.getContentResolver().insert(
						FoveaContract.Location.CONTENT_LOCATION_URI,
						uLocation.getContentValues());*/
					FoveaDatabaseManager.insert(context,
							FoveaContract.Location.CONTENT_LOCATION_URI,
							uLocation.getContentValues());
				}
			}
		}

	}
}
