package com.cogknit.fovea.services;

import android.app.ActivityManager;
import android.app.ActivityManager.RunningTaskInfo;
import android.app.AlarmManager;
import android.app.IntentService;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;

import com.cogknit.fovea.dataModel.App;
import com.cogknit.fovea.providers.FoveaContract;
import com.cogknit.fovea.providers.FoveaDatabaseManager;
import com.cogknit.fovea.receivers.AlarmReceiver;
import com.cogknit.fovea.utils.FoveaLog;

import java.util.List;

/**
 * Service to get the apps running and update the content provider on Devices
 * with API level 20 and below
 * 
 * @author Aastha
 * 
 */
public class LegacyAppUsageService extends IntentService {
	public static final String TAG = "LegacyAppUsageService";

	/**
	 * the service should run after every INTERVAL
	 */
	public static final long INTERVAL = 5000;

	public LegacyAppUsageService() {
		super("LegacyAppService");
	}

	/**
	 * Function to query the foreground task and update the provider value.
	 */
	private void pollApps() {

		PackageManager pm;
		String taskAppName = null;
		String taskPackageName = null;
		PackageInfo appPackageInfo = null;

		ActivityManager am = (ActivityManager) this
				.getSystemService(ACTIVITY_SERVICE);
		pm = this.getPackageManager();
		@SuppressWarnings("deprecation")
		List<RunningTaskInfo> runningTasks = am.getRunningTasks(1);
		Uri mUri = FoveaContract.Apps.CONTENT_APP_URI;

		try {
			App app;
			RunningTaskInfo task = runningTasks.get(0);
			taskPackageName = task.topActivity.getPackageName();
			appPackageInfo = pm.getPackageInfo(taskPackageName, 0);
			taskAppName = appPackageInfo.applicationInfo.loadLabel(pm)
					.toString();
			String selection = FoveaContract.Apps.Columns.PACKAGE_NAME
					+ " = \"" + taskPackageName + "\"";
			/*Cursor c = getContentResolver().query(mUri, null, selection, null,
					null);*/
			Cursor c = FoveaDatabaseManager.query(this.getApplicationContext(), mUri, null, selection, null,
					null);
			if (c.moveToNext())
			{
				String name = c.getString(c
						.getColumnIndex(FoveaContract.Apps.Columns.NAME));
				String pkgNm = c
						.getString(c
								.getColumnIndex(FoveaContract.Apps.Columns.PACKAGE_NAME));
				int appId = c.getInt(c
						.getColumnIndex(FoveaContract.Apps.Columns.ID));
				long foreground = c
						.getLong(c
								.getColumnIndex(FoveaContract.Apps.Columns.FOREGROUND_TIME));

				app = new App(name, pkgNm, foreground, "");
				app.addForegroundTime(INTERVAL / 1000);
				/*getContentResolver().update(
						Uri.withAppendedPath(mUri, "" + appId),
						app.getContentValues(), null, null);*/
				FoveaDatabaseManager.update(this.getApplicationContext(),
						Uri.withAppendedPath(mUri, "" + appId),
						app.getContentValues(), null, null);
			} else {
				app = new App(taskAppName, taskPackageName, INTERVAL / 1000, "");
				/*getContentResolver().insert(mUri, app.getContentValues());*/
               FoveaDatabaseManager.insert(this.getApplicationContext(),mUri, app.getContentValues());
			}

			c.close();

		} catch (NameNotFoundException e) {

			e.printStackTrace();
		}

	}

	@Override
	public IBinder onBind(Intent intent) {

		return null;
	}

	@Override
	protected void onHandleIntent(Intent intent) {
		FoveaLog.i(TAG, "Capturing..");
		pollApps();
		AlarmReceiver.completeWakefulIntent(intent);

	}

}
