package com.cogknit.fovea.services;

import android.app.IntentService;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;

import com.cogknit.fovea.utils.FoveaLog;
import com.cogknit.fovea.utils.LocationConstants;
import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.DetectedActivity;

/**
 * An intent service which handles Activity and Location updates from Google
 * Play Services. The Activity and Location updates are extracted, distilled and
 * broadcasted to the LocationController service.
 * 
 * @author Akshay
 * @author Chirag
 * 
 */
public class FusedIntentService extends IntentService {

	public FusedIntentService() {
		super("ActivityIntentService");

	}
	private static final String TAG = "FusedIntentService";

	@Override
	protected void onHandleIntent(Intent intent) {

		if (ActivityRecognitionResult.hasResult(intent)) {
			FoveaLog.d(TAG, "Incoming activity intent...");
			ActivityRecognitionResult result = ActivityRecognitionResult
					.extractResult(intent);

			DetectedActivity activity = result.getMostProbableActivity();

			int activityType = activity.getType();
			int activityConfidence = activity.getConfidence();

			if (activityConfidence > LocationConstants.CONFIDENCE_THRESHOLD) {

				Intent dispatch = new Intent(
						LocationConstants.ACTION_ACTIVITY_RESPONSE);
				dispatch.putExtra(LocationConstants.EXTRA_ACTIVITY,
						activityType);
				LocalBroadcastManager manager = LocalBroadcastManager
						.getInstance(this);
				manager.sendBroadcast(dispatch);

			}
		} else {
			FoveaLog.d(TAG, "Incoming location intent...");
			intent.setAction(LocationConstants.ACTION_LOCATION_RESPONSE);
			LocalBroadcastManager manager = LocalBroadcastManager
					.getInstance(this);
			manager.sendBroadcast(intent);
		}
	}

}
