package com.cogknit.fovea.services;

import android.app.IntentService;
import android.content.Intent;

import com.cogknit.fovea.providers.FoveaSynchronizationManager;
import com.cogknit.fovea.receivers.AlarmReceiver;
import com.cogknit.fovea.utils.FoveaLog;
import com.cogknit.fovea.utils.SchedulerConstants;


/**
 * Intent Service to data to the backend.
 *
 */
public class FoveaSyncService extends IntentService {

    private static final String TAG="FoveaSyncService";
    public FoveaSyncService() {
        super("FoveaSyncService");
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        String action=intent.getAction();
        if(action== SchedulerConstants.AlarmActions.ACTION_REMOTE_PUSH){
            FoveaLog.v(TAG, "Sync Service Activated.");
            FoveaSynchronizationManager syncManager = new FoveaSynchronizationManager();
            syncManager.performDataSynchronization(getApplicationContext());
        }
        else if (action == SchedulerConstants.AlarmActions.ACTION_DEVICE_USER_SYNC) {
            FoveaSynchronizationManager synchronizationManager = new FoveaSynchronizationManager();
            synchronizationManager.performDeviceDetailsSynchronization(getApplicationContext());
        }
        else if(action==SchedulerConstants.AlarmActions.ACTION_CONFIG_SYNC){
            FoveaSynchronizationManager synchronizationManager = new FoveaSynchronizationManager();
            synchronizationManager.performClientConfigSynchronization(getApplicationContext());
        }
        AlarmReceiver.completeWakefulIntent(intent);
    }
}
