package com.cogknit.fovea.remote;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.support.v4.content.LocalBroadcastManager;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.cogknit.fovea.FoveaSharedPreferences;
import com.cogknit.fovea.FoveaUserProfile;
import com.cogknit.fovea.dataModel.AuthRequest;
import com.cogknit.fovea.receivers.RefreshTokenReceiver;
import com.cogknit.fovea.remote.FoveaResponse.FoveaErrorListener;
import com.cogknit.fovea.remote.FoveaResponse.FoveaResponseListener;
import com.cogknit.fovea.utils.FoveaLog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Maithri V M on 25/08/15.
 */
public class FoveaRequestResponseManager {

    private Context context;
    private String TAG = "FoveaRequestResponseManager";
    private String ACCESS_TOKEN = "access_token";
    private String FOVEAUSERID = "foveaUserID";
    private static RequestQueue queue;
    public static String REFRESHTOKEN_ACTION_TAG = "RefreshToken";
    public static String CONEXTPUSH_ACTION_TYPE = "CONEXTPUSH_ACTION_TYPE";
    private static RefreshTokenReceiver refreshTokenListener = null;
    public FoveaRequestResponseManager(Context c) {
        context = c;
        if (queue == null) queue = Volley.newRequestQueue(context);
        VolleyLog.DEBUG = false;
        if (refreshTokenListener == null)
        {
            //FoveaLog.v(TAG, "Registering refresh token receiver object");
            refreshTokenListener = new RefreshTokenReceiver();
            LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance(context);
            broadcastManager.registerReceiver(refreshTokenListener, new IntentFilter(FoveaRequestResponseManager.REFRESHTOKEN_ACTION_TAG));
        }

    }

    public void sendAuthorizationRequest(String appKey, String clientKey, final FoveaResponseListener authListener, final FoveaErrorListener authErrorListener) {
        AuthRequest authReq = new AuthRequest(appKey,clientKey,context);

        Gson gson = new Gson();
        final String authJson = gson.toJson(authReq);

        FoveaLog.v(TAG, "Sending a authorization request..." + authJson);
        // Create the request object
        String url =  APIConstants.getAPIClientURL(context) + APIConstants.URL_AUTHORIZATION;
        JsonObjectRequest authorizationRequest = new JsonObjectRequest(
                Request.Method.POST, url, null, new Response.Listener<JSONObject>() {

            @Override
            public void onResponse(JSONObject response) {
                try {
                    FoveaLog.v(TAG, "Auth Response: " + response.toString());

                    SharedPreferences settings = context.getSharedPreferences(
                            FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                    String accessToken = response.get(ACCESS_TOKEN).toString();
                    settings.edit().putString(FoveaSharedPreferences.UserProfile.AccessToken, accessToken).commit();

                    //String foveaUserID = response.get(FOVEAUSERID).toString();
                    //authListener.onSuccessResponse(foveaUserID);
                    authListener.onSuccessResponse();

                } catch (JSONException exception) {
                    FoveaLog.v(TAG, "exception: " + exception.getLocalizedMessage());
                    authErrorListener.onFoveaErrorResponse(new Exception(exception.getLocalizedMessage()));
                }
            }
        }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if ((response != null) && (response.statusCode == APIConstants.AUTHE_ERROR_CODE)) {
                    FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    authErrorListener.onFoveaErrorResponse(new Exception("Invalid app key or client key or package name mismatch"));

                } else if (error instanceof TimeoutError) {
                    authErrorListener.onFoveaErrorResponse(new Exception("Unable to connect Fovea server, please check the network connectivity"));

                } else {
                    FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    authErrorListener.onFoveaErrorResponse(new Exception("Unable to authorize, due to internal issues"));

                }


            }
        }) {
            @Override
            public String getBodyContentType() {
                return "application/json";
            }

            @Override
            public byte[] getBody() {
                try {
                    return authJson.getBytes(getParamsEncoding());
                } catch (UnsupportedEncodingException uee) {
                    FoveaLog.i(TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }

        };
        // Schedule the request on the queue
        this.processRequest(authorizationRequest);
    }

    public void submitUserProfile(FoveaUserProfile userProfile, final FoveaResponseListener userProfileResponseListener, final FoveaErrorListener userProfileErrorListener) {
        Gson gson = new Gson();
        final String userProfileJson = gson.toJson(userProfile);
        /*Map data = new HashMap();
        data.put("data", userProfile);

        GsonBuilder builder = new GsonBuilder();
        Gson mapGson = builder.create();
        final String upJson = mapGson.toJson(data);*/
        FoveaLog.v(TAG, "Sending a user profile request..." + userProfileJson);

        // Create the request object
        SharedPreferences settings = context.getSharedPreferences(
                FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        String accessToken = settings.getString(FoveaSharedPreferences.UserProfile.AccessToken, "");
        if (accessToken.equalsIgnoreCase(""))
        {
            //If access token is missing, handle refresh token
            Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
            LocalBroadcastManager manager = LocalBroadcastManager.getInstance(context);
            manager.sendBroadcast(dispatch);
            return;
        }
        //String foveaUserID = settings.getString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, "");


        String url = APIConstants.getAPIClientURL(context) + APIConstants.URL_USERPROFILE + "?" + ACCESS_TOKEN + "=" + accessToken;//
        // + "&" + FOVEAUSERID + "=" + foveaUserID;


        JsonObjectRequest userProfileRequest = new JsonObjectRequest(
                Request.Method.POST, url, null, new Response.Listener<JSONObject>() {

            @Override
            public void onResponse(JSONObject response) {
                try {
                    FoveaLog.v(TAG, "User profile Response: " + response.toString());
                    SharedPreferences settings = context.getSharedPreferences(
                            FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                    settings.edit().putString(FoveaSharedPreferences.UserProfile.AccessToken, response.get(ACCESS_TOKEN).toString()).commit();
                    userProfileResponseListener.onSuccessResponse();

                } catch (JSONException exception) {
                    FoveaLog.v(TAG, "exception: " + exception.getLocalizedMessage());

                }

            }
        }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if ((response != null) && (response.statusCode == APIConstants.AUTHE_ERROR_CODE)) {
                    FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    userProfileErrorListener.onFoveaErrorResponse(error);

                    //If access token is stale, handle refresh token
                    FoveaLog.v(TAG, "sending refresh token request ");
                    Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
                    LocalBroadcastManager manager = LocalBroadcastManager.getInstance(context);
                    manager.sendBroadcast(dispatch);
                } else if (error instanceof TimeoutError) {
                    //So, the flag is still "pending user profile sync" hence proceed
                    String networkError = "No internet Access, Check your internet connection.";
                    FoveaLog.v(TAG, "ErrorResponse: " + networkError);
                } else {
                    FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());

                }

            }
        }) {
            @Override
            //protected Map<String, String> getParams() throws AuthFailureError {
            public Map<String, String> getParams() {
                Map mParams = new HashMap<String, String>();
                //mParams.put(ACCESS_TOKEN, Access_Token);
                return mParams;
            }

            @Override
            public String getBodyContentType() {
                return "application/json";
            }

            @Override
            public byte[] getBody() {
                try {
                    return userProfileJson.getBytes(getParamsEncoding());
                } catch (UnsupportedEncodingException uee) {
                    //  To-do: consider if some other action should be taken
                    FoveaLog.i(TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }


        };

        this.processRequest(userProfileRequest);

    }

    void processRequest(Request request) {
        int socketTimeout = 10000;// 10 seconds
        RetryPolicy policy = new DefaultRetryPolicy(socketTimeout,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT);
        request.setRetryPolicy(policy);

        // Schedule the request on the queue
        queue.add(request);
    }

    public void submitContextData(String serviceEndPoint, List items, final FoveaResponseListener dataResponseListener, final FoveaErrorListener dataErrorListener) {

        SharedPreferences settings = context.getSharedPreferences(
                FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        String accessToken = settings.getString(FoveaSharedPreferences.UserProfile.AccessToken, "");

        //String foveaUserID = settings.getString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, "");
        String finalUrl = APIConstants.getAPIClientURL(context) + serviceEndPoint + "?" + ACCESS_TOKEN + "=" + accessToken;//
        // + "&" + FOVEAUSERID + "=" + foveaUserID;

        Map data = new HashMap();
        data.put("data", items);

        GsonBuilder builder = new GsonBuilder();
        Gson mapGson = builder.create();
        final String appJson = mapGson.toJson(data);
        FoveaLog.v(TAG, "Sending a request..." + appJson);

        // Create the request object
        JsonObjectRequest authorizationRequest = new JsonObjectRequest(
                Request.Method.POST, finalUrl, null, new Response.Listener<JSONObject>() {

            @Override
            public void onResponse(JSONObject response) {
                FoveaLog.v(TAG, response.toString());
                try {
                    SharedPreferences settings = context.getSharedPreferences(
                            FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                    settings.edit().putString(FoveaSharedPreferences.UserProfile.AccessToken, response.get(ACCESS_TOKEN).toString()).commit();
                    dataResponseListener.onSuccessResponse();
                } catch (JSONException exception) {
                    FoveaLog.v(TAG, "AppContextException: " + exception.getLocalizedMessage());

                }
            }
        }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if ((response != null) && (response.statusCode == APIConstants.AUTHE_ERROR_CODE)) {
                    //FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    //dataErrorListener.onFoveaErrorResponse(error);
                    //If access token is stale, handle refresh token
                    FoveaLog.v(TAG, "sending refresh token request ");
                    Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
                    LocalBroadcastManager manager = LocalBroadcastManager.getInstance(context);
                    dispatch.putExtra(CONEXTPUSH_ACTION_TYPE,true);
                    manager.sendBroadcast(dispatch);

                } else if (error instanceof TimeoutError) {
                    //So, the flag "pending context sync" is still on, hence  proceed
                    String networkError = "No internet Access, Check your internet connection.";
                    FoveaLog.v(TAG, "ErrorResponse: " + networkError);

                } else {
                    FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    dataErrorListener.onFoveaErrorResponse(error);
                }
            }
        }) {

            @Override
            public String getBodyContentType() {
                return "application/json";
            }

            @Override
            public byte[] getBody() {
                try {
                    return appJson.getBytes(getParamsEncoding());
                } catch (UnsupportedEncodingException uee) {
                    // TO-Do: consider if some other action should be taken
                    FoveaLog.i(TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }

        };
        // Schedule the request on the queue
        this.processRequest(authorizationRequest);
    }

    public void submitInvitesContextData(String serviceEndPoint, List items, final FoveaResponseListener dataResponseListener, final FoveaErrorListener dataErrorListener) {

        SharedPreferences settings = context.getSharedPreferences(
                FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        String accessToken = settings.getString(FoveaSharedPreferences.UserProfile.AccessToken, "");

        //String foveaUserID = settings.getString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, "");
        String finalUrl = APIConstants.getAPIClientURL(context) + serviceEndPoint + "?" + ACCESS_TOKEN + "=" + accessToken;//
        // + "&" + FOVEAUSERID + "=" + foveaUserID;

        Map data = new HashMap();
        data.put("data", items);

        GsonBuilder builder = new GsonBuilder();
        builder.excludeFieldsWithoutExposeAnnotation();
        Gson mapGson = builder.create();
        final String appJson = mapGson.toJson(data);
        FoveaLog.v(TAG, "Sending a request..." + appJson);

        // Create the request object
        JsonObjectRequest authorizationRequest = new JsonObjectRequest(
                Request.Method.POST, finalUrl, null, new Response.Listener<JSONObject>() {

            @Override
            public void onResponse(JSONObject response) {
                FoveaLog.v(TAG, response.toString());
                try {
                    SharedPreferences settings = context.getSharedPreferences(
                            FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                    settings.edit().putString(FoveaSharedPreferences.UserProfile.AccessToken, response.get(ACCESS_TOKEN).toString()).commit();
                    dataResponseListener.onSuccessResponse();
                } catch (JSONException exception) {
                    FoveaLog.v(TAG, "AppContextException: " + exception.getLocalizedMessage());

                }
            }
        }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if ((response != null) && (response.statusCode == APIConstants.AUTHE_ERROR_CODE)) {
                    //FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    //dataErrorListener.onFoveaErrorResponse(error);
                    //If access token is stale, handle refresh token
                    FoveaLog.v(TAG, "sending refresh token request ");
                    Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
                    LocalBroadcastManager manager = LocalBroadcastManager.getInstance(context);
                    dispatch.putExtra(CONEXTPUSH_ACTION_TYPE,true);
                    manager.sendBroadcast(dispatch);

                } else if (error instanceof TimeoutError) {
                    //So, the flag "pending context sync" is still on, hence  proceed
                    String networkError = "No internet Access, Check your internet connection.";
                    FoveaLog.v(TAG, "ErrorResponse: " + networkError);

                } else {
                    FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    dataErrorListener.onFoveaErrorResponse(error);
                }
            }
        }) {

            @Override
            public String getBodyContentType() {
                return "application/json";
            }

            @Override
            public byte[] getBody() {
                try {
                    return appJson.getBytes(getParamsEncoding());
                } catch (UnsupportedEncodingException uee) {
                    // TO-Do: consider if some other action should be taken
                    FoveaLog.i(TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }

        };
        // Schedule the request on the queue
        this.processRequest(authorizationRequest);
    }

    public void sendFbData(String urlString, String payload) {

        final String KEY_DATA = "data";

        SharedPreferences prefs = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        //String foveaUserId = prefs.getString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, "default");
        String accessToken = prefs.getString(FoveaSharedPreferences.UserProfile.AccessToken, "token");
        String url = urlString + "?access_token=" + accessToken;//
        // + "&foveaUserID=" + foveaUserId;

        JSONObject json = new JSONObject();
        try {
            json.put(KEY_DATA, payload);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        final String reqJson = json.toString();

        FoveaLog.d(TAG, "Sending a FB request..." + reqJson);

        // Create the request object
        JsonObjectRequest fbRequest = new JsonObjectRequest(
                Request.Method.POST, url, null, new Response.Listener<JSONObject>() {

            @Override
            public void onResponse(JSONObject response) {

                //FoveaLog.d(TAG, "FB Response: " + response);


            }
        }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if ((response != null) && (response.statusCode == APIConstants.AUTHE_ERROR_CODE)) {
                    FoveaLog.d(TAG, "FB ErrorResponse: " + error.getLocalizedMessage());


                } else if (error instanceof TimeoutError) {
                    FoveaLog.d(TAG, "FB Timeout: " + error.getLocalizedMessage());


                } else {
                    FoveaLog.d(TAG, "FB Unknown Error: " + error.getLocalizedMessage());

                }


            }
        }) {
            @Override
            public String getBodyContentType() {
                return "application/json";
            }

            @Override
            public byte[] getBody() {
                try {
                    return reqJson.getBytes(getParamsEncoding());
                } catch (UnsupportedEncodingException uee) {
                    FoveaLog.i(TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }

        };
        // Schedule the request on the queue
        this.processRequest(fbRequest);
    }

    public void executeJsonRequest(String URL, JSONObject jsonRequest, Response.Listener<JSONObject> successCallback, Response.ErrorListener errorCallback) {
        JsonObjectRequest request = new JsonObjectRequest(URL, jsonRequest, successCallback, errorCallback);

        processRequest(request);
    }

    public void sendDeviceUserDetailsRequest(Object deviceUserDetailsObj, final FoveaResponseListener responseListner, final FoveaErrorListener responseErrorListener) {

        Map data = new HashMap();
        data.put("data", deviceUserDetailsObj);

        GsonBuilder builder = new GsonBuilder();
        Gson mapGson = builder.create();
        final String userDetailsJSON = mapGson.toJson(data);

//        Gson gson = new Gson();
//        final String userDetailsJSON = gson.toJson(deviceUserDetailsObj);

        SharedPreferences settings = context.getSharedPreferences(
                FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        String accessToken = settings.getString(FoveaSharedPreferences.UserProfile.AccessToken, "");

        FoveaLog.v(TAG, "Sending a device user info request..." + userDetailsJSON);
        // Create the request object
        String url = APIConstants.getAPIClientURL(context) + APIConstants.URL_APPINVITES_STATUS+ "?" + ACCESS_TOKEN + "=" + accessToken;;

        JsonObjectRequest authorizationRequest = new JsonObjectRequest(
                Request.Method.POST, url, null, new Response.Listener<JSONObject>() {

            @Override
            public void onResponse(JSONObject response) {
                    FoveaLog.v(TAG, "DeviceUser Response: " + response.toString());
                try {
                    SharedPreferences settings = context.getSharedPreferences(
                            FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                    settings.edit().putString(FoveaSharedPreferences.UserProfile.AccessToken, response.get(ACCESS_TOKEN).toString()).commit();
                    responseListner.onSuccessResponse();
                } catch (JSONException exception) {
                    FoveaLog.v(TAG, "AppContextException: " + exception.getLocalizedMessage());

                }
            }
        }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if ((response != null) && (response.statusCode == APIConstants.AUTHE_ERROR_CODE)) {
                    //FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    //dataErrorListener.onFoveaErrorResponse(error);
                    //If access token is stale, handle refresh token
                    FoveaLog.v(TAG, "sending refresh token request ");
                    LocalBroadcastManager manager = LocalBroadcastManager.getInstance(context);
                    Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
                    manager.sendBroadcast(dispatch);

                } else if (error instanceof TimeoutError) {
                    //So, the flag "pending context sync" is still on, hence  proceed
                    String networkError = "No internet Access, Check your internet connection.";
                    FoveaLog.v(TAG, "ErrorResponse: " + networkError);

                } else {
                    FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    responseErrorListener.onFoveaErrorResponse(error);
                }
            }
        }) {
            @Override
            public String getBodyContentType() {
                return "application/json";
            }

            @Override
            public byte[] getBody() {
                try {
                    return userDetailsJSON.getBytes(getParamsEncoding());
                } catch (UnsupportedEncodingException uee) {
                    FoveaLog.i(TAG, "Exception" + uee.getMessage());
                    return null;
                }
            }

        };
        // Schedule the request on the queue
        this.processRequest(authorizationRequest);
    }

    public void getInfluenceGraphRequest(final FoveaResponse.FoveaDataResponseListener responseListner, final FoveaErrorListener responseErrorListener) {

        FoveaLog.v(TAG, "Sending influence graph request...");
        SharedPreferences settings = context.getSharedPreferences(
                FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        String accessToken = settings.getString(FoveaSharedPreferences.UserProfile.AccessToken, "");

        // Create the request object
        String url = APIConstants.getAPIClientURL(context) + APIConstants.URL_INFLUENCE_GRAPH+ "?" + ACCESS_TOKEN + "=" + accessToken;;

        JsonObjectRequest authorizationRequest = new JsonObjectRequest(
                Request.Method.GET, url, null, new Response.Listener<JSONObject>() {

            @Override
            public void onResponse(JSONObject response) {
                FoveaLog.v(TAG, "Influence graph Response: " + response.toString());
                try {
                    JSONArray influenceList = response.getJSONArray("data");

                    SharedPreferences settings = context.getSharedPreferences(
                            FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                    settings.edit().putString(FoveaSharedPreferences.UserProfile.AccessToken, response.get(ACCESS_TOKEN).toString()).commit();
                    responseListner.onSuccessResponse(influenceList.toString());
                } catch (JSONException exception) {
                    FoveaLog.v(TAG, "Influencegraph exception: " + exception.getLocalizedMessage());

                }
            }
        }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                NetworkResponse response = error.networkResponse;
                if ((response != null) && (response.statusCode == APIConstants.AUTHE_ERROR_CODE)) {
                    //FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    //dataErrorListener.onFoveaErrorResponse(error);
                    //If access token is stale, handle refresh token
                    FoveaLog.v(TAG, "sending refresh token request ");
                    Intent dispatch = new Intent(REFRESHTOKEN_ACTION_TAG);
                    LocalBroadcastManager manager = LocalBroadcastManager.getInstance(context);
                    dispatch.putExtra(CONEXTPUSH_ACTION_TYPE,true);
                    manager.sendBroadcast(dispatch);

                } else if (error instanceof TimeoutError) {
                    //So, the flag "pending context sync" is still on, hence  proceed
                    String networkError = "No internet Access, Check your internet connection.";
                    FoveaLog.v(TAG, "ErrorResponse: " + networkError);

                } else {
                    FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    responseErrorListener.onFoveaErrorResponse(error);
                }
            }
        }) {
            @Override
            public String getBodyContentType() {
                return "application/json";
            }

        };
        // Schedule the request on the queue
        this.processRequest(authorizationRequest);
    }
}


