package com.cogknit.fovea.remote;

import android.content.Context;
import android.content.SharedPreferences;

import com.cogknit.fovea.FoveaSharedPreferences;

/**
 * Created by Maithri V M on 25/08/15.
 */


public class APIConstants{
    public static String DefaultFoveaID = "default";
    private static final String CONFIG_URL = "http://52.20.199.110:8080/mdm/api/v1/clientConfig";
    private static String BASE_URL = null;
    private static final String DEFAULT_BASE_URL = "https://fovea.cogknit.com:8443/mdm/api/v1/";
    public static final String URL_AUTHORIZATION = "authorizeSDK";
    public static final String URL_USERPROFILE = "customerProfile";
    public static final String URL_APPSCONTEXT =  "apps";
    public static final String URL_PEOPLECONTEXT =  "people";
    public static final String URL_SMSCONTEXT =  "textMessages";
    public static final String URL_HISTORYCONTEXT = "browserHistory";
    public static final String URL_LOCATIONCONTEXT = "locations";
    public static final String URL_FB_ME = "fbprofile";
    public static final String URL_FB_LIKES = "fblikes";
    public static final String URL_FB_FRIENDS = "fbpeople";
    public static final String URL_APPINVITES_STATUS = "appInviteStatus";
    public static final String URL_INFLUENCE_GRAPH = "influenceGraph";

    public static int AUTHE_ERROR_CODE = 401;

    public static void initializeWithDefaultAPIBaserURL(Context context)
    {
        BASE_URL = DEFAULT_BASE_URL;

        SharedPreferences settings = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        settings.edit().putString(FoveaSharedPreferences.UserProfile.API_CLIENT_URL, BASE_URL).commit();

    }
    public static String getAPIClientURL(Context context)
    {
        if (BASE_URL == null)
        {
            SharedPreferences settings = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
            BASE_URL = settings.getString(FoveaSharedPreferences.UserProfile.API_CLIENT_URL, null);
        }
        return BASE_URL;
    }

    /*public static void setAPIClientURL(Context context, String APIClientURL)
    {
        SharedPreferences settings = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        settings.edit().putString(FoveaSharedPreferences.UserProfile.API_CLIENT_URL, APIClientURL).commit();

        BASE_URL = APIClientURL;
    }*/
}
