package com.cogknit.fovea.receivers;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;

import com.cogknit.fovea.services.LegacyAppUsageService;
import com.cogknit.fovea.utils.SchedulerConstants;


/**
 * BroadcastReceiver to receive screen on/off events.<br>
 * Starts polling for apps when screen comes on and stops the polling when the
 * screen is off.
 * 
 * @author Chirag
 * 
 */
public class ScreenEventReceiver extends WakefulBroadcastReceiver {
	public static final String TAG = "ScreenEventReceiver";

	@Override
	public void onReceive(Context context, Intent intent) {

		AlarmManager alarmMgr = (AlarmManager) context
				.getSystemService(Context.ALARM_SERVICE);
		Intent iAlarm = new Intent(context, AlarmReceiver.class);
		iAlarm.setAction(SchedulerConstants.AlarmActions.ACTION_APP_FETCH);
		PendingIntent alarmIntent = PendingIntent.getBroadcast(context, 0,
				iAlarm, 0);
		if (intent.getAction().equals(Intent.ACTION_SCREEN_ON)) {

			if (Build.VERSION.SDK_INT < 21) {
				alarmMgr.setRepeating(AlarmManager.ELAPSED_REALTIME, 0,
						LegacyAppUsageService.INTERVAL, alarmIntent);
			}
		} else if (intent.getAction().equals(Intent.ACTION_SCREEN_OFF)) {

			if (Build.VERSION.SDK_INT < 21) {

				alarmMgr.cancel(alarmIntent);
			}
		}

	}

}
