package com.cogknit.fovea.receivers;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v4.content.WakefulBroadcastReceiver;

import com.cogknit.fovea.Fovea;
import com.cogknit.fovea.FoveaCallback;
import com.cogknit.fovea.FoveaConstants;
import com.cogknit.fovea.FoveaSharedPreferences;
import com.cogknit.fovea.remote.FoveaRequestResponseManager;
import com.cogknit.fovea.services.FoveaSyncService;
import com.cogknit.fovea.utils.FoveaLog;
import com.cogknit.fovea.utils.SchedulerConstants;

import java.util.ArrayList;

/**
 * Created by Maithri V M on 14/09/15.
 */
public class RefreshTokenReceiver extends WakefulBroadcastReceiver {
    public static final String TAG = RefreshTokenReceiver.class.getSimpleName();

    @Override
    public void onReceive(final Context context, final Intent intent) {

        String action = intent.getAction();
        FoveaLog.v(TAG, "RefreshTokenReceiver onReceive: " + action);

        Intent sIntent;
        SharedPreferences settings = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        String appkey = settings.getString(FoveaSharedPreferences.UserProfile.AppKey, "");
        String clientKey = settings.getString(FoveaSharedPreferences.UserProfile.ClientKey, "");

        if (intent.getAction() == FoveaRequestResponseManager.REFRESHTOKEN_ACTION_TAG)
        {
            Fovea.initialize(context,appkey, clientKey, getActiveServices(context),new FoveaCallback() {
                @Override
                public void onCompletion() {
                    //if (intent.getType() == FoveaRequestResponseManager.CONEXTPUSH_ACTION_TYPE) {
                    if (intent.getBooleanExtra(FoveaRequestResponseManager.CONEXTPUSH_ACTION_TYPE,false)){
                        Intent intent1 = new Intent(context, FoveaSyncService.class);
                        intent1.setAction(SchedulerConstants.AlarmActions.ACTION_REMOTE_PUSH);
                        context.startService(intent1);
                    }
                }

                @Override
                public void onFailure(Exception exception) {

                }
            });


        }

    }

    private FoveaConstants.Services[] getActiveServices(Context c){
        ArrayList<FoveaConstants.Services> list=new ArrayList<>();
        for(FoveaConstants.Services service : FoveaConstants.Services.values()){
            if(service.getStatus(c)){
                list.add(service);
            }
        }

        FoveaConstants.Services contexts[] = new FoveaConstants.Services[list.size()];
        contexts = list.toArray(contexts);
        return contexts;
    }
}
