package com.cogknit.fovea.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import com.cogknit.fovea.FoveaSharedPreferences;
import com.cogknit.fovea.providers.FoveaUserProfileManager;
import com.cogknit.fovea.services.FoveaSyncService;
import com.cogknit.fovea.utils.FoveaLog;
import com.cogknit.fovea.utils.SchedulerConstants;

/**
 * Created by Maithri V M on 04/09/15.
 */
public class ConnectionChangeReceiver extends BroadcastReceiver
{
    public static String SYNC_IF_NEEDED = "SyncIfNeeded";
    private static boolean firstConnect = true;

    @Override
    public void onReceive( Context context, Intent intent )
    {
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE );
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        boolean isConnected = (activeNetInfo != null) && activeNetInfo.isConnected();
        if (isConnected)
        {
            if(firstConnect)
            {
                // do subroutines here
                firstConnect = false;
                /*Intent dispatch = new Intent(SYNC_IF_NEEDED);
                LocalBroadcastManager manager = LocalBroadcastManager.getInstance(context);
                manager.sendBroadcast(dispatch);*/
                FoveaLog.v("Network event", "Network event changed");


                SharedPreferences settings = context.getSharedPreferences(
                        FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                boolean hasPendingUPSync = settings.getBoolean(FoveaSharedPreferences.UserProfile.hasPendingUPSync,false);
                if (hasPendingUPSync)
                {
                    FoveaUserProfileManager userProfileManager = new FoveaUserProfileManager();
                    userProfileManager.performUserProfileSynchronization(context);
                }
                boolean hasPendingContextSync = settings.getBoolean(FoveaSharedPreferences.UserProfile.hasPendingContextDataSync,false);
                if (hasPendingContextSync)
                {
                    Intent intent1 = new Intent(context,FoveaSyncService.class);
                    intent1.setAction(SchedulerConstants.AlarmActions.ACTION_REMOTE_PUSH);
                    context.startService(intent1);
                }
            }
        }
        else {
            firstConnect= true;

        }

    }
}
