package com.cogknit.fovea.receivers;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;

import com.cogknit.fovea.FoveaConstants;
import com.cogknit.fovea.FoveaSharedPreferences;
import com.cogknit.fovea.services.LegacyAppUsageService;
import com.cogknit.fovea.utils.FoveaLog;
import com.cogknit.fovea.utils.SchedulerConstants;

import java.util.AbstractList;
import java.util.Calendar;


/**
 * BroadcastReceiver to receive the Boot Complete event. Starts background
 * services and schedules recurring operations.
 *
 * @author Chirag
 */
public class BootEventReceiver extends WakefulBroadcastReceiver {
    private static final String TAG = "BOOT";
private static final int DeviceDetailsAlarmReqCode = 9000;
    @Override
    public void onReceive(Context context, Intent intent) {
        FoveaLog.v(TAG, "BootScheduleReceiver: Device booted, scheduling..");

        if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {
            bootInit(context);
        }

    }

    public static void bootInit(Context context) {

        SharedPreferences prefs = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, 0);
        FoveaLog.v(TAG, "Setting Alarms..");
        PendingIntent alarmIntent;
        AlarmManager alarmMgr = (AlarmManager) context
                .getSystemService(Context.ALARM_SERVICE);
        Intent iAlarm = new Intent(context, AlarmReceiver.class);

        // Schedule device details sync
        SharedPreferences settings = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        boolean hasSyncedDeviceDetails = settings.getBoolean(FoveaSharedPreferences.UserProfile.hasSyncedDeviceUserDetails, false);
        //Upon successful submission, disarm the alarm
        if (!hasSyncedDeviceDetails)
        {
            FoveaLog.v(TAG, "Setting Alarms..ACTION_DEVICE_USER_SYNC");

            iAlarm.setAction(SchedulerConstants.AlarmActions.ACTION_DEVICE_USER_SYNC);
            alarmIntent = PendingIntent.getBroadcast(context, DeviceDetailsAlarmReqCode, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
            alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 1000, AlarmManager.INTERVAL_HALF_DAY, alarmIntent);
        }

        // Schedule History, CallLogs and SMS Components
        // People
        if (prefs.getBoolean(SchedulerConstants.MiningContexts.PEOPLE_CONTEXT, false)) {
            //schedule call logs fetch
            iAlarm.setAction(SchedulerConstants.LocalFetch.ACTION_CALLLOGS);
            if(PendingIntent.getBroadcast(context, 1000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 1000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 1000, AlarmManager.INTERVAL_DAY, alarmIntent);

            }

            iAlarm.setAction(SchedulerConstants.LocalFetch.ACTION_PEOPLE);
            if(PendingIntent.getBroadcast(context, 10000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 10000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 20000,
                        AlarmManager.INTERVAL_DAY * 7, alarmIntent);
            }

        }

        // History
        if (prefs.getBoolean(SchedulerConstants.MiningContexts.HISTORY_CONTEXT, false)) {
            iAlarm.setAction(SchedulerConstants.LocalFetch.ACTION_HISTORY);
            if(PendingIntent.getBroadcast(context, 2000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 2000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }

        }
        // Sms
        if (prefs.getBoolean(SchedulerConstants.MiningContexts.SMS_CONTEXT, false)) {
            iAlarm.setAction(SchedulerConstants.LocalFetch.ACTION_SMS);
            if(PendingIntent.getBroadcast(context, 3000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 3000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }

        }

        // Location
        if (prefs.getBoolean(SchedulerConstants.MiningContexts.LOCATIONS_CONTEXT, false)) {
            iAlarm.setAction(SchedulerConstants.AlarmActions.ACTION_LOCATION_TRACK);
            if(PendingIntent.getBroadcast(context, 4000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 4000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }

        }
        // Schedule random pushes over a period
        // Set the alarm to start after 2 minutes
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());

        iAlarm.setAction(SchedulerConstants.AlarmActions.ACTION_REMOTE_PUSH);
        if(PendingIntent.getBroadcast(context, 5000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
            alarmIntent = PendingIntent.getBroadcast(context, 5000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
            alarmMgr.setInexactRepeating(AlarmManager.RTC, calendar.getTimeInMillis() + 120000, AlarmManager.INTERVAL_DAY/2, alarmIntent);
        }

        // Schedule AppUsage Components
        if (prefs.getBoolean(SchedulerConstants.MiningContexts.APPS_CONTEXT, false)) {
            iAlarm.setAction(SchedulerConstants.AlarmActions.ACTION_APP_FETCH);
            if(PendingIntent.getBroadcast(context, 6000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {

                alarmIntent = PendingIntent.getBroadcast(context, 6000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                if (Build.VERSION.SDK_INT < 21) {

                    alarmMgr.setRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                            LegacyAppUsageService.INTERVAL, alarmIntent);
                } else {

                    alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                            AlarmManager.INTERVAL_DAY, alarmIntent);
                }
            }
        }

        //Schedule FB Mining
        if (prefs.getBoolean(FoveaConstants.Services.FB.name(), false)) {
            //Set Friends Mining Alarm
            iAlarm.setAction(SchedulerConstants.FacebookSync.ACTION_FB_FRIENDS);
            if(PendingIntent.getBroadcast(context, 30000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 30000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }


            //Set Likes Mining Alarm
            iAlarm.setAction(SchedulerConstants.FacebookSync.ACTION_FB_LIKES);
            if(PendingIntent.getBroadcast(context, 7000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 7000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 30000,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }


            //Set ME Mining Alarm
            iAlarm.setAction(SchedulerConstants.FacebookSync.ACTION_FB_ME);
            if(PendingIntent.getBroadcast(context, 8000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 8000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 30000,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }

        }

    }


    /**
     * Method to initialize alarms and start background services on boot. Also
     * used the first time the application is installed
     *
     * @param context
     */
    /*public static void bootInit(Context context) {

        SharedPreferences prefs = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, 0);
        FoveaLog.v(TAG, "Setting Alarms..");
        PendingIntent alarmIntent;
        AlarmManager alarmMgr = (AlarmManager) context
                .getSystemService(Context.ALARM_SERVICE);
        Intent iAlarm = new Intent(context, AlarmReceiver.class);

        // Schedule device details sync
        iAlarm.setAction(SchedulerConstants.AlarmActions.ACTION_DEVICE_USER_SYNC);
        if(PendingIntent.getBroadcast(context, DeviceDetailsAlarmReqCode, iAlarm, PendingIntent.FLAG_NO_CREATE) == null){
            FoveaLog.v(TAG, "Setting Alarms..ACTION_DEVICE_USER_SYNC");

            alarmIntent = PendingIntent.getBroadcast(context, DeviceDetailsAlarmReqCode, iAlarm, PendingIntent. FLAG_UPDATE_CURRENT);
            alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 1000, 2000, alarmIntent);
        }

        // Schedule History, CallLogs and SMS Components
        // People
        if (prefs.getBoolean(FoveaConstants.Services.PEOPLE.name(), false)) {
            iAlarm.setAction(SchedulerConstants.LocalFetch.ACTION_PEOPLE);
            if(PendingIntent.getBroadcast(context, 0, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 0, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 1000,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }
        }

        // History
        if (prefs.getBoolean(FoveaConstants.Services.HISTORY.name(), false)) {
            iAlarm.setAction(SchedulerConstants.LocalFetch.ACTION_HISTORY);
            if(PendingIntent.getBroadcast(context, 2000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 2000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }
        }
        // Sms
        if (prefs.getBoolean(FoveaConstants.Services.SMS.name(), false)) {
            iAlarm.setAction(SchedulerConstants.LocalFetch.ACTION_SMS);
            if(PendingIntent.getBroadcast(context, 3000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 3000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }
        }

        // Location
        if (prefs.getBoolean(FoveaConstants.Services.LOCATION.name(), false)) {
            iAlarm.setAction(SchedulerConstants.AlarmActions.ACTION_LOCATION_TRACK);
            if(PendingIntent.getBroadcast(context, 4000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 4000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }
        }
        // Schedule random pushes over a period
        iAlarm.setAction(SchedulerConstants.AlarmActions.ACTION_REMOTE_PUSH);
        if(PendingIntent.getBroadcast(context, 5000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
            alarmIntent = PendingIntent.getBroadcast(context, 5000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
            alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 1000, 1000, alarmIntent);
            //alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 1000, AlarmManager.INTERVAL_DAY/2, alarmIntent);
        }

        // Schedule AppUsage Components
        if (prefs.getBoolean(FoveaConstants.Services.APPS.name(), false)) {
            iAlarm.setAction(SchedulerConstants.AlarmActions.ACTION_APP_FETCH);
            alarmIntent = PendingIntent.getBroadcast(context, 0, iAlarm, PendingIntent. FLAG_UPDATE_CURRENT);
            if (Build.VERSION.SDK_INT < 21) {

                alarmMgr.setRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                        LegacyAppUsageService.INTERVAL, alarmIntent);
            } else {

                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                        AlarmManager.INTERVAL_DAY, alarmIntent);
            }
        }

        //Schedule FB Mining
        if (prefs.getBoolean(FoveaConstants.Services.FB.name(), false)) {
            //Set Friends Mining Alarm
            iAlarm.setAction(SchedulerConstants.FacebookSync.ACTION_FB_FRIENDS);
            if(PendingIntent.getBroadcast(context, 30000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 30000, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0,
                        60000, alarmIntent);
            }

            //Set Likes Mining Alarm
            iAlarm.setAction(SchedulerConstants.FacebookSync.ACTION_FB_LIKES);
            if(PendingIntent.getBroadcast(context, 0, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 0, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 30000,
                        60000, alarmIntent);
            }

            //Set ME Mining Alarm
            iAlarm.setAction(SchedulerConstants.FacebookSync.ACTION_FB_ME);
            if(PendingIntent.getBroadcast(context, 0, iAlarm, PendingIntent.FLAG_NO_CREATE) == null) {
                alarmIntent = PendingIntent.getBroadcast(context, 0, iAlarm, PendingIntent.FLAG_UPDATE_CURRENT);
                alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 30000,
                        60000, alarmIntent);
            }
        }

        // Schedule config sync once in a week
        //Commenting this out, as configuration management is descoped in this version
        /*iAlarm.setAction(SchedulerConstants.AlarmActions.ACTION_CONFIG_SYNC);
        if(PendingIntent.getBroadcast(context, 7000, iAlarm, PendingIntent.FLAG_NO_CREATE) == null){
            alarmIntent = PendingIntent.getBroadcast(context, 7000, iAlarm, PendingIntent. FLAG_UPDATE_CURRENT);
            alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, AlarmManager.INTERVAL_HOUR, AlarmManager.INTERVAL_DAY*7, alarmIntent);
            //alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME, 0, 1000, alarmIntent);

        }*/

   // }*/


    public static void initialize(Context context) {

        SharedPreferences settings = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, 0);

        if (settings.getBoolean("my_first_time", true)) {
            // the app is being launched for first time, do something
            //FoveaLog.d(TAG, "First time");
            // record the fact that the app has been started at least once
            settings.edit().putBoolean("my_first_time", false).commit();
        }
        //Moving this outside the condition, upon every call it updates the existing intent if needed and schedules accordingly.
        // This helps varied level of conditional service invocations upon successive launch / app updates events
        BootEventReceiver.bootInit(context);


        if (Build.VERSION.SDK_INT < 21) {
            IntentFilter filter = new IntentFilter(Intent.ACTION_SCREEN_ON);
            filter.addAction(Intent.ACTION_SCREEN_OFF);
            BroadcastReceiver mReceiver = new ScreenEventReceiver();
            context.registerReceiver(mReceiver, filter);
        }
    }

    public static void disarmAlarm(Context context, String action){

        Intent intent = new Intent(context, AlarmReceiver.class);
        intent.setAction(action);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(context, DeviceDetailsAlarmReqCode, intent, 0);
        if(pendingIntent != null){
            FoveaLog.v(TAG, "Removing Alarms..ACTION_DEVICE_USER_SYNC");
            AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
            alarmManager.cancel(pendingIntent);
        }




    }
}
