package com.cogknit.fovea.receivers;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;

import com.cogknit.fovea.services.FacebookVolleySyncService;
import com.cogknit.fovea.services.FoveaSyncService;
import com.cogknit.fovea.services.LegacyAppUsageService;
import com.cogknit.fovea.services.LocalDataFetchService;
import com.cogknit.fovea.services.LocationController;
import com.cogknit.fovea.services.ScanAppUsageService;
import com.cogknit.fovea.utils.FoveaLog;
import com.cogknit.fovea.utils.SchedulerConstants;

//import com.cogknit.fovea.utils.GoGlocalSharedPreferences;

/**
 * BroadcastReceiver to handle scheduled alarm triggered events. Starts services
 * in response to alarms.
 *
 * @author Chirag
 */
public class AlarmReceiver extends WakefulBroadcastReceiver {
    public static final String TAG = "AlarmReceiver";

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        Intent sIntent;

        FoveaLog.v(TAG, "Alarm: " + action);
        switch (action) {
            case SchedulerConstants.LocalFetch.ACTION_PEOPLE:
            case SchedulerConstants.LocalFetch.ACTION_HISTORY:
            case SchedulerConstants.LocalFetch.ACTION_SMS:
            case SchedulerConstants.LocalFetch.ACTION_CALLLOGS:
                intent.setClass(context, LocalDataFetchService.class);
                startWakefulService(context, intent);
                break;
            case SchedulerConstants.AlarmActions.ACTION_APP_FETCH:
                if (Build.VERSION.SDK_INT < 21)
                    sIntent = new Intent(context, LegacyAppUsageService.class);
                else sIntent = new Intent(context, ScanAppUsageService.class);
                startWakefulService(context, sIntent);
                break;
            case SchedulerConstants.AlarmActions.ACTION_REMOTE_PUSH:
                intent.setClass(context, FoveaSyncService.class);
                startWakefulService(context, intent);
                break;
            case SchedulerConstants.AlarmActions.ACTION_LOCATION_TRACK:
                context.startService(new Intent(context, LocationController.class));
                break;
            case SchedulerConstants.FacebookSync.ACTION_FB_FRIENDS:
            case SchedulerConstants.FacebookSync.ACTION_FB_ME:
            case SchedulerConstants.FacebookSync.ACTION_FB_LIKES:
                intent.setClass(context, FacebookVolleySyncService.class);
                startWakefulService(context, intent);
                break;
            /*case SchedulerConstants.AlarmActions.ACTION_CONFIG_SYNC:
                intent.setClass(context, FoveaSyncService.class);
                startWakefulService(context, intent);
                break;*/
            case SchedulerConstants.AlarmActions.ACTION_DEVICE_USER_SYNC:
                intent.setClass(context, FoveaSyncService.class);
                startWakefulService(context, intent);
                break;
        }


    }

}
