package com.cogknit.fovea.providers;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;

import com.cogknit.fovea.FoveaConstants;
import com.cogknit.fovea.FoveaSharedPreferences;
import com.cogknit.fovea.FoveaUserProfile;
import com.cogknit.fovea.dataModel.UserProfile;
import com.cogknit.fovea.remote.APIConstants;
import com.cogknit.fovea.remote.FoveaRequestResponseManager;
import com.cogknit.fovea.remote.FoveaResponse;
/**
 * Created by Maithri V M on 02/09/15.
 */
public class FoveaUserProfileManager {

    public void setUserProfile(FoveaUserProfile userProfile, Context context){

        SharedPreferences settings = context.getSharedPreferences(
                FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        Boolean hasAuthenticated = settings.getBoolean(FoveaSharedPreferences.UserProfile.isSDKAuthorized, false);

        Uri mUri = FoveaContract.UserProfile.CONTENT_USERPROFILE_URI;

        /*if (hasAuthenticated) {

            String userID = settings.getString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, "");


                String selection = FoveaContract.UserProfile.Columns.FOVEA_USERID + "="
                        +"\""+userID+"\"";
                Cursor c = FoveaDatabaseManager.query(context, mUri, null, selection, null, null);
                int recordCount =  c.getCount();
                UserProfile newUserProfile;
                if(recordCount > 0)
                {
                    //(user profile record already present, consider it as an update request)
                    newUserProfile = new UserProfile(userProfile,userID);
                    FoveaDatabaseManager.update(context, mUri, newUserProfile.getContentValues(), selection, null);

                }
                else //else (user profiles details are being set for the first time, hence consider it as insert)
                {
                    //if prior blank records are present, without fovea user ID, just discard it
                    //String selections = FoveaContract.UserProfile.Columns.FOVEA_USERID + "="+"\""+APIConstants.DefaultFoveaID+"\"";
                    Cursor cursor = FoveaDatabaseManager.query(context, mUri, null, null, null, null);
                    if(cursor.getCount() > 0)
                    {
                        FoveaDatabaseManager.delete(context, mUri,null,null);
                    }
                    cursor.close();

                    //Insert new record with newly provided details
                    newUserProfile = new UserProfile(userProfile,userID);
                    FoveaDatabaseManager.insert(context, mUri, newUserProfile.getContentValues());
                }
            settings.edit().putBoolean(FoveaSharedPreferences.UserProfile.hasPendingUPSync,true).commit();

            performUserProfileSynchronization(context);
                c.close();
        }
        else*/
        {

            //Save the input user profile data in database and await synchronization
            UserProfile newUserProfile = new UserProfile(userProfile,APIConstants.DefaultFoveaID);
            //if prior blank records are present, discard it
            //String selections = FoveaContract.UserProfile.Columns.FOVEA_USERID + "=" +"\""+APIConstants.DefaultFoveaID+"\"";
            //Purge existing user profile records and insert new one
            Cursor cursor = FoveaDatabaseManager.query(context, mUri, null, null, null, null);
            if(cursor.getCount() > 0)
            {
                FoveaDatabaseManager.delete(context, mUri,null,null);
            }
            cursor.close();
            FoveaDatabaseManager.insert(context, mUri, newUserProfile.getContentValues());


            settings.edit().putBoolean(FoveaSharedPreferences.UserProfile.hasPendingUPSync,true).commit();

        }
        if (hasAuthenticated)
        {
            performUserProfileSynchronization(context);
        }

    }

    public void performUserProfileSynchronization(final Context context)
    {

        final Uri mUri = FoveaContract.UserProfile.CONTENT_USERPROFILE_URI;
        Cursor c = FoveaDatabaseManager.query(context, mUri, null, null, null, null);
        int recordCount =  c.getCount();

        FoveaUserProfile fup = null; String fovUserID = null;
        while (c.moveToNext())
        {

                //User profile

                String name = c
                        .getString(c
                                .getColumnIndex(FoveaContract.UserProfile.Columns.NAME));
                String email = c
                        .getString(c
                                .getColumnIndex(FoveaContract.UserProfile.Columns.EMAIL_ID));
                String uniqueID = c
                        .getString(c
                                .getColumnIndex(FoveaContract.UserProfile.Columns.UNIQUE_BIZ_USERID));
                String phoneNumber = c
                        .getString(c
                                .getColumnIndex(FoveaContract.UserProfile.Columns.PHONE_NUMBER));
                String dob = c
                        .getString(c
                                .getColumnIndex(FoveaContract.UserProfile.Columns.DOB));
                int gender = c
                        .getInt(c
                                .getColumnIndex(FoveaContract.UserProfile.Columns.GENDER));
                fovUserID = c
                        .getString(c
                                .getColumnIndex(FoveaContract.UserProfile.Columns.FOVEA_USERID));

                fup = new FoveaUserProfile(uniqueID);
                fup.setUserName(name);
                fup.setEmailID(email);
                fup.setPhoneNumber(phoneNumber);
                fup.setDateOfBirth(dob);
                FoveaConstants.Gender genderEnum = FoveaConstants.Gender.values()[gender];
                fup.setGender(genderEnum);

            break;
        }
        c.close();
        if ((fup != null) && (fovUserID != null))
        {
            uploadUserProfileData(fup, fovUserID, context);
        }

    }

    void uploadUserProfileData(final FoveaUserProfile fup, final String fovUserID, final Context context)
    {
        UserProfile userProfile = new UserProfile(fup,fovUserID);

        FoveaRequestResponseManager manager = new FoveaRequestResponseManager(context);

        //final Uri mUri = FoveaContract.UserProfile.CONTENT_USERPROFILE_URI;

        manager.submitUserProfile(userProfile, new FoveaResponse.FoveaResponseListener() {
                    @Override
                    public void onSuccessResponse() {
                        {
                            SharedPreferences settings = context.getSharedPreferences(
                                    FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                            /*String foveaUserID = response.toString();
                            //1. Check if system returned new Fovea User ID, if yes update the table
                            if (fovUserID.equalsIgnoreCase(foveaUserID) == false) {
                                UserProfile updatedUserProfile = new UserProfile(fup, foveaUserID);
                                FoveaDatabaseManager.update(context, mUri, updatedUserProfile.getContentValues(), null, null);

                                //Udpate the shared preferences too
                                settings.edit().putString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, foveaUserID).commit();

                            }*/
                            //2. Update the shared preferences too
                            settings.edit().putBoolean(FoveaSharedPreferences.UserProfile.hasPendingUPSync, false).commit();

                        }
                    }
                },
                new FoveaResponse.FoveaErrorListener() {
                    @Override
                    public void onFoveaErrorResponse(Exception error) {

                    }
                });
    }

    /*public static String getLoggedInBizUserID(Context context) {
        final Uri mUri = FoveaContract.UserProfile.CONTENT_USERPROFILE_URI;
        Cursor c = FoveaDatabaseManager.query(context, mUri, null, null, null, null);
        int recordCount = c.getCount();
        String uniqueUserID = null;
        while (c.moveToNext())
        {
            uniqueUserID = c
                    .getString(c
                            .getColumnIndex(FoveaContract.UserProfile.Columns.UNIQUE_BIZ_USERID));
            break;
        }
        c.close();
        return uniqueUserID;
    }*/
}
