package com.cogknit.fovea.providers;

import android.content.Context;
import android.content.SharedPreferences;

import com.cogknit.fovea.FoveaSharedPreferences;
import com.cogknit.fovea.receivers.BootEventReceiver;
import com.cogknit.fovea.remote.APIConstants;
import com.cogknit.fovea.remote.FoveaRequestResponseManager;
import com.cogknit.fovea.remote.FoveaResponse;
import com.cogknit.fovea.utils.FoveaLog;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.cogknit.fovea.utils.SchedulerConstants;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

import org.json.JSONObject;

/**
 * Created by Maithri V M on 31/08/15.
 */
public class FoveaSynchronizationManager {
    private String TAG = "FoveaSynchronizationManager";

    static boolean first = true;

    public abstract interface FoveaCompletionListener {
        /**
         * Called on Job completion
         */
        public abstract void onCompletion();
    }

    public void performClientConfigSynchronization (final Context context) {
        SharedPreferences settings = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        String appkey = settings.getString(FoveaSharedPreferences.UserProfile.AppKey, "");
        FoveaLog.v(TAG, "Syncing client configuration..."+appkey);

        //Commenting this out, as configuration management is descoped in this version
        //Feed with the downloaded client API gateway URL
        //APIConstants.setAPIClientURL(context,BASE_URL);
        APIConstants.initializeWithDefaultAPIBaserURL(context);
    }

    /* Method to sync up the device userDetails */
    public void performDeviceDetailsSynchronization (final Context context) {
        FoveaLog.v(TAG, "Syncing the device user details");

        final FoveaRequestResponseManager reqManager = new FoveaRequestResponseManager(context);
        DeviceUserDetails deviceUserDetails = new DeviceUserDetails(context);
        List detailsList = new ArrayList();
        detailsList.add(deviceUserDetails);

        reqManager.sendDeviceUserDetailsRequest(detailsList,
                new FoveaResponse.FoveaResponseListener() {
                    @Override
                    public void onSuccessResponse() {
                        SharedPreferences settings = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                        settings.edit().putBoolean(FoveaSharedPreferences.UserProfile.hasSyncedDeviceUserDetails, true).commit();

                        //Upon successful submission, disarm the alarm
                        BootEventReceiver.disarmAlarm(context, SchedulerConstants.AlarmActions.ACTION_DEVICE_USER_SYNC);
                    }
                },
                new FoveaResponse.FoveaErrorListener() {
                    @Override
                    public void onFoveaErrorResponse(Exception error) {
                        FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    }
                });
    }

    public void performDataSynchronization(final Context context) {
        FoveaLog.v(TAG, "Syncing...");
        //Make sure database context is set (when woke up from the services)
        SharedPreferences settings = context.getSharedPreferences(
                FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);

        settings.edit().putBoolean(FoveaSharedPreferences.UserProfile.hasPendingContextDataSync, true).commit();

        final FoveaRequestResponseManager reqManager = new FoveaRequestResponseManager(context);

        //Submitting app data
        final FoveaDataFetchHelper dataHelper = new FoveaDataFetchHelper(context);

        final String userID = settings.getString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, "");

        syncAppContextData(reqManager, dataHelper, userID,
                new FoveaCompletionListener() {
                    @Override
                    public void onCompletion() {
                        syncPeopleContextData(reqManager, dataHelper, userID, new FoveaCompletionListener() {
                            @Override
                            public void onCompletion() {
                                syncAppInvitesData(reqManager, dataHelper, userID, new FoveaCompletionListener() {
                                    @Override
                                    public void onCompletion() {

                                        syncSMSContextData(reqManager, dataHelper, userID, new FoveaCompletionListener() {
                                            @Override
                                            public void onCompletion() {
                                                syncHistoryContextData(reqManager, dataHelper, userID, new FoveaCompletionListener() {
                                                    @Override
                                                    public void onCompletion() {
                                                        syncLocationContextData(reqManager, dataHelper, userID, new FoveaCompletionListener() {
                                                            @Override
                                                            public void onCompletion() {
                                                                FoveaLog.v(TAG, "Done for now");

                                                                //Update the status
                                                                SharedPreferences setting = context.getSharedPreferences(
                                                                        FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                                                                setting.edit().putBoolean(FoveaSharedPreferences.UserProfile.hasPendingContextDataSync, false).commit();
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }

                        });

                    }

                }
        );

    }

    void syncAppContextData(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List apps = dataHelper.getAppsData(forUserID);
        if (apps.isEmpty()) {
            FoveaLog.v(TAG, "No app records to send out");
            listener.onCompletion();
            return;
        }
        String url = APIConstants.URL_APPSCONTEXT;

        reqManager.submitContextData(url, apps,
                new FoveaResponse.FoveaResponseListener() {
                    @Override
                    public void onSuccessResponse() {
                        dataHelper.purgeAppsData(forUserID);
                        listener.onCompletion();
                    }
                },
                new FoveaResponse.FoveaErrorListener() {
                    @Override
                    public void onFoveaErrorResponse(Exception error) {
                        FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                        listener.onCompletion();
                    }
                });
    }

    void syncPeopleContextData(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List people = dataHelper.getPeopleData(forUserID);
        if (people.isEmpty()) {
            FoveaLog.v(TAG, "No people records to send out");
            listener.onCompletion();
            return;
        }
        String url = APIConstants.URL_PEOPLECONTEXT;

        reqManager.submitContextData(url, people,
                new FoveaResponse.FoveaResponseListener() {
                    @Override
                    public void onSuccessResponse() {

                        dataHelper.purgePeopleData(forUserID);
                        listener.onCompletion();
                    }
                },
                new FoveaResponse.FoveaErrorListener() {
                    @Override
                    public void onFoveaErrorResponse(Exception error) {
                        FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                        listener.onCompletion();
                    }
                });
    }

    void syncSMSContextData(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List people = dataHelper.getSmsData(forUserID);
        if (people.isEmpty()) {
            FoveaLog.v(TAG, "No SMS records to send out");
            listener.onCompletion();
            return;
        }
        String url = APIConstants.URL_SMSCONTEXT;

        reqManager.submitContextData(url, people,
                new FoveaResponse.FoveaResponseListener() {
                    @Override
                    public void onSuccessResponse() {

                        dataHelper.purgeSmsData(forUserID);
                        listener.onCompletion();
                    }
                },
                new FoveaResponse.FoveaErrorListener() {
                    @Override
                    public void onFoveaErrorResponse(Exception error) {
                        FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                        listener.onCompletion();
                    }
                });
    }

    void syncHistoryContextData(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List people = dataHelper.getHistoryData(forUserID);
        if (people.isEmpty()) {
            FoveaLog.v(TAG, "No History records to send out");
            listener.onCompletion();
            return;
        }
        String url = APIConstants.URL_HISTORYCONTEXT;

        reqManager.submitContextData(url, people,
                new FoveaResponse.FoveaResponseListener() {
                    @Override
                    public void onSuccessResponse() {

                        dataHelper.purgeHistoryData(forUserID);
                        listener.onCompletion();
                    }
                },
                new FoveaResponse.FoveaErrorListener() {
                    @Override
                    public void onFoveaErrorResponse(Exception error) {
                        FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                        listener.onCompletion();
                    }
                });
    }

    void syncLocationContextData(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List userLocations = dataHelper.getLocationsData(forUserID);
        if (userLocations.isEmpty()) {
            FoveaLog.v(TAG, "No Location records to send out");
            listener.onCompletion();
            return;
        }
        String url = APIConstants.URL_LOCATIONCONTEXT;

        reqManager.submitContextData(url, userLocations,
                new FoveaResponse.FoveaResponseListener() {
                    @Override
                    public void onSuccessResponse() {

                        dataHelper.purgeLocationsData(forUserID);

                        listener.onCompletion();
                    }
                },
                new FoveaResponse.FoveaErrorListener() {
                    @Override
                    public void onFoveaErrorResponse(Exception error) {
                        FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                        listener.onCompletion();
                    }
                });
    }

    void syncAppInvitesData(final FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener){

        //1. Sync up the status of the past invites
        List<AppInvite> invites = dataHelper.getAppInvitesPendingSubmission(forUserID);
        if (invites.isEmpty() != true)
        {
            String url = APIConstants.URL_APPINVITES_STATUS;

            reqManager.submitInvitesContextData(url, invites,
                    new FoveaResponse.FoveaResponseListener() {
                        @Override
                        public void onSuccessResponse() {
                            //3. Download fresh list for the influence graph
                            syncInfluenceGraph(reqManager, dataHelper, forUserID, new FoveaCompletionListener() {
                                @Override
                                public void onCompletion() {
                                    listener.onCompletion();
                                }
                            });
                        }
                    },
                    new FoveaResponse.FoveaErrorListener() {
                        @Override
                        public void onFoveaErrorResponse(Exception error) {
                            FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                            listener.onCompletion();
                        }
                    });

        }
        else {
            FoveaLog.v(TAG, "No Appinvitation records to send out");

            syncInfluenceGraph(reqManager, dataHelper, forUserID, new FoveaCompletionListener() {
                @Override
                public void onCompletion() {
                    listener.onCompletion();
                }
            });
        }
    }

    void syncInfluenceGraph(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener){

        //1. Clear all the existing records
        dataHelper.purgeAppInvitesData(forUserID);

        //2. Send request for new record set
        reqManager.getInfluenceGraphRequest(
                new FoveaResponse.FoveaDataResponseListener() {
                    @Override
                    public void onSuccessResponse(Object response) {

                        String responseString = (String)response;
                        Type listType = new TypeToken<List<AppInvite>>() {
                        }.getType();
                        List<AppInvite> results = new Gson().fromJson(responseString, listType);

                        //1. Save it in database
                        dataHelper.saveInfluenceGraph(results);

                        //2. Completion
                        listener.onCompletion();
                    }
                },
                new FoveaResponse.FoveaErrorListener() {
                    @Override
                    public void onFoveaErrorResponse(Exception error) {
                        FoveaLog.v(TAG, "ErrorResponse: " + error.getLocalizedMessage());
                        listener.onCompletion();
                    }
                });
    }

    /*{
            String response = getInfluenceGraphResponse();
            Type listType = new TypeToken<List<AppInvite>>() {
            }.getType();
            List<AppInvite> results = new Gson().fromJson(response, listType);
            dataHelper.saveInfluenceGraph(results);
            first = false;
         }*/

    /*
    String getInfluenceGraphResponse(){
        List<AppInvite> results = getSampleGraphData();

        GsonBuilder builder = new GsonBuilder();
        Gson mapGson = builder.create();
        String graphJSON = mapGson.toJson(results);
        return graphJSON;
    }

    List<AppInvite> getSampleGraphData()
    {
        List<AppInvite> graph = new ArrayList<AppInvite>();

        AppInvite invite = new AppInvite("My3","My3@com","7760863072", 1, AppInvite.InviteStatus.NoEvent);
        AppInvite invite1 = new AppInvite("Unknown","Unknown@com","22222", 2, AppInvite.InviteStatus.NoEvent);
        AppInvite invite2 = new AppInvite("CH3","CH3@com","33333", 3, AppInvite.InviteStatus.NoEvent);
        AppInvite invite3 = new AppInvite("My3","My3@com","44444", 4, AppInvite.InviteStatus.NoEvent);
        AppInvite invite4 = new AppInvite("Maithri","Maithri@com","55555", 5, AppInvite.InviteStatus.NoEvent);
        AppInvite invite5 = new AppInvite("M3","M3@com","6666666", 6, AppInvite.InviteStatus.NoEvent);
        AppInvite invite6 = new AppInvite("Prasanna","Prasanna@com","9880944660", 7, AppInvite.InviteStatus.NoEvent);
        AppInvite invite7 = new AppInvite("Pras","Pras@com","888888", 8, AppInvite.InviteStatus.NoEvent);
        AppInvite invite8 = new AppInvite("Prasssss","Prasssss@com","999999", 9, AppInvite.InviteStatus.NoEvent);
        AppInvite invite9 = new AppInvite("P3","P3@com","0000000", 10, AppInvite.InviteStatus.NoEvent);

        graph.add(invite);
        /*graph.add(invite6);
        graph.add(invite1);
        graph.add(invite2);
        graph.add(invite3);
        graph.add(invite4);
        graph.add(invite5);
        graph.add(invite7);
        graph.add(invite8);
        graph.add(invite9);*/

       // return graph;
   // }

}
