package com.cogknit.fovea.providers;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;

import com.cogknit.fovea.FoveaSharedPreferences;
import com.cogknit.fovea.utils.FoveaLog;

import java.util.ArrayList;

/**
 * Created by Maithri V M on 28/08/15.
 */
public class FoveaDatabaseManager {


    /**
     * The Fovea database name
     */
    private static final String dbName = "cogknit_fovea.db";
    /**
     * The Fovea database version
     */
    private static final int dbVersion = 1;

    private static SQLiteDatabase db;

    private static String TAG = "FoveaRequestResponseManager";

    /**
     * Constants for URI matcher
     */
    static final int PEOPLE = 1;
    static final int PERSON_ID = 2;
    static final int PEOPLE_FILTER = 3;
    static final int CALLS = 4;
    static final int CALL_ID = 5;
    static final int SMS = 6;
    static final int SMS_ID = 7;
    static final int HISTORY = 8;
    static final int HISTORY_ID = 9;
    static final int APP = 10;
    static final int APP_ID = 11;
    static final int LOCATIONS = 12;
    static final int LOCATION_ID = 14;
    static final int LIKES = 15;
    static final int LIKES_ID = 16;
    static final int USERPROFILE = 17;
    static final int APPINVITES = 18;
    /**
     * The UriMatcher object to resolve URI requests
     */
    static final UriMatcher uriMatcher;

    /** Static block for initializing the UriMatcher with the integer constants */
    static {
        uriMatcher = new UriMatcher(UriMatcher.NO_MATCH);

        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY, com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory,
                PEOPLE);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY, com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory
                + "/#", PERSON_ID);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY, com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory
                + "/*", PEOPLE_FILTER);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory, CALLS);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory + "/#", CALL_ID);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory, SMS);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory + "/#", SMS_ID);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.History.historyDirectory, HISTORY);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.History.historyDirectory + "/#", HISTORY_ID);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory, APP);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory + "/#", APP_ID);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory, LOCATIONS);
        uriMatcher
                .addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                        com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory + "/#",
                        LOCATION_ID);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory, LIKES);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory + "/#", LIKES_ID);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                FoveaContract.UserProfile.userProfileDirectory, USERPROFILE);
        uriMatcher.addURI(com.cogknit.fovea.providers.FoveaContract.AUTHORITY,
                FoveaContract.AppInvites.appInvitesDirectory, APPINVITES);

    }

    private static void initializeFoveaDatabase(Context context) {
        DatabaseHelper dbHelper = new DatabaseHelper(context);
        /**
         * Create a write able database which will trigger its creation if it
         * doesn't already exist.
         */
        db = dbHelper.getWritableDatabase();
    }

    /**
     * Helper class that actually creates and manages the GoGlocal Provider's
     * underlying data repository.
     *
     * @author Chirag
     */
    public static class DatabaseHelper extends SQLiteOpenHelper {
        public DatabaseHelper(Context context) {
            super(context, dbName, null, dbVersion);
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            db.execSQL(TableStructures.userProfile);
            db.execSQL(TableStructures.people);
            db.execSQL(TableStructures.appInvites);
            db.execSQL(TableStructures.calls);
            db.execSQL(TableStructures.sms);
            db.execSQL(TableStructures.history);
            db.execSQL(TableStructures.apps);
            db.execSQL(TableStructures.location);
            db.execSQL(TableStructures.likes);

        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE IF EXISTS "
                    + FoveaContract.UserProfile.userProfileDirectory);
            db.execSQL("DROP TABLE IF EXISTS "
                    + com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory);
            db.execSQL("DROP TABLE IF EXISTS " + com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory);
            db.execSQL("DROP TABLE IF EXISTS "
                    + com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory);
            db.execSQL("DROP TABLE IF EXISTS "
                    + com.cogknit.fovea.providers.FoveaContract.History.historyDirectory);
            db.execSQL("DROP TABLE IF EXISTS "
                    + com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory);
            db.execSQL("DROP TABLE IF EXISTS "
                    + com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory);
            onCreate(db);
            db.execSQL("DROP TABLE IF EXISTS "
                    + com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory);

            onCreate(db);
        }

        public ArrayList<Cursor> getData(String Query) {
            //get writable database
            SQLiteDatabase sqlDB = this.getWritableDatabase();
            String[] columns = new String[]{"mesage"};
            //an array list of cursor to save two cursors one has results from the query
            //other cursor stores error message if any errors are triggered
            ArrayList<Cursor> alc = new ArrayList<Cursor>(2);
            MatrixCursor Cursor2 = new MatrixCursor(columns);
            alc.add(null);
            alc.add(null);


            try {
                String maxQuery = Query;
                //execute the query results will be save in Cursor c
                Cursor c = sqlDB.rawQuery(maxQuery, null);


                //add value to cursor2
                Cursor2.addRow(new Object[]{"Success"});

                alc.set(1, Cursor2);
                if (null != c && c.getCount() > 0) {


                    alc.set(0, c);
                    c.moveToFirst();

                    return alc;
                }
                return alc;
            } catch (SQLException sqlEx) {
                FoveaLog.d("printing exception", sqlEx.getMessage());
                //if any exceptions are triggered save the error message to cursor an return the arraylist
                Cursor2.addRow(new Object[]{"" + sqlEx.getMessage()});
                alc.set(1, Cursor2);
                return alc;
            } catch (Exception ex) {

                FoveaLog.d("printing exception", ex.getMessage());

                //if any exceptions are triggered save the error message to cursor an return the arraylist
                Cursor2.addRow(new Object[]{"" + ex.getMessage()});
                alc.set(1, Cursor2);
                return alc;
            }


        }
    }

    /**
     * Holds the Create query strings (table structures) of the Database tables.
     *
     * @author Chirag
     */
    private static class TableStructures {

        /**
         * The create query for the Userprofile Table
         */
        public static final String userProfile = "create table if not exists "
                + FoveaContract.UserProfile.userProfileDirectory + "("
                + com.cogknit.fovea.providers.FoveaContract.UserProfile.Columns.ID
                + " INTEGER primary key AUTOINCREMENT,"
                + FoveaContract.UserProfile.Columns.UNIQUE_BIZ_USERID + " uniqueBizUserID,"
                + FoveaContract.UserProfile.Columns.EMAIL_ID + " TEXT,"
                + FoveaContract.UserProfile.Columns.PHONE_NUMBER + " TEXT,"
                + FoveaContract.UserProfile.Columns.DOB + " TEXT,"
                + FoveaContract.UserProfile.Columns.GENDER + " NUMBER,"
                + com.cogknit.fovea.providers.FoveaContract.UserProfile.Columns.TIMESTAMP + " NUMBER,"
                + com.cogknit.fovea.providers.FoveaContract.UserProfile.Columns.NAME
                + " TEXT," + FoveaContract.Calls.Columns.FOVEA_USERID + " TEXT not null)";

        /**
         * The create query for the CallLogs Table
         */
        public static final String calls = "create table if not exists "
                + com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory + "("
                + com.cogknit.fovea.providers.FoveaContract.Calls.Columns.ID
                + " INTEGER primary key AUTOINCREMENT,"
                + com.cogknit.fovea.providers.FoveaContract.Calls.Columns.DURATION + " NUMBER not null,"
                + com.cogknit.fovea.providers.FoveaContract.Calls.Columns.NUMBER + " TEXT not null,"
                + com.cogknit.fovea.providers.FoveaContract.Calls.Columns.CONTACT_URI + " TEXT,"
                + com.cogknit.fovea.providers.FoveaContract.Calls.Columns.TIMESTAMP
                + " NUMBER not null," + com.cogknit.fovea.providers.FoveaContract.Calls.Columns.NAME
                + " TEXT not null," + FoveaContract.Calls.Columns.FOVEA_USERID + " TEXT not null)";

        /**
         * The create query for the People Table
         */
        public static final String people = "create table if not exists "
                + com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory + "("
                + com.cogknit.fovea.providers.FoveaContract.People.Columns.ID
                + " INTEGER primary key AUTOINCREMENT,"
                + com.cogknit.fovea.providers.FoveaContract.People.Columns.DURATION
                + " NUMBER not null," + com.cogknit.fovea.providers.FoveaContract.People.Columns.NUMBER
                + " TEXT not null," + com.cogknit.fovea.providers.FoveaContract.People.Columns.TIMEFRAME
                + " TEXT not null,"
                + com.cogknit.fovea.providers.FoveaContract.People.Columns.CONTACT_URI + " TEXT,"
                + com.cogknit.fovea.providers.FoveaContract.People.Columns.FREQUENCY
                + " NUMBER not null," + FoveaContract.People.Columns.WEIGHT
                + " NUMBER not null," + com.cogknit.fovea.providers.FoveaContract.People.Columns.NAME
                + " TEXT not null," + FoveaContract.People.Columns.FOVEA_USERID + " TEXT not null)";

        /**
         * The create query for the SMS Table
         */
        public static final String sms = "create table if not exists "
                + com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory + "("
                + com.cogknit.fovea.providers.FoveaContract.Sms.Columns.ID
                + " INTEGER primary key AUTOINCREMENT,"
                + com.cogknit.fovea.providers.FoveaContract.Sms.Columns.NUMBER + " TEXT not null,"
                + com.cogknit.fovea.providers.FoveaContract.Sms.Columns.BODY + " TEXT,"
                + com.cogknit.fovea.providers.FoveaContract.Sms.Columns.TIMESTAMP + " NUMBER not null,"
                + FoveaContract.Sms.Columns.FOVEA_USERID + " TEXT not null);";

        /**
         * The create query for the HISTORY Table
         */
        public static final String history = "create table if not exists "
                + com.cogknit.fovea.providers.FoveaContract.History.historyDirectory + "("
                + com.cogknit.fovea.providers.FoveaContract.History.Columns.ID
                + " INTEGER primary key AUTOINCREMENT,"
                + com.cogknit.fovea.providers.FoveaContract.History.Columns.TITLE + " TEXT not null,"
                + com.cogknit.fovea.providers.FoveaContract.History.Columns.URL + " TEXT,"
                + com.cogknit.fovea.providers.FoveaContract.History.Columns.TIMESTAMP
                + " NUMBER not null,"
                + com.cogknit.fovea.providers.FoveaContract.History.Columns.BOOKMARK_FLAG
                + " INTEGER not null,"
                + FoveaContract.History.Columns.FOVEA_USERID + " TEXT not null);";

        /**
         * The create query for the AppLogs Table
         */
        public static final String apps = "create table if not exists "
                + com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory + "("
                + com.cogknit.fovea.providers.FoveaContract.Apps.Columns.ID
                + " INTEGER primary key AUTOINCREMENT,"
                + com.cogknit.fovea.providers.FoveaContract.Apps.Columns.NAME + " TEXT not null,"
                + com.cogknit.fovea.providers.FoveaContract.Apps.Columns.PACKAGE_NAME
                + " TEXT not null,"
                + com.cogknit.fovea.providers.FoveaContract.Apps.Columns.FOREGROUND_TIME
                + " NUMBER not null,"
                + FoveaContract.Apps.Columns.FOVEA_USERID + " TEXT not null)";
        /**
         * The create query for the LOCATIONS Table
         */
        public static final String location = "create table if not exists "
                + com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory + "("
                + com.cogknit.fovea.providers.FoveaContract.Location.Columns.ID
                + " INTEGER primary key AUTOINCREMENT,"
                + com.cogknit.fovea.providers.FoveaContract.Location.Columns.ACTIVITY
                + " INTEGER not null,"
                + com.cogknit.fovea.providers.FoveaContract.Location.Columns.LATITUDE
                + " NUMBER not null,"
                + com.cogknit.fovea.providers.FoveaContract.Location.Columns.LONGITUDE
                + " NUMBER not null,"
                + com.cogknit.fovea.providers.FoveaContract.Location.Columns.TIMESTAMP
                + " NUMBER not null,"
                + FoveaContract.Location.Columns.FOVEA_USERID + " TEXT not null);";

        /**
         * The create query for the Likes Table
         */
        public static final String likes = "create table if not exists "
                + com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory + "("
                + com.cogknit.fovea.providers.FoveaContract.Likes.Columns.ID
                + " INTEGER primary key AUTOINCREMENT,"
                + com.cogknit.fovea.providers.FoveaContract.Likes.Columns.FB_ID
                + " TEXT UNIQUE not null ,"
                + com.cogknit.fovea.providers.FoveaContract.Likes.Columns.NAME + " TEXT not null,"
                + com.cogknit.fovea.providers.FoveaContract.Likes.Columns.CATEGORY + " TEXT,"
                + com.cogknit.fovea.providers.FoveaContract.Likes.Columns.CATEGORY_OTHER + " TEXT,"
                + com.cogknit.fovea.providers.FoveaContract.Likes.Columns.TIMESTAMP
                + " NUMBER not null,"
                + FoveaContract.Likes.Columns.FOVEA_USERID + " TEXT not null);";

        /**
         * The create query for the App invites Table
         */
        public static final String appInvites = "create table if not exists "
                + FoveaContract.AppInvites.appInvitesDirectory + "("
                + com.cogknit.fovea.providers.FoveaContract.AppInvites.Columns.ID
                + " INTEGER primary key AUTOINCREMENT,"
                + FoveaContract.AppInvites.Columns.DEVICE_FAMILY
                + " NUMBER," + FoveaContract.AppInvites.Columns.INVITEE_PHONE
                + " TEXT not null," + FoveaContract.AppInvites.Columns.INVITEE_EMAIL
                + " TEXT,"
                + FoveaContract.AppInvites.Columns.INVITEE_WEIGHT
                + " NUMBER not null,"
                + FoveaContract.AppInvites.Columns.PLATFORM_ID
                + " NUMBER," + FoveaContract.AppInvites.Columns.INVITEE_NAME
                + " TEXT not null," + FoveaContract.AppInvites.Columns.INVITE_STATUS
                + " NUMBER not null," + FoveaContract.AppInvites.Columns.TIMESTAMP
                + " NUMBER," + FoveaContract.People.Columns.FOVEA_USERID + " TEXT not null)";
    }

    public static synchronized Cursor query(Context context, Uri uri, String[] projection,
                                            String selection, String[] selectionArgs, String sortOrder) {

        if (db == null) {
            initializeFoveaDatabase(context);
        }
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();

        switch (uriMatcher.match(uri)) {
            case USERPROFILE:
                qb.setTables(FoveaContract.UserProfile.userProfileDirectory);
                /** Sort by TIMESTAMP by default */
                if (sortOrder == null || sortOrder == "")
                    sortOrder = com.cogknit.fovea.providers.FoveaContract.UserProfile.Columns.TIMESTAMP + " DESC";
                break;
            case CALLS:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory);
                /** Sort by TIMESTAMP by default */
                if (sortOrder == null || sortOrder == "")
                    sortOrder = com.cogknit.fovea.providers.FoveaContract.Calls.Columns.TIMESTAMP + " DESC";
                break;
            case CALL_ID:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory);
                qb.appendWhere(com.cogknit.fovea.providers.FoveaContract.Calls.Columns.ID + "="
                        + uri.getPathSegments().get(1));
                break;
            case PEOPLE:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory);
                if (sortOrder == null || sortOrder == "")
                    sortOrder = com.cogknit.fovea.providers.FoveaContract.People.Columns.TIMEFRAME;
                break;
            case PERSON_ID:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory);
                qb.appendWhere(com.cogknit.fovea.providers.FoveaContract.People.Columns.ID + "="
                        + uri.getPathSegments().get(1));
                break;
            case PEOPLE_FILTER:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory);
                String filter = "'" + uri.getLastPathSegment() + "'";
                qb.appendWhere(com.cogknit.fovea.providers.FoveaContract.People.Columns.TIMEFRAME + "="
                        + filter);
                break;
            case SMS:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory);
                /** Sort by TIMESTAMP by default */
                if (sortOrder == null || sortOrder == "")
                    sortOrder = com.cogknit.fovea.providers.FoveaContract.Sms.Columns.TIMESTAMP + " DESC";
                break;
            case SMS_ID:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory);
                qb.appendWhere(com.cogknit.fovea.providers.FoveaContract.Sms.Columns.ID + "="
                        + uri.getPathSegments().get(1));
                break;
            case HISTORY:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.History.historyDirectory);
                /** Sort by TIMESTAMP by default */
                if (sortOrder == null || sortOrder == "")
                    sortOrder = com.cogknit.fovea.providers.FoveaContract.History.Columns.TIMESTAMP
                            + " DESC";
                break;
            case HISTORY_ID:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.History.historyDirectory);
                qb.appendWhere(com.cogknit.fovea.providers.FoveaContract.History.Columns.ID + "="
                        + uri.getPathSegments().get(1));
                break;
            case APP:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory);
                /** Sort by FG and BG time by default */
                if (sortOrder == null || sortOrder == "")
                    sortOrder = com.cogknit.fovea.providers.FoveaContract.Apps.Columns.FOREGROUND_TIME
                            + " DESC";
                break;
            case APP_ID:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory);
                qb.appendWhere(com.cogknit.fovea.providers.FoveaContract.Apps.Columns.ID + "="
                        + uri.getPathSegments().get(1));
                break;
            case LOCATIONS:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory);
                /** Sort by TIMESTAMP by default */
                if (sortOrder == null || sortOrder == "")
                    sortOrder = com.cogknit.fovea.providers.FoveaContract.Location.Columns.TIMESTAMP
                            + " DESC";
                break;
            case LOCATION_ID:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory);
                qb.appendWhere(com.cogknit.fovea.providers.FoveaContract.Location.Columns.ID + "="
                        + uri.getPathSegments().get(1));
                break;
            case LIKES:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory);
                /** Sort by TIMESTAMP by default */
                if (sortOrder == null || sortOrder == "")
                    sortOrder = com.cogknit.fovea.providers.FoveaContract.Likes.Columns.TIMESTAMP + " DESC";
                break;
            case LIKES_ID:
                qb.setTables(com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory);
                qb.appendWhere(com.cogknit.fovea.providers.FoveaContract.Likes.Columns.ID + "="
                        + uri.getPathSegments().get(1));
                break;
            case APPINVITES:
                qb.setTables(FoveaContract.AppInvites.appInvitesDirectory);
                /** Sort by TIMESTAMP by default */
                if (sortOrder == null || sortOrder == "")
                    sortOrder = com.cogknit.fovea.providers.FoveaContract.AppInvites.Columns.TIMESTAMP + " DESC";
                break;
            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }

        Cursor c = qb.query(db, projection, selection, selectionArgs, null,
                null, sortOrder);
        /**
         * register to watch a content URI for changes
         */
        //c.setNotificationUri(getContext().getContentResolver(), uri);

        return c;
    }

    public String getType(Uri uri) {
        String dirType = "vnd.android.cursor.dir/vnd.";
        String itemType = "vnd.android.cursor.item/vnd.";
        switch (uriMatcher.match(uri)) {
            case USERPROFILE:
                return dirType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + FoveaContract.UserProfile.userProfileDirectory;
            case CALLS:
                return dirType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory;
            case CALL_ID:
                return itemType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory;
            case PEOPLE:
            case PEOPLE_FILTER:
                return dirType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory;
            case PERSON_ID:
                return itemType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory;
            case SMS:
                return dirType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory;
            case SMS_ID:
                return itemType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory;
            case HISTORY:
                return dirType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.History.historyDirectory;
            case HISTORY_ID:
                return itemType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.History.historyDirectory;
            case APP:
                return dirType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory;
            case APP_ID:
                return itemType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory;
            case LOCATIONS:
                return dirType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory;
            case LOCATION_ID:
                return itemType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory;
            case LIKES:
                return dirType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory;
            case LIKES_ID:
                return itemType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory;
            case APPINVITES:
                return itemType + com.cogknit.fovea.providers.FoveaContract.AUTHORITY + "."
                        + FoveaContract.AppInvites.appInvitesDirectory;
            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }
    }

    public static synchronized Uri insert(Context context, Uri uri, ContentValues values) {

        if (db == null) {
            initializeFoveaDatabase(context);
        }
        SharedPreferences prefs = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, 0);
        String userId = prefs.getString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, "");
        //FoveaLog.d(TAG,"User ID: "+userId);
        values.put(FoveaContract.Apps.Columns.FOVEA_USERID, userId);


        long rowID = -1;
        Uri _uri = null;
        switch (uriMatcher.match(uri)) {
            case USERPROFILE:
                rowID = db
                        .insert(FoveaContract.UserProfile.userProfileDirectory, "", values);
                _uri = ContentUris.withAppendedId(
                        FoveaContract.UserProfile.CONTENT_USERPROFILE_URI, rowID);
                break;
            case CALLS:
                rowID = db
                        .insert(com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory, "", values);
                _uri = ContentUris.withAppendedId(
                        com.cogknit.fovea.providers.FoveaContract.Calls.CONTENT_CALLS_URI, rowID);
                break;
            case PEOPLE:
            case PEOPLE_FILTER:
                rowID = db.insert(com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory, "", values);
                _uri = ContentUris.withAppendedId(
                        com.cogknit.fovea.providers.FoveaContract.People.CONTENT_PEOPLE_URI, rowID);
                break;
            case SMS:
                rowID = db.insert(com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory, "", values);
                _uri = ContentUris.withAppendedId(
                        com.cogknit.fovea.providers.FoveaContract.Sms.CONTENT_SMS_URI, rowID);
                break;
            case HISTORY:
                rowID = db.insert(com.cogknit.fovea.providers.FoveaContract.History.historyDirectory, "",
                        values);
                _uri = ContentUris.withAppendedId(
                        com.cogknit.fovea.providers.FoveaContract.History.CONTENT_HISTORY_URI, rowID);
                break;
            case APP:
                rowID = db.insert(com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory, "", values);
                _uri = ContentUris.withAppendedId(
                        com.cogknit.fovea.providers.FoveaContract.Apps.CONTENT_APP_URI, rowID);
                break;
            case LOCATIONS:
                rowID = db.insert(com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory, "",
                        values);
                _uri = ContentUris.withAppendedId(
                        com.cogknit.fovea.providers.FoveaContract.Location.CONTENT_LOCATION_URI, rowID);
                break;
            case LIKES:
                rowID = db
                        .insert(com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory, "", values);
                _uri = ContentUris.withAppendedId(
                        com.cogknit.fovea.providers.FoveaContract.Likes.CONTENT_LIKES_URI, rowID);
                break;
            case APPINVITES:
                rowID = db.insert(FoveaContract.AppInvites.appInvitesDirectory, "", values);
                _uri = ContentUris.withAppendedId(
                        FoveaContract.AppInvites.CONTENT_APPINVITES_URI, rowID);
                break;
            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }

        /**
         * If record is added successfully
         */
        if (rowID > 0) {

            //getContext().getContentResolver().notifyChange(_uri, null);
            return _uri;
        }
        throw new SQLException("Failed to add a record into " + uri);
    }

    public static synchronized int delete(Context context, Uri uri, String selection,
                                          String[] selectionArgs) {
        if (db == null) {
            initializeFoveaDatabase(context);
        }
        int count = 0;
        String id = null;

        switch (uriMatcher.match(uri)) {
            case USERPROFILE:
                count = db.delete(FoveaContract.UserProfile.userProfileDirectory, selection,
                        selectionArgs);
                break;
            case CALLS:
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory, selection,
                        selectionArgs);
                break;
            case CALL_ID:
                id = uri.getLastPathSegment();
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory,
                        com.cogknit.fovea.providers.FoveaContract.Calls.Columns.ID
                                + " = "
                                + id
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;
            case PEOPLE:
            case PEOPLE_FILTER:
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory, selection, selectionArgs);
                break;
            case PERSON_ID:
                id = uri.getLastPathSegment();
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory,
                        com.cogknit.fovea.providers.FoveaContract.People.Columns.ID
                                + " = "
                                + id
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;
            case SMS:
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory, selection,
                        selectionArgs);
                break;
            case SMS_ID:
                id = uri.getLastPathSegment();
                count = db.delete(
                        com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory,
                        com.cogknit.fovea.providers.FoveaContract.Sms.Columns.ID
                                + " = "
                                + id
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;
            case HISTORY:
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.History.historyDirectory,
                        selection, selectionArgs);
                FoveaLog.d(TAG, "History items deleted: " + count);
                break;
            case HISTORY_ID:
                id = uri.getLastPathSegment();
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.History.historyDirectory,
                        com.cogknit.fovea.providers.FoveaContract.History.Columns.ID
                                + " = "
                                + id
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;
            case APP:
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory, selection,
                        selectionArgs);
                break;
            case APP_ID:
                id = uri.getLastPathSegment();
                count = db.delete(
                        com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory,
                        com.cogknit.fovea.providers.FoveaContract.Apps.Columns.ID
                                + " = "
                                + id
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;
            case LOCATIONS:
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory,
                        selection, selectionArgs);
                break;
            case LOCATION_ID:
                id = uri.getLastPathSegment();
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory,
                        com.cogknit.fovea.providers.FoveaContract.Location.Columns.ID
                                + " = "
                                + id
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
            case LIKES:
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory, selection,
                        selectionArgs);
                break;
            case LIKES_ID:
                id = uri.getLastPathSegment();
                count = db.delete(com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory,
                        com.cogknit.fovea.providers.FoveaContract.Likes.Columns.ID
                                + " = "
                                + id
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;
            case APPINVITES:
                count = db.delete(FoveaContract.AppInvites.appInvitesDirectory, selection,
                        selectionArgs);
                break;
            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }


        //getContext().getContentResolver().notifyChange(uri, null);
        return count;

    }

    public static synchronized int update(Context context, Uri uri, ContentValues values,
                                          String selection, String[] selectionArgs) {
        if (db == null) {
            initializeFoveaDatabase(context);
        }

        int count = 0;
        SharedPreferences prefs = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, 0);
        String userId = prefs.getString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, "");
        //FoveaLog.d(TAG,"User ID: "+userId);
        values.put(FoveaContract.Apps.Columns.FOVEA_USERID, userId);
        switch (uriMatcher.match(uri)) {
            case USERPROFILE:
                count = db.update(FoveaContract.UserProfile.userProfileDirectory, values,
                        selection, selectionArgs);
                break;
            case CALLS:
                count = db.update(com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory, values,
                        selection, selectionArgs);
                break;
            case CALL_ID:
                count = db.update(
                        com.cogknit.fovea.providers.FoveaContract.Calls.callsDirectory,
                        values,
                        com.cogknit.fovea.providers.FoveaContract.Calls.Columns.ID
                                + " = "
                                + uri.getLastPathSegment()
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;
            case PEOPLE:
            case PEOPLE_FILTER:
                count = db.update(com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory, values, selection,
                        selectionArgs);
                break;
            case PERSON_ID:
                count = db.update(
                        com.cogknit.fovea.providers.FoveaContract.People.peopleDirectory,
                        values,
                        com.cogknit.fovea.providers.FoveaContract.People.Columns.ID
                                + " = "
                                + uri.getLastPathSegment()
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;
            case SMS:
                count = db.update(com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory, values,
                        selection, selectionArgs);
                break;
            case SMS_ID:
                count = db.update(
                        com.cogknit.fovea.providers.FoveaContract.Sms.smsDirectory,
                        values,
                        com.cogknit.fovea.providers.FoveaContract.Sms.Columns.ID
                                + " = "
                                + uri.getLastPathSegment()
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;

            case HISTORY:
                count = db.update(com.cogknit.fovea.providers.FoveaContract.History.historyDirectory,
                        values, selection, selectionArgs);
                break;
            case HISTORY_ID:
                count = db.update(
                        com.cogknit.fovea.providers.FoveaContract.History.historyDirectory,
                        values,
                        com.cogknit.fovea.providers.FoveaContract.History.Columns.ID
                                + " = "
                                + uri.getLastPathSegment()
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;
            case APP:
                count = db.update(com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory, values,
                        selection, selectionArgs);
                break;
            case APP_ID:
                count = db.update(
                        com.cogknit.fovea.providers.FoveaContract.Apps.appDirectory,
                        values,
                        com.cogknit.fovea.providers.FoveaContract.Apps.Columns.ID
                                + " = "
                                + uri.getLastPathSegment()
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;
            case LOCATIONS:
                count = db.update(com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory,
                        values, selection, selectionArgs);
                break;
            case LOCATION_ID:
                count = db.update(
                        com.cogknit.fovea.providers.FoveaContract.Location.locationDirectory,
                        values,
                        com.cogknit.fovea.providers.FoveaContract.Location.Columns.ID
                                + " = "
                                + uri.getLastPathSegment()
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);

            case LIKES:
                count = db.update(com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory, values,
                        selection, selectionArgs);
                break;
            case LIKES_ID:

                count = db.update(
                        com.cogknit.fovea.providers.FoveaContract.Likes.likesDirectory,
                        values,
                        com.cogknit.fovea.providers.FoveaContract.Likes.Columns.ID
                                + " = "
                                + uri.getLastPathSegment()
                                + (!TextUtils.isEmpty(selection) ? " AND ("
                                + selection + ')' : ""), selectionArgs);
                break;

            case APPINVITES:
                count = db.update(FoveaContract.AppInvites.appInvitesDirectory, values,
                        selection, selectionArgs);
                break;

            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }
        //getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }
}
