package com.cogknit.fovea.providers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;

import com.cogknit.fovea.dataModel.App;
import com.cogknit.fovea.dataModel.History;
import com.cogknit.fovea.dataModel.Person;
import com.cogknit.fovea.dataModel.Sms;
import com.cogknit.fovea.dataModel.UserLocation;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Maithri V M on 31/08/15.
 */
class FoveaDataFetchHelper {
    private Context context;

    public FoveaDataFetchHelper(Context context) {
        this.context = context;
    }

    public List getAppsData(String userID) {
        //FoveaLog.v("TAG", "Reading apps begins here");

        List<App> content = new ArrayList<App>();

        Uri mUri = FoveaContract.Apps.CONTENT_APP_URI;

        String selection = FoveaContract.Apps.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"";

        Cursor c = FoveaDatabaseManager.query(context, mUri, null, selection, null, null);

        while (c.moveToNext()) {
            String name = c
                    .getString(c
                            .getColumnIndex(FoveaContract.Apps.Columns.NAME));
            String pkgNm = c
                    .getString(c
                            .getColumnIndex(FoveaContract.Apps.Columns.PACKAGE_NAME));
            long foreground = c
                    .getLong(c
                            .getColumnIndex(FoveaContract.Apps.Columns.FOREGROUND_TIME));

            String foveaUserID = c
                    .getString(c
                            .getColumnIndex(FoveaContract.Apps.Columns.FOVEA_USERID));
//                    Long.toString(foreground)));
            App app = new App(name, pkgNm, foreground, foveaUserID);
            content.add(app);

        }
        c.close();
        //FoveaLog.v("TAG", "Reading apps ends here");

        return content;
    }

    public List getSmsData(String userID) {
        List<Sms> content = new ArrayList<Sms>();

        Uri mUri = FoveaContract.Sms.CONTENT_SMS_URI;

            String selection = FoveaContract.Sms.Columns.FOVEA_USERID + "="
                    + "\"" + userID + "\"";
            Cursor c = FoveaDatabaseManager.query(context,mUri, null, selection, null, null);


        while (c.moveToNext()) {

            String number = c.getString(c
                    .getColumnIndex(FoveaContract.Sms.Columns.NUMBER));
            String body = c.getString(c
                    .getColumnIndex(FoveaContract.Sms.Columns.BODY));
            String timestamp = c.getString(c
                    .getColumnIndex(FoveaContract.Location.Columns.TIMESTAMP));
            String foveaUserID = c
                    .getString(c
                            .getColumnIndex(FoveaContract.Sms.Columns.FOVEA_USERID));
            Sms sms = new Sms(number, body, timestamp, foveaUserID);
            content.add(sms);

        }
        c.close();

        return content;
    }

    List getPeopleData(String userID) {
        //FoveaLog.v("TAG", "Reading people begins here");

        List<Person> content = new ArrayList<Person>();

        Uri mUri = FoveaContract.People.CONTENT_PEOPLE_URI;

        String selection = FoveaContract.People.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"";
        Cursor c = FoveaDatabaseManager.query(context, mUri, null, selection, null, null);

        while (c.moveToNext()) {

            String name = c.getString(c
                    .getColumnIndex(FoveaContract.People.Columns.NAME));

            String number = c.getString(c
                    .getColumnIndex(FoveaContract.People.Columns.NUMBER));
            long duration = c.getLong(c
                    .getColumnIndex(FoveaContract.People.Columns.DURATION));

            long frequency = c.getLong(c
                    .getColumnIndex(FoveaContract.People.Columns.FREQUENCY));

            Double weight = c.getDouble(c
                    .getColumnIndex(FoveaContract.People.Columns.WEIGHT));

            String timeStamp = c.getString(c
                    .getColumnIndex(FoveaContract.People.Columns.TIMEFRAME));

            String foveauserID = c.getString(c
                    .getColumnIndex(FoveaContract.People.Columns.FOVEA_USERID));

            Person person = new Person(name, number, duration, frequency, weight, timeStamp, foveauserID);
            content.add(person);

        }
        c.close();
        //FoveaLog.v("TAG", "Reading people ends here");

        return content;
    }

    List getHistoryData(String userID) {
        //FoveaLog.v("TAG", "Reading History begins here");

        List<History> content = new ArrayList<History>();

        Uri mUri = FoveaContract.History.CONTENT_HISTORY_URI;
        String selection = FoveaContract.History.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"";
        Cursor c = FoveaDatabaseManager.query(context, mUri, null, selection, null, null);

        while (c.moveToNext()) {

            String title = c.getString(c
                    .getColumnIndex(FoveaContract.History.Columns.TITLE));
            String url = c.getString(c
                    .getColumnIndex(FoveaContract.History.Columns.URL));
            String timestamp = c
                    .getString(c
                            .getColumnIndex(FoveaContract.History.Columns.TIMESTAMP));
            int isBookmark = c
                    .getInt(c
                            .getColumnIndex(FoveaContract.History.Columns.BOOKMARK_FLAG));
            String foveaUserID = c
                    .getString(c
                            .getColumnIndex(FoveaContract.History.Columns.FOVEA_USERID));
            History history = new History(title, url, timestamp, isBookmark, foveaUserID);
            content.add(history);

        }
        c.close();
        //FoveaLog.v("TAG", "Reading History ends here");

        return content;
    }

    List getLocationsData(String userID) {
        //FoveaLog.v("TAG", "Reading getLocationsData begins here");

        List<UserLocation> content = new ArrayList();

        Uri mUri = FoveaContract.Location.CONTENT_LOCATION_URI;
        String selection = FoveaContract.Location.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"";
        Cursor c = FoveaDatabaseManager.query(context, mUri, null, selection, null, null);

        while (c.moveToNext()) {

            double longitude = c
                    .getDouble(c
                            .getColumnIndex(FoveaContract.Location.Columns.LONGITUDE));
            double latitude = c
                    .getDouble(c
                            .getColumnIndex(FoveaContract.Location.Columns.LATITUDE));
            String timestamp = c
                    .getString(c
                            .getColumnIndex(FoveaContract.Location.Columns.TIMESTAMP));
            int activity = c
                    .getInt(c
                            .getColumnIndex(FoveaContract.Location.Columns.ACTIVITY));

            Long tsLong = System.currentTimeMillis() / 1000;
            String ts = tsLong.toString();
            String foveaUserID = c
                    .getString(c
                            .getColumnIndex(FoveaContract.Location.Columns.FOVEA_USERID));

            UserLocation location = new UserLocation(latitude, longitude, activity, timestamp);
            content.add(location);

        }
        c.close();
        //FoveaLog.v("TAG", "Reading getLocationsData ends here");

        return content;
    }

    private List<AppInvite> getAppInvitesWithCriteria(String selection, String sortOrder) {
        //FoveaLog.v("TAG", "Reading invites begins here");

        List<AppInvite> content = new ArrayList();

        Uri mUri = FoveaContract.AppInvites.CONTENT_APPINVITES_URI;

        Cursor c = FoveaDatabaseManager.query(context, mUri, null, selection, null, sortOrder);

        while (c.moveToNext()) {

            String inviteeName = c
                    .getString(c
                            .getColumnIndex(FoveaContract.AppInvites.Columns.INVITEE_NAME));
            String inviteeEmail = c
                    .getString(c
                            .getColumnIndex(FoveaContract.AppInvites.Columns.INVITEE_EMAIL));
            String inviteePh = c
                    .getString(c
                            .getColumnIndex(FoveaContract.AppInvites.Columns.INVITEE_PHONE));
            int status = c
                    .getInt(c
                            .getColumnIndex(FoveaContract.AppInvites.Columns.INVITE_STATUS));
            int platformID = c
                    .getInt(c
                            .getColumnIndex(FoveaContract.AppInvites.Columns.PLATFORM_ID));
            int devicefamilyID = c
                    .getInt(c
                            .getColumnIndex(FoveaContract.AppInvites.Columns.DEVICE_FAMILY));

            double inviteeWeight = c
                    .getInt(c
                            .getColumnIndex(FoveaContract.AppInvites.Columns.INVITEE_WEIGHT));

            String timestamp = c
                    .getString(c
                            .getColumnIndex(FoveaContract.Location.Columns.TIMESTAMP));

            String foveaUserID = c
                    .getString(c
                            .getColumnIndex(FoveaContract.Location.Columns.FOVEA_USERID));

            AppInvite.InviteStatus inviteStatus = AppInvite.InviteStatus.values()[status];
            AppInvite.PlatformID platformEnumID = AppInvite.PlatformID.values()[platformID];
            AppInvite.DeviceFamilyID deviceFamilyEnumID = AppInvite.DeviceFamilyID.values()[devicefamilyID];

            AppInvite invite = new AppInvite(inviteeName, inviteeEmail, inviteePh, inviteStatus ,inviteeWeight, platformEnumID, deviceFamilyEnumID);
            content.add(invite);

        }
        c.close();
        //FoveaLog.v("TAG", "Reading invites ends here");

        return content;
    }

    List<AppInvite> getAppInvitesPendingSubmission(String userID) {

        String selection = FoveaContract.AppInvites.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"" + " AND "+FoveaContract.AppInvites.Columns.INVITE_STATUS + "!="
                + "\"" + AppInvite.InviteStatus.NoEvent.ordinal() + "\"";

        List<AppInvite> invites = getAppInvitesWithCriteria(selection, null);

        return invites;
    }

    List<FoveaAppInvitee> getAppInvites(String userID, int recordCount) {

        String selection = FoveaContract.AppInvites.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"" + " AND "+FoveaContract.AppInvites.Columns.INVITE_STATUS + "="
                + "\"" + AppInvite.InviteStatus.NoEvent.ordinal() + "\"";

        String sortOrder = FoveaContract.AppInvites.Columns.INVITEE_WEIGHT + " DESC";

        List invites = getAppInvitesWithCriteria(selection, sortOrder);
        List<FoveaAppInvitee> topRecommendations = invites.subList(0, recordCount > invites.size() ? invites.size() : recordCount);
        return topRecommendations;
    }

    void purgeAppInvitesData(String userID) {
        String selection = FoveaContract.Apps.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"";
        purgeData(FoveaContract.AppInvites.CONTENT_APPINVITES_URI, selection);
    }

    void purgeAppsData(String userID) {
        String selection = FoveaContract.Apps.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"";
        purgeData(FoveaContract.Apps.CONTENT_APP_URI, selection);


    }

    void purgeSmsData(String userID) {
        String selection = FoveaContract.Sms.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"";
        purgeData(FoveaContract.Sms.CONTENT_SMS_URI, selection);
    }

    void purgePeopleData(String userID) {
        String selection = FoveaContract.People.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"";
        purgeData(FoveaContract.People.CONTENT_PEOPLE_URI, selection);
    }

    void purgeHistoryData(String userID) {
        String selection = FoveaContract.History.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"";
        purgeData(FoveaContract.History.CONTENT_HISTORY_URI, selection);
    }

    void purgeLocationsData(String userID) {
        String selection = FoveaContract.Location.Columns.FOVEA_USERID + "="
                + "\"" + userID + "\"";
        purgeData(FoveaContract.Location.CONTENT_LOCATION_URI, selection);
    }

    int purgeData(Uri uri, String selections) {
        int count = FoveaDatabaseManager.delete(context, uri, selections, null);
        return count;
    }

    void saveInfluenceGraph(List<AppInvite> graph) {
    // Insert values into InfluenceGraph
        for (AppInvite invite : graph) {
            /*getContentResolver().insert(
                    FoveaContract.Calls.CONTENT_CALLS_URI,
                    log.getContentValues());*/
            FoveaDatabaseManager.insert(this.context,
                    FoveaContract.AppInvites.CONTENT_APPINVITES_URI,
                    invite.getContentValues());
        }
    }

    void updateInviteesStatus(AppInvite invite){
        String selection = FoveaContract.AppInvites.Columns.INVITEE_NAME + "="
                + "\"" + invite.getInviteeName() + "\"" + " AND "+FoveaContract.AppInvites.Columns.INVITEE_PHONE + "="
                + "\"" + invite.getInviteePhoneNumber() + "\"";
        //FoveaLog.v("FoveaDB","Update query"+selection);
        FoveaDatabaseManager.update(this.context,
                FoveaContract.AppInvites.CONTENT_APPINVITES_URI,
                invite.getContentValues(), selection, null);
    }

    void updateInviteesStatusWithDetails(String inviteeName, String inviteePh, AppInvite.InviteStatus status){
        String selection = FoveaContract.AppInvites.Columns.INVITEE_NAME + "="
                + "\"" + inviteeName + "\"" + " AND "+FoveaContract.AppInvites.Columns.INVITEE_PHONE + "="
                + "\"" + inviteePh + "\"";

        /*List<AppInvite> invites = getAppInvitesWithCriteria(selection, null);
        for (AppInvite invitee : invites) {
            invitee.setStatus(status);
            FoveaDatabaseManager.update(this.context,
                    FoveaContract.AppInvites.CONTENT_APPINVITES_URI,
                    invitee.getContentValues(), selection, null);
        }
        */
        ContentValues values = new ContentValues();
        values.put(FoveaContract.AppInvites.Columns.INVITE_STATUS, status.ordinal());
        FoveaDatabaseManager.update(this.context,
                FoveaContract.AppInvites.CONTENT_APPINVITES_URI,
                values, selection, null);

    }
}
