package com.cogknit.fovea.providers;
import android.net.Uri;
import android.provider.BaseColumns;

/**
 * Contract class for the GoGlocal Provider. Provides statically initialized
 * URIs to the GoGlocal Provider. Also, provides columns for the directories <h3>
 * Note:</h3> The class name and package defined in the {@code initAuthority()}
 * method must be defined by all apps which use this library
 *
 * @author Chirag
 * @version 0.1
 * @since 2015-01-11
 *
 */

public class FoveaContract {

    /**
     * Authority for the GoGlocalProvider. Statically resolved for each app
     * which uses the provider.
     */
    public static final String AUTHORITY = "com.cogknit.fovea.providers.FoveaContract";

    public static final String TAG = "FoveaContract";

    /**
     * Class containing constants for the table name, URI and columns of the
     * history directory
     *
     * @author Chirag
     *
     */
    public static class People {

        /** Table name of People Directory */
        public static final String peopleDirectory = "people";
        /** Path name for DAILY People */
        public static final String DAILY = "ADAILY";
        /** Path name for WEEKLY People */
        public static final String WEEKLY = "BWEEKLY";
        /** Path name for MONTHLY People */
        public static final String MONTHLY = "CMONTHLY";
        /** Path name for QUARTERLY People */
        public static final String QUARTERLY = "DQUARTERLY";
        /** CONTENT URI for the PeopleDirectory */
        public static final Uri CONTENT_PEOPLE_URI = Uri.parse("content://"
                + AUTHORITY + "/" + People.peopleDirectory);
        /** CONTENT URI for the PeopleDirectory on a Daily Basis */
        public static final Uri CONTENT_PEOPLE_DAILY_URI = Uri
                .parse("content://" + AUTHORITY + "/" + People.peopleDirectory
                        + "/" + DAILY);
        /** CONTENT URI for the PeopleDirectory on a Weekly Basis */
        public static final Uri CONTENT_PEOPLE_WEEKLY_URI = Uri
                .parse("content://" + AUTHORITY + "/" + People.peopleDirectory
                        + "/" + WEEKLY);
        /** CONTENT URI for the PeopleDirectory on a Monthly Basis */
        public static final Uri CONTENT_PEOPLE_MONTHLY_URI = Uri
                .parse("content://" + AUTHORITY + "/" + People.peopleDirectory
                        + "/" + MONTHLY);
        /** CONTENT URI for the PeopleDirectory on a Quarterly Basis */
        public static final Uri CONTENT_PEOPLE_QUARTERLY_URI = Uri
                .parse("content://" + AUTHORITY + "/" + People.peopleDirectory
                        + "/" + QUARTERLY);



        /**
         * Contains the column names for the People Directory of the
         * GoGlocalProvider
         *
         * @author Chirag
         *
         */
        public static abstract class Columns implements BaseColumns {
            /**
             * String constant for the column name which contains row ID for
             * People
             */
            public static final String ID = BaseColumns._ID;
            /**
             * String constant for the column name which contains Cached contact
             * name
             */
            public static final String NAME = CommonColumns.NAME;
            /**
             * String constant for the column name which contains total duration
             * for all calls for this person
             */
            public static final String TIMEFRAME = "timeframe";

            /**Fovea User ID**/
            public static final String FOVEA_USERID = "foveaUserID";

            public static final String DURATION = CommonColumns.DURATION;
            /** String constant for the column name which contains phone number */
            public static final String NUMBER = CommonColumns.NUMBER;
            /**
             * String constant for the column name which contains number of
             * calls
             */
            public static final String FREQUENCY = "frequency";
            /**
             * String constant for the column name which contains row the
             * contact URI (Available only from API level 21)
             */
            public static final String CONTACT_URI = "contact_uri";
            /**
             * String constant for the column name which contains the timeframe
             * (DAILY,WEEKLY,MONTHLY,QUARTERLY) of entry
             */
            /**
             * String constant for the column name which represents weight of
             * influence
             */
            public static final String WEIGHT = "weight";
        }

    }

    /**
     * Class containing constants for the table name, URI and columns of the
     * calls directory
     *
     * @author Chirag
     *
     */
    public static class Calls {

        /** Table name of Calls Directory */
        public static final String callsDirectory = "calls";
        /** CONTENT URI for the CallsDirectory */
        public static final Uri CONTENT_CALLS_URI = Uri.parse("content://"
                + AUTHORITY + "/" + callsDirectory);

        /**
         * Contains the column names for the Calls Directory of the
         * GoGlocalProvider
         *
         * @author Chirag
         *
         */
        public static abstract class Columns implements BaseColumns {
            /**
             * String constant for the column name which contains row ID for
             * Calls
             */
            public static final String ID = BaseColumns._ID;
            /**
             * String constant for the column name which contains Cached contact
             * name
             */
            public static final String NAME = CommonColumns.NAME;
            /**
             * String constant for the column name which contains duration for
             * call
             */
            /**Fovea User ID**/
            public static final String FOVEA_USERID = "foveaUserID";

            public static final String TIMEFRAME = "timeframe";

            public static final String DURATION = CommonColumns.DURATION;
            /** String constant for the column name which contains phone number */
            public static final String NUMBER = CommonColumns.NUMBER;
            /** String constant for the column name which contains time of call */
            public static final String TIMESTAMP = CommonColumns.TIMESTAMP;
            /**
             * String constant for the column name which contains row the
             * contact URI (Available only from API level 21
             */
            public static final String CONTACT_URI = "contact_uri";

        }
    }

    /**
     * Class containing constants for the table name, URI and columns of the sms
     * directory
     *
     * @author Chirag
     *
     */
    public static class Sms {
        /** Table name of SMS Directory */
        public static final String smsDirectory = "sms";
        /** CONTENT URI for the SMS Directory */
        public static final Uri CONTENT_SMS_URI = Uri.parse("content://"
                + AUTHORITY + "/" + smsDirectory);

        /**
         * Contains the column names for the SMS Directory of the
         * GoGlocalProvider
         *
         * @author Chirag
         *
         */
        public static abstract class Columns implements BaseColumns {
            /**
             * String constant for the column name which contains row ID for
             * Smses
             */
            public static final String ID = BaseColumns._ID;
            /** String constant for the column name which contains phone number */
            public static final String NUMBER = CommonColumns.NUMBER;
            /** String constant for the column name which contains time of call */
            public static final String TIMESTAMP = CommonColumns.TIMESTAMP;
            /**
             * String constant for the column name which contains the message
             * body
             */
            public static final String BODY = "body";
            /**Fovea User ID**/
            public static final String FOVEA_USERID = "foveaUserID";
        }
    }

    /**
     * Class containing constants for the table name, URI and columns of the
     * history directory
     *
     * @author Chirag
     *
     */
    public static class History {
        /** Table name of HISTORY Directory */
        public static final String historyDirectory = "history";
        /** CONTENT URI for the HISTORY Directory */
        public static final Uri CONTENT_HISTORY_URI = Uri.parse("content://"
                + AUTHORITY + "/" + historyDirectory);

        /**
         * Contains the column names for the HISTORY Directory of the
         * GoGlocalProvider
         *
         * @author Drithi
         * @author Chirag
         *
         */
        public static abstract class Columns implements BaseColumns {
            /**
             * String constant for the column name which contains row ID for
             * History
             */
            public static final String ID = BaseColumns._ID;
            /**
             * String constant for the column name which contains
             * history/bookmark title
             */
            public static final String TITLE = CommonColumns.TITLE;
            /**
             * String constant for the column name which contains URL of
             * bookmark/history item
             */
            public static final String URL = "url";
            /**
             * String constant for the column name which contains an integer
             * indicating if this entry is a bookmark or a history item (
             * BOOKMARK=1 , HISTORY=0)
             */
            public static final String BOOKMARK_FLAG = "bookmarks";

            /**
             * String constant for the column name which contains the time at
             * which this entry was created
             */
            public static final String TIMESTAMP = CommonColumns.TIMESTAMP;
            /**Fovea User ID**/
            public static final String FOVEA_USERID = "foveaUserID";
        }
    }

    public static class Apps {
        /** Table name of App Directory */
        public static final String appDirectory = "app";
        /** CONTENT URI for the appDirectory */
        public static final Uri CONTENT_APP_URI = Uri.parse("content://"
                + AUTHORITY + "/" + appDirectory);

        /**
         * Contains the column names for the App Directory of the
         * GoGlocalProvider
         *
         */
        public static abstract class Columns implements BaseColumns {
            /**
             * String constant for the column name which contains row ID for
             * People
             */
            public static final String ID = BaseColumns._ID;
            /**
             * String constant for the column name which contains App name
             */
            public static final String NAME = CommonColumns.NAME;
            /**
             * String constant for the column name which contains Package name
             */
            public static final String PACKAGE_NAME = "packageName";
            /**
             * string constant for the column name which contains total
             * foreground time for each app
             */
            public static final String FOREGROUND_TIME = "foregroundTime";
            /**Fovea User ID**/
            public static final String FOVEA_USERID = "foveaUserID";
        }
    }

    public static class Location {

        /** Table name of Location Directory */
        public static final String locationDirectory = "location";
        /** CONTENT URI for the Location Directory */
        public static final Uri CONTENT_LOCATION_URI = Uri.parse("content://"
                + AUTHORITY + "/" + locationDirectory);

        /**
         * Contains the column names for the Location Directory of the
         * GoGlocalProvider
         *
         * @author Chirag
         *
         */
        public static abstract class Columns implements BaseColumns {
            /**
             * String constant for the column name which contains row ID for
             * Locations
             */
            public static final String ID = BaseColumns._ID;
            /** String constant for the column name which contains latitude */
            public static final String LATITUDE = "latitude";
            /** String constant for the column name which contains longitude */
            public static final String LONGITUDE = "longitude";
            /**
             * String constant for the column name which contains the detected
             * activity for this location entry
             */
            public static final String ACTIVITY = "activity";
            /**
             * String constant for the column name which contains time of
             * detetced activity and location
             */
            public static final String TIMESTAMP = CommonColumns.TIMESTAMP;
            /**Fovea User ID**/
            public static final String FOVEA_USERID = "foveaUserID";
        }
    }

    public static class UserProfile {
        /** Table name of UP Directory */
        public static final String userProfileDirectory = "userProfile";
        /** CONTENT URI for the UPDirectory */
        public static final Uri CONTENT_USERPROFILE_URI = Uri.parse("content://"
                + AUTHORITY + "/" + userProfileDirectory);

        /**
         * Contains the column names for the App Directory of the
         * GoGlocalProvider
         *
         */
        public static abstract class Columns implements BaseColumns {
            /**
             * String constant for the column name which contains row ID for
             * Userprofile
             */
            public static final String ID = BaseColumns._ID;
            /**
             * String constant for the column name which contains User name
             */
            public static final String NAME = CommonColumns.NAME;
            /**
             * String constant for the column name which contains User ID given by the business
             */
            public static final String UNIQUE_BIZ_USERID = "uniqueUserID";
            /**
             * String constant for the column name which contains User email ID
             */
            public static final String EMAIL_ID = "emailID";
            /**
             * String constant for the column name which contains User Phone number
             */
            public static final String PHONE_NUMBER = "phoneNumber";
            /**
             * String constant for the column name which contains User date of birth
             */
            public static final String DOB = "dateOfBirth";

            /**
             * String constant for the column name which contains User gender value
             */
            public static final String GENDER = "gender";

            /**Fovea User ID**/
            public static final String FOVEA_USERID = "foveaUserID";

            /** String constant for the column name which contains the timestamp */
            public static final String TIMESTAMP = CommonColumns.TIMESTAMP;
        }
    }

    /**
     * Class containing common column names
     *
     * @author Chirag
     *
     */
    public static abstract class CommonColumns implements BaseColumns {
        /**
         * Common column name for timestamp ennumbertries
         */
        public static final String TIMESTAMP = "timestamp";
        /**
         * Common column name for name entries
         */
        public static final String NAME = "name";
        /**
         * Common column name for number entries
         */
        public static final String NUMBER = "number";
        /**
         * Common column name for duration entries
         */
        public static final String DURATION = "duration";
        /** Common column name for titles*/
        public static final String TITLE = "title";
    }


    /**
     * Class containing constants for the table name, URI and columns of the
     * calls directory
     *
     * @author Chirag
     *
     */
    public static class Likes {

        /** Table name of Likes Directory */
        public static final String likesDirectory = "likes";
        /** CONTENT URI for the likesDirectory */
        public static final Uri CONTENT_LIKES_URI = Uri.parse("content://"
                + AUTHORITY + "/" + likesDirectory);

        /**
         * Contains the column names for the Likes Directory of the
         * GoGlocalProvider
         */
        public static abstract class Columns implements BaseColumns {
            /**
             * String constant for the column name which contains row ID for
             * Likes
             */
            public static final String ID = BaseColumns._ID;
            /**
             * String constant for the column name which contains facebook ID for
             * Likes
             */
            public static final String FB_ID = "id";
            /**
             * String constant for the column name which contains Cached contact
             * name
             */
            public static final String NAME = CommonColumns.NAME;
            /**
             * String constant for the column name which contains duration for
             * call
             */
            public static final String CATEGORY = "category";
            /** String constant for the column name which contains phone number */
            public static final String TIMESTAMP = CommonColumns.TIMESTAMP;

            /**
             * String constant for the column name which contains row the
             * contact URI (Available only from API level 21
             */
            public static final String CATEGORY_OTHER = "category_other";
            /**Fovea User ID**/
            public static final String FOVEA_USERID = "foveaUserID";

        }
    }

    /**
     * Class containing constants for the table name, URI and columns of the
     * app invites directory
     *
     * @author Maithri
     *
     */
    public static class AppInvites {

        /** Table name of AppInvites Directory */
        public static final String appInvitesDirectory = "appInvites";
        /** CONTENT URI for the CallsDirectory */
        public static final Uri CONTENT_APPINVITES_URI = Uri.parse("content://"
                + AUTHORITY + "/" + appInvitesDirectory);

        /**
         * Contains the column names for the App invites Directory of the
         * GoGlocalProvider
         *
         * @author Chirag
         *
         */
        public static abstract class Columns implements BaseColumns {
            /**
             * String constant for the column name which contains row ID for
             * app invites
             */
            public static final String ID = BaseColumns._ID;

            /**String constant for the column name which contains invitee name*/
            public static final String INVITEE_NAME = "inviteeName";

            /**Fovea User ID**/
            public static final String FOVEA_USERID = "foveaUserID";

            /** String constant for the column name which contains phone number */
            public static final String INVITEE_PHONE = "inviteePh";

            /** String constant for the column name which contains email */
            public static final String INVITEE_EMAIL = "inviteeEmail";

            /** Int  for the column name which contains weight */
            public static final String INVITEE_WEIGHT = "inviteeWeight";

            /**String constant for the column name which contains platform ID*/
            public static final String PLATFORM_ID = "platformID";

            /**String constant for the column name which contains device family ID*/
            public static final String DEVICE_FAMILY = "deviceFamilyID";

            /**String constant for the column name which contains invite status*/
            public static final String INVITE_STATUS = "statusID";

            /** String constant for the column name which contains time of call */
            public static final String TIMESTAMP = CommonColumns.TIMESTAMP;
            /**
             * String constant for the column name which contains row the
             * contact URI (Available only from API level 21
             */
            public static final String CONTACT_URI = "contact_uri";

        }
    }
}
