package com.cogknit.fovea.providers;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;

import com.cogknit.fovea.Fovea;
import com.cogknit.fovea.FoveaSharedPreferences;
import com.cogknit.fovea.utils.FoveaLog;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created by Maithri V M on 10/10/15.
 */
public class FoveaAppInvitesManager {
    private static final int INVITEE_COUNT = 5;
    private boolean wait = false;
    private final String SENT = "SMS_SENT";
    private BroadcastReceiver receiver = null;
    private static final String TAG = "FoveaAppInvites";

    public List<FoveaAppInvitee> getAppInvitees(Context context)  throws Fovea.UninitializedException {
        //1. Check if SDK is authorized
        SharedPreferences settings = context.getSharedPreferences(
                FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        Boolean hasAuthenticated = settings.getBoolean(FoveaSharedPreferences.UserProfile.isSDKAuthorized, false);
        if (!hasAuthenticated) {
            throw new Fovea.UninitializedException();
        }

        //2. Access the stored influence graph
        final String userID = settings.getString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, "");

        FoveaDataFetchHelper helper = new FoveaDataFetchHelper(context);
        List<FoveaAppInvitee> invitees = helper.getAppInvites(userID, INVITEE_COUNT);

        //Return the found list
        return invitees;
    }

    public void feedbackOnAppInvites(List<FoveaAppInvitee> approvedInvitees, List<FoveaAppInvitee> declinedInvitees, String inviteMessage, Context context) throws Fovea.AppInviteException{

        //1. Check if message is not beyond the permissible length
        List<String> parts = SmsManager.getDefault().divideMessage(inviteMessage);
        if (parts.size() > 1)
        {
            throw new Fovea.AppInviteException("Input message is too long, it should not be exceeding 140 character limit");
        }
        //2. Check if Telephony services are available on the device
        TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        if (tm.getPhoneType() == TelephonyManager.PHONE_TYPE_NONE)  {
            throw new Fovea.AppInviteException("Telephony services are not enabled on this device");
        }
        //3. Send out the messages
        //Putting this off the main thread with GCD ASync task
        sendAppInviteMessages(approvedInvitees, inviteMessage, context);

        //4.Save denied invitees
        saveDeniedInvites(declinedInvitees, context);

    }

    private void sendAppInviteSMS(List<FoveaAppInvitee> approvedInvitees, String message, Context context){
        //1. Check the length of the list
        if ((approvedInvitees == null) || (approvedInvitees.isEmpty()))
        {
            return;
        }
        final FoveaDataFetchHelper helper = new FoveaDataFetchHelper(context);

        final AtomicBoolean shouldAwait = new AtomicBoolean();
        shouldAwait.set(true);
        SmsManager sms = SmsManager.getDefault();
        //2. Send out the message to each user
        for (final FoveaAppInvitee invitee : approvedInvitees) {
            //this.wait = true;
            sendSMS(invitee, sms, message, context, new SMSCallback() {
                @Override
                public void sentSuccessfully(FoveaAppInvitee invited) {

                    AppInvite appInviteObj = (AppInvite) invited;
                    appInviteObj.setStatus(AppInvite.InviteStatus.Invited);
                    FoveaLog.v(TAG, "SMS sent to number" + invited.getInviteeName());

                    //3. Update the status back to the database
                    helper.updateInviteesStatus(appInviteObj);
                }

                @Override
                public void sentSuccessfullyToContactWithDetails(String phoneNumber, String name) {
                }

                @Override
                public void messageFailure(Exception exception) {
                    FoveaLog.v(TAG, "SMS could not be sent for reason:" + exception.getLocalizedMessage());
                }
            });

        }
        FoveaLog.v(TAG, "SMS sent to all");
    }

    private void sendSMS(final FoveaAppInvitee invitee, SmsManager sms, String message, final Context context, final SMSCallback callback) {
        FoveaLog.v(TAG, "SMS sending "+invitee.getInviteeName());

        String SENT = "SMS_SENT";
        String DELIVERED = "SMS_DELIVERED";

        PendingIntent sentPI = PendingIntent.getBroadcast(context, 0,
                new Intent(SENT), 0);

        PendingIntent deliveredPI = PendingIntent.getBroadcast(context, 0,
                new Intent(DELIVERED), 0);

        //---when the SMS has been sent---
        context.registerReceiver(new BroadcastReceiver() {
            @Override
            public void onReceive(Context arg0, Intent arg1) {
                switch (getResultCode()) {
                    case Activity.RESULT_OK:
                        FoveaLog.v(TAG, "SMS sent");
                        wait = false;
                        callback.sentSuccessfully(invitee);
                        break;
                    case SmsManager.RESULT_ERROR_GENERIC_FAILURE:
                        FoveaLog.v(TAG, "Generic failure");
                        callback.messageFailure(new Exception("Generic failure"));
                        break;
                    case SmsManager.RESULT_ERROR_NO_SERVICE:
                        FoveaLog.v(TAG, "No service");
                        callback.messageFailure(new Exception("No service"));
                        break;
                    case SmsManager.RESULT_ERROR_NULL_PDU:
                        FoveaLog.v(TAG, "Null PDU");
                        callback.messageFailure(new Exception("Null PDU"));
                        break;
                    case SmsManager.RESULT_ERROR_RADIO_OFF:
                        FoveaLog.v(TAG, "Radio off");
                        callback.messageFailure(new Exception("Radio off"));
                        break;
                }
                context.unregisterReceiver(this);
            }
        }, new IntentFilter(SENT));

        //---when the SMS has been delivered---
        /*context.registerReceiver(new BroadcastReceiver() {
            @Override
            public void onReceive(Context arg0, Intent arg1) {
                switch (getResultCode()) {
                    case Activity.RESULT_OK:
                        FoveaLog.v(TAG, "SMS delivered");

                        // Toast.makeText(getBaseContext(), "SMS delivered", Toast.LENGTH_SHORT).show();
                        break;
                    case Activity.RESULT_CANCELED:
                        FoveaLog.v(TAG, "SMS not delivered");

                        // Toast.makeText(getBaseContext(), "SMS not delivered", Toast.LENGTH_SHORT).show();
                        break;
                }
            }
        }, new IntentFilter(DELIVERED));*/

        sms.sendTextMessage(invitee.getInviteePhoneNumber(), null, message, sentPI, null);


    }

     interface SMSCallback {

         void sentSuccessfully(FoveaAppInvitee number);
         void sentSuccessfullyToContactWithDetails(String phoneNumber, String name);
         void messageFailure(Exception exception);
    }

    private void saveDeniedInvites(List<FoveaAppInvitee> deniedInvitees, Context context){
        //1. Check the length of the list
        if ((deniedInvitees == null) || (deniedInvitees.isEmpty())) {
            return;
        }
        //2. Update the status to each user
        final FoveaDataFetchHelper helper = new FoveaDataFetchHelper(context);
        for (final FoveaAppInvitee invitee : deniedInvitees) {
            AppInvite appInviteObj = (AppInvite)invitee;
            appInviteObj.setStatus(AppInvite.InviteStatus.InviteDeniedByuser);
            FoveaLog.v(TAG, "SMS denied to number"+invitee.getInviteeName());
            //3. Update the status back to the database
            helper.updateInviteesStatus(appInviteObj);
        }
    }

    private void sendAppInviteMessages(List<FoveaAppInvitee> invitees, String message, Context context) {

        //1. Check the length of the list
        if ((invitees == null) || (invitees.isEmpty())) {
            return;
        }

        final FoveaDataFetchHelper helper = new FoveaDataFetchHelper(context);

        registerReceivers(context, new SMSCallback() {
            @Override
            public void sentSuccessfully(FoveaAppInvitee invited) {

                AppInvite appInviteObj = (AppInvite) invited;
                appInviteObj.setStatus(AppInvite.InviteStatus.Invited);
                FoveaLog.v(TAG, "SMS sent to number" + invited.getInviteeName());

                //3. Update the status back to the database
                helper.updateInviteesStatus(appInviteObj);
            }

            public void sentSuccessfullyToContactWithDetails(String phoneNumber, String name) {
                //3. Update the status back to the database
                helper.updateInviteesStatusWithDetails(name,phoneNumber,AppInvite.InviteStatus.Invited);
            }

            @Override
            public void messageFailure(Exception exception) {
                FoveaLog.v(TAG, "SMS could not be sent for reason:" + exception.getLocalizedMessage());
            }
        });
        SMSAsyncTask runner = new SMSAsyncTask(context,message);
        runner.execute(invitees);
    }



    void registerReceivers(final Context context, final SMSCallback callback) {
        //---when the SMS has been sent---
        if (receiver == null)
        {
            receiver = new BroadcastReceiver() {
                @Override
                public void onReceive(Context c, Intent in) {
                    switch (getResultCode()) {
                        case Activity.RESULT_OK:
                            //FoveaLog.v(TAG, "SMS sent to " + in.getStringExtra("Invitee"));
                            Bundle bundle = in.getExtras();
                            //FoveaAppInvitee invite = (FoveaAppInvitee)bundle.getSerializable("Invitee");
                            //FoveaAppInvitee invite = (FoveaAppInvitee)in.getSerializableExtra("Invitee");

                            //FoveaLog.v(TAG, "SMS sent to "+invite.getInviteePhoneNumber());
//                        FoveaLog.v(TAG, "SMS sent to name: "+in.getStringExtra("InviteeName")
//                                +" Number:"+in.getStringExtra("InviteePh"));
                            FoveaLog.v(TAG, "SMS sent to name: " + bundle.getString("InviteeName")
                                    + " Number:" + bundle.getString("InviteePh"));
                            callback.sentSuccessfullyToContactWithDetails(bundle.getString("InviteePh"), bundle.getString("InviteeName"));
                            wait = false;
                            break;
                        case SmsManager.RESULT_ERROR_GENERIC_FAILURE:
                            FoveaLog.v(TAG, "Generic failure");
                            callback.messageFailure(new Exception("Generic failure"));
                            break;
                        case SmsManager.RESULT_ERROR_NO_SERVICE:
                            FoveaLog.v(TAG, "No service");
                            callback.messageFailure(new Exception("No service"));
                            break;
                        case SmsManager.RESULT_ERROR_NULL_PDU:
                            FoveaLog.v(TAG, "Null PDU");
                            callback.messageFailure(new Exception("Null PDU"));
                            break;
                        case SmsManager.RESULT_ERROR_RADIO_OFF:
                            FoveaLog.v(TAG, "Radio off");
                            callback.messageFailure(new Exception("Radio off"));
                            break;
                    }

                }
            };
        }

        context.registerReceiver(receiver, new IntentFilter(SENT));


    }

    void unregisterReceivers(Context inContext){
        FoveaLog.v(TAG,"unregisterReceivers");
        inContext.unregisterReceiver(receiver);
    }
     class SMSAsyncTask extends AsyncTask<List<FoveaAppInvitee>, Integer, Void> {
        private Context context;
         private String message;

        public SMSAsyncTask(Context inContext, String inMessage) {
            context = inContext;
            message = inMessage;
        }

        protected void onPreExecute() {
        }

        @Override
        protected Void doInBackground(List<FoveaAppInvitee>... params) {
            FoveaLog.v(TAG, "Sending invitations...");
            SmsManager smsManager = SmsManager.getDefault();

            List<FoveaAppInvitee> approvedInvitees = params[0];
            int i = 0;

            for (FoveaAppInvitee invitee : approvedInvitees) {
                wait = true;
                String name = invitee.getInviteeName();
                String number = invitee.getInviteePhoneNumber();
                FoveaLog.v(TAG, "SMS sending to name:" + name + " number: " + number);
                Intent sentIn = new Intent(SENT);
                sentIn.putExtra("InviteeName", name);
                sentIn.putExtra("InviteePh", number);
                //AppInvite serInvite = (AppInvite)invitee;
                //sentIn.putExtra("Invitee", (Serializable)invitee);
                //Bundle bundle = new Bundle();
                //bundle.putSerializable("Invitee",serInvite);
                //sentIn.putExtras(bundle);

                //sentIn.putExtra("Invitee", invitee.getInviteeName());
                PendingIntent sentPIn = PendingIntent.getBroadcast(context, i, sentIn, PendingIntent.FLAG_CANCEL_CURRENT);
                smsManager.sendTextMessage(number, null, message, sentPIn, null);
                ++i;

                try {
                    FoveaLog.v(TAG, "SMS waiting");
                    while (wait)
                    {
                        Thread.sleep(1000);
                    }}
                catch(Exception exception){

                }

            }
            FoveaLog.v(TAG, "Async task returning");
            return null;

        }

        @Override
        protected void onProgressUpdate(Integer... values) {
        }

        @Override
        protected void onPostExecute(Void v) {
            FoveaLog.v(TAG, "Async task onPostExecute");
            unregisterReceivers(context);
        }
    }
}


 /*private void sendAppInviteSMS(List<FoveaAppInvitee> invitees, Context context){
        final FoveaDataFetchHelper helper = new FoveaDataFetchHelper(context);

        final AtomicBoolean shouldAwait = new AtomicBoolean();
        shouldAwait.set(true);
        SmsManager sms = SmsManager.getDefault();
        for (final FoveaAppInvitee invitee : invitees) {
            sendSMS(invitee, sms, "Try this app", context, new SMSCallback() {
                @Override
                public void sentSuccessfully(FoveaAppInvitee invited) {
                    //signal
                    //shouldAwait.set(false);
                    AppInvite appInviteObj = (AppInvite)invited;
                    appInviteObj.setStatus(AppInvite.InviteStatus.Invited);
                    FoveaLog.v(TAG, "SMS sent to number"+invited.getInviteeName());
                    //3. Update the status back to the database
                    helper.updateInviteesStatus(appInviteObj);
                }

                @Override
                public void messageFailure(Exception exception) {

                }
            });
            //wait
            /*try {
                FoveaLog.v(TAG, "SMS waiting");

                while (shouldAwait.get()==true)
            {

                Thread.sleep(1000);

            }}
                catch(Exception exception){

                }*/

        /*}
        FoveaLog.v(TAG, "SMS sent to all");
    }*/
