package com.cogknit.fovea.providers;

import android.content.Context;

import com.cogknit.fovea.providers.AppInvite;
import com.cogknit.fovea.utils.DeviceUtility;
import com.google.gson.annotations.SerializedName;

/**
 * Created by Maithri V M on 08/10/15.
 */
class DeviceUserDetails {
    static final int ANDROID_PLATFORM_ID = 1;
    @SerializedName("inviteePh")
    private String phoneNumber;

    @SerializedName("inviteeEmail")
    private String email;

    @SerializedName("platformID")
    private int platformID;

    @SerializedName("deviceFamilyID")
    private int deviceFamilyID;

    @SerializedName("inviteeName")
    private String name;

    private int statusID;

    public DeviceUserDetails(Context c){
        this.platformID = ANDROID_PLATFORM_ID;
        this.phoneNumber = DeviceUtility.getDevicePhoneNumber(c);
        this.email = DeviceUtility.getDeviceEmail(c);
        this.statusID = AppInvite.InviteStatus.Installed.ordinal();
    }


}
