package com.cogknit.fovea.providers;

import android.content.ContentValues;

import com.google.gson.annotations.Expose;

import java.io.Serializable;

/**
 * Created by Maithri V M on 08/10/15.
 */
class AppInvite extends FoveaAppInvitee implements Serializable {
    @Expose
    private String inviteeName;

    @Expose
    private String inviteePh;

    @Expose
    private String inviteeEmail;

    @Expose
    private PlatformID platformID;

    @Expose
    private DeviceFamilyID deviceFamilyID;

    @Expose
    private int statusID;

    @Expose(serialize = false, deserialize = false)
    private double weight;
    //private static final long serialVersionUID = 7526472295622776147L;
    public enum InviteStatus {
        NoEvent,

        Installed,

        Invited,

        Reminded,

        InviteDeniedByuser
    }

    public enum PlatformID {
        UNKNOWN(0),

        ANDROID(1),

        IOS(2),

        WEB(3);

        private final int id;
        PlatformID(int id) { this.id = id; }
        public int getValue() { return id; }
    }

    public enum DeviceFamilyID {
        UNKNOWN(0),

        SMART_PHONE(1),

        TABLET(2),

        OTHER(3);

        private final int id;
        DeviceFamilyID(int id) { this.id = id; }
        public int getValue() { return id; }
    }


    private transient String foveaUserID;


    public AppInvite(String name, String email, String phone, Double weight, InviteStatus status) {
        super();
        this.inviteeName = name;
        this.inviteeEmail = email;
        this.inviteePh = phone;
        this.weight = weight;
        this.statusID = status.ordinal();
    }

    public AppInvite(String name, String email, String phone, InviteStatus status, Double weight, PlatformID platformID, DeviceFamilyID deviceFamilyID) {
        super();
        this.inviteeName = name;
        this.inviteeEmail = email;
        this.inviteePh = phone;
        this.statusID = status.ordinal();
        this.platformID = platformID;
        this.deviceFamilyID = deviceFamilyID;
        this.weight = weight;
    }

    public void setStatus(InviteStatus status)
    {
        this.statusID = status.ordinal();
    }
    @Override
    public String getInviteeName() {
        return this.inviteeName;
    }

    @Override
    String getInviteePhoneNumber() {
        return this.inviteePh;
    }

    /**
     * Getter for getting ContentValues object for use with the GoGlocal
     * Provider
     *
     * @return A content value object of this Person
     */
    public ContentValues getContentValues() {
        ContentValues values = new ContentValues();

        values.put(FoveaContract.AppInvites.Columns.INVITEE_NAME, this.inviteeName);

        values.put(FoveaContract.AppInvites.Columns.INVITEE_EMAIL, this.inviteeEmail);

        values.put(FoveaContract.AppInvites.Columns.INVITEE_PHONE, this.inviteePh);

        values.put(FoveaContract.AppInvites.Columns.INVITE_STATUS, this.statusID);

        values.put(FoveaContract.AppInvites.Columns.INVITEE_WEIGHT, this.weight);

        values.put(FoveaContract.AppInvites.Columns.PLATFORM_ID, this.platformID.getValue());

        values.put(FoveaContract.AppInvites.Columns.DEVICE_FAMILY, this.deviceFamilyID.getValue());

        values.put(FoveaContract.AppInvites.Columns.FOVEA_USERID, this.foveaUserID);

        return values;
    }
}
