package com.cogknit.fovea.dataModel;

import android.content.ContentValues;

import com.cogknit.fovea.FoveaUserProfile;
import com.cogknit.fovea.providers.FoveaContract;
/**
 * Created by Maithri V M on 02/09/15.
 */
public class UserProfile extends FoveaUserProfile {
    private transient String foveaUserID;

    public UserProfile(FoveaUserProfile userProfile, String foveaUserProfileID){
        super(userProfile);
        this.foveaUserID = foveaUserProfileID;
    }
    public void setFoveaUserID(String foveaUserID){
        this.foveaUserID = foveaUserID;
    }
    public String getFoveaUserID(){
        return this.foveaUserID;
    }

    public ContentValues getContentValues() {
        ContentValues values = new ContentValues();

        values.put(FoveaContract.UserProfile.Columns.NAME, this.userName);

        values.put(FoveaContract.UserProfile.Columns.UNIQUE_BIZ_USERID, this.customerID);

        values.put(FoveaContract.UserProfile.Columns.EMAIL_ID, this.emailId);

        values.put(FoveaContract.UserProfile.Columns.PHONE_NUMBER, this.phoneNo);

        values.put(FoveaContract.UserProfile.Columns.DOB, this.dob);

        values.put(FoveaContract.UserProfile.Columns.GENDER,this.gender);

        values.put(FoveaContract.UserProfile.Columns.FOVEA_USERID, foveaUserID);

        return values;
    }

}
