package com.cogknit.fovea.dataModel;



import android.content.ContentValues;

import com.cogknit.fovea.providers.FoveaContract;

public class UserLocation {
	
	private double latitude;
	private double longitude;
	private String timestamp;
	private int activity;
	//private transient String foveaUserID;
	
	
	public UserLocation(double latitude, double longitude, int activity, String timestamp/*, String foveaUserID*/) {
		super();
		this.latitude = latitude;
		this.longitude = longitude;
		this.timestamp = timestamp;
		this.activity=activity;
		//this.foveaUserID = foveaUserID;

	}
	/**
	 * Getter for getting ContentValues object for use with the GoGlocal Provider
	 * @return A content value object of this UserLocation entry
	 */
	public ContentValues getContentValues(){
		ContentValues values=new ContentValues();
		values.put(FoveaContract.Location.Columns.LATITUDE, latitude);
		values.put(FoveaContract.Location.Columns.LONGITUDE,longitude);
		values.put(FoveaContract.Location.Columns.ACTIVITY, activity);
		values.put(FoveaContract.Location.Columns.TIMESTAMP, timestamp);
		/*values.put(FoveaContract.Location.Columns.FOVEA_USERID,
				foveaUserID);*/
		return values;
		
	}

	
}
