package com.cogknit.fovea.dataModel;

import android.content.ContentValues;

import com.cogknit.fovea.providers.FoveaContract;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * A value object encapsulating the details of an SMS.
 * @author Chirag
 *
 */
public class Sms {
	
	private String number;
	private String body;
	private String timestamp;
	private transient String foveaUserID;
	
	public Sms(String number, String body, String timestamp, String foveaUserID) {
		super();
		this.number = number;
		this.body = body;
		this.timestamp = timestamp;
		this.foveaUserID = foveaUserID;

	}
	/**
	 * 
	 * @return a JSON Object for the calling object
	 */
	public JSONObject getJSONObject() {
        JSONObject obj = new JSONObject();
        try {
            
            obj.put(FoveaContract.Sms.Columns.NUMBER, number);
            obj.put(FoveaContract.Sms.Columns.BODY, body);
            obj.put(FoveaContract.Sms.Columns.TIMESTAMP, timestamp);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

	/**
	 * Getter for getting ContentValues object for use with the GoGlocal Provider
	 * @return A content value object of this Sms entry
	 */
	public ContentValues getContentValues(){
		ContentValues values=new ContentValues();
		values.put(FoveaContract.Sms.Columns.NUMBER, number);
		values.put(FoveaContract.Sms.Columns.BODY,body);
		values.put(FoveaContract.Sms.Columns.TIMESTAMP, timestamp);
		values.put(FoveaContract.Sms.Columns.FOVEA_USERID,
				foveaUserID);
		return values;
		
	}
	

}
