package com.cogknit.fovea.dataModel;

import android.content.ContentValues;

import com.cogknit.fovea.providers.FoveaContract;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * A Value Object Wrapper containing The Call Statistics of a particular person.
 * 
 * @author Chirag
 * @since 2015-01-09
 * @version 0.1
 */
public class Person {

	private String name;
	private String phoneNumber;
	private long duration;
	private long frequency;
	private String timestamp;
	private String contactURI;
	private transient String foveaUserID;

    private Double weight;

	public Person(String name, String phoneNumber, long duration,
			long frequency, Double weight, String contactURI, String timeframe, String foveaUserID) {
		super();
		this.name = name;
		this.phoneNumber = phoneNumber;
		this.duration = duration;
		this.frequency = frequency;
		this.timestamp = timeframe;
		this.contactURI = contactURI;
		this.foveaUserID = foveaUserID;
		this.weight = weight;

	}
	public Person(String name, String phoneNumber, long duration,
				  long frequency, Double weight, String timeframe,String foveaUserID) {
		super();
		this.name = name;
		this.phoneNumber = phoneNumber;
		this.duration = duration;
		this.frequency = frequency;
		this.timestamp = timeframe;
		this.foveaUserID = foveaUserID;
		this.weight = weight;

	}
	/**
	 * Getter for getting ContentValues object for use with the GoGlocal
	 * Provider
	 * 
	 * @return A content value object of this Person
	 */
	public ContentValues getContentValues() {
		ContentValues values = new ContentValues();

		values.put(FoveaContract.People.Columns.NAME, name);

		values.put(FoveaContract.People.Columns.NUMBER, phoneNumber);

		values.put(FoveaContract.People.Columns.DURATION, duration);

		values.put(FoveaContract.People.Columns.FREQUENCY, frequency);
		//values.put(FoveaContract.People.Columns.FREQUENCY, weight);

		values.put(FoveaContract.People.Columns.WEIGHT, weight);

		values.put(FoveaContract.People.Columns.TIMEFRAME, timestamp);

		values.put(FoveaContract.People.Columns.CONTACT_URI, contactURI);

		values.put(FoveaContract.People.Columns.FOVEA_USERID,
				foveaUserID);
		return values;
	}

	/**
	 * Increments calling object's duration by specified amount
	 * 
	 * @param d
	 */
	public void addDuration(long d) {
		duration += d;
	}

	/**
	 * Increments calling object's frequency count by specified amount
	 * 
	 * @param f
	 */
	public void addFrequency(int f) {
		frequency += f;
	}

	/**
	 * Returns the frequency value
	 *
	 */
	public long getFrequency() {
		return frequency;
	}

	/**
	 * 
	 * @return the duration for calls for calling object
	 */
	public long getDuration() {
		return duration;
	}

	/**
	 * A helper method to check if this Person's name is available
	 * 
	 * @return
	 */
	public boolean isNameKnown() {
		if (name == null || name == "" || name.contains("Unknown"))
			return false;
		return true;
	}

	/**
	 * 
	 * @return a JSON Object for the calling object
	 */
	public JSONObject getJSONObject() {
		JSONObject obj = new JSONObject();
		try {
			obj.put("name", name);
			obj.put("phoneNumber", phoneNumber);
			obj.put("duration", duration);
			obj.put("frequency", frequency);
			obj.put("timeframe", timestamp.substring(1));
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return obj;
	}

    /**
     * Sets the calculated weight
     *
     * @param w
     */
    public void setWeight(double w) {
        weight = w;
    }

    /**
     * Returns the calculated weight
     */
    public double getWeight() {
        return weight;
    }
}
