package com.cogknit.fovea.dataModel;

import android.content.ContentValues;

import com.cogknit.fovea.providers.FoveaContract;

/**
 * A Simple Value Object Class encapsulating a Facebook user's like
 
 * @author Chirag
 * @since 2015-01-09
 * @version 0.1
 */
public class Like {

	private String id;
	private String name;
	private String category;
	private long timeStamp;
	private String category_other;
	private transient String foveaUserID;

	public Like(String id,String name, String category,
			long timeStamp, String category_other, String foveaUserID) {
		super();
		this.id  = id;
		this.name = name;
		this.category = category;
		this.timeStamp = timeStamp;
		this.category_other = category_other;
		this.foveaUserID = foveaUserID;

	}
	/**
	 * Getter method to wrap values into a ContentValues object for database operations
	 * @return A ContentValues object encapsulating facebook likes details
	 */
	public ContentValues getContentValues() {
		ContentValues values = new ContentValues();

		values.put(FoveaContract.Likes.Columns.FB_ID, id);
		
		values.put(FoveaContract.Likes.Columns.NAME, name);

		values.put(FoveaContract.Likes.Columns.CATEGORY, category);

		values.put(FoveaContract.Likes.Columns.TIMESTAMP,
				timeStamp);

		values.put(FoveaContract.Likes.Columns.CATEGORY_OTHER,
				category_other);
		values.put(FoveaContract.Likes.Columns.FOVEA_USERID,
				foveaUserID);
		return values;
	}

}
