package com.cogknit.fovea.dataModel;

import android.content.ContentValues;

import com.cogknit.fovea.providers.FoveaContract;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Value object encapsulating the History/Bookmark entry details.
 * @author Chirag
 * @author Drithi
 *
 */
public class History {
	
	private String title;
	private String url;
	private String timestamp;
	private int isBookmark;
	private transient String foveaUserID;
	
	public History(String title, String url, String timestamp, int bookmarks, String foveaUserID) {
		super();
		this.title = title;
		this.url = url;
		this.timestamp = timestamp;
		this.isBookmark=bookmarks;
		this.foveaUserID = foveaUserID;

	}

	/**
	 * Getter for getting ContentValues object for use with the GoGlocal Provider
	 * @return A content value object of this History or Bookmark entry
	 */
	public ContentValues getContentValues(){
		ContentValues values=new ContentValues();
		values.put(FoveaContract.History.Columns.TITLE, title);
		values.put(FoveaContract.History.Columns.URL,url);
		values.put(FoveaContract.History.Columns.TIMESTAMP, timestamp);
		values.put(FoveaContract.History.Columns.BOOKMARK_FLAG, isBookmark);
		values.put(FoveaContract.History.Columns.FOVEA_USERID,
				foveaUserID);
		return values;
		
	}
	/**
	 * 
	 * @return a JSON Object for the calling object
	 */
	public JSONObject getJSONObject() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("title", title);
            obj.put("url", url);
            obj.put("timestamp", timestamp);
            obj.put("bookmark", isBookmark);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }
	

}
