package com.cogknit.fovea.dataModel;

import android.content.ContentValues;

import com.cogknit.fovea.providers.FoveaContract;

/**
 * A Simple Value Object Class encapsulating a CallLog
 * 
 * 
 * @author Chirag
 * @since 2015-01-09
 * @version 0.1
 */
public class Call {

	private String name;
	private long duration;
	private String number;
	private long timeStamp;
	private String contactURI;
	private transient String foveaUserID;

	public Call(String name, long duration, String number,
			long timeStamp, String contactURI, String foveaUserID) {
		super();
		this.name = name;
		this.duration = duration;
		this.number = number;
		this.timeStamp = timeStamp;
		this.contactURI = contactURI;
		this.foveaUserID = foveaUserID;

	}
	/**
	 * Getter method to wrap values into a ContentValues object for database operations
	 * @return A ContentValues object encapsulating calllog details
	 */
	public ContentValues getContentValues() {
		ContentValues values = new ContentValues();

		values.put(FoveaContract.Calls.Columns.NAME, name);

		values.put(FoveaContract.Calls.Columns.NUMBER, number);

		values.put(FoveaContract.Calls.Columns.DURATION, duration);

		values.put(FoveaContract.Calls.Columns.TIMESTAMP,
				timeStamp);

		values.put(FoveaContract.Calls.Columns.CONTACT_URI,
				contactURI);

		values.put(FoveaContract.Calls.Columns.FOVEA_USERID,
				foveaUserID);
		return values;
	}

}
