package com.cogknit.fovea.dataModel;

import android.content.Context;
import android.provider.Settings;

import com.cogknit.fovea.providers.FoveaUserProfileManager;
import com.cogknit.fovea.utils.CryptoHelper;
/**
 * Created by Maithri V M on 26/08/15.
 */

public class AuthRequest {
    static final int ANDROID_PLATFORM_ID = 1;

    private String appKey;
    private String packageName;
    private String deviceId;
    private int platformID;
    private String clientKey;

    //private String uniqueUserID;

    public AuthRequest(String appID, String clientKey, Context c){
        this.appKey = appID;
        this.packageName = c.getPackageName();
        this.platformID = ANDROID_PLATFORM_ID;
        this.clientKey = clientKey;
        this.deviceId = getUniqueDeviceID(c);

        /*String userID = FoveaUserProfileManager.getLoggedInBizUserID(c);
        if (userID != null)
        {
            this.uniqueUserID = userID;
        }*/
    }

    private String getUniqueDeviceID(Context context)
    {
        String android_id = Settings.Secure.getString(context.getContentResolver(),Settings.Secure.ANDROID_ID);
        String deviceHash = android_id;
        try {
            deviceHash = CryptoHelper.SHA1(android_id);
        }
        catch (Exception exception)
        {
            //return deviceHash;
        }
        return deviceHash;
    }

}
