package com.cogknit.fovea.dataModel;

import android.content.ContentValues;

import com.cogknit.fovea.providers.FoveaContract;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Value Object for App
 * 
 * @author Aastha
 * 
 */
public class App {
	private String name;
	private String packageName;
	private long foregroundTime;
	private transient String foveaUserID;

	public App(String name, String pkg, long foregroundTime, String foveaUserID) {
		super();
		this.name = name;
		this.packageName = pkg;
		this.foregroundTime = foregroundTime;
		this.foveaUserID = foveaUserID;

	}

	public String getPackageName() {
		return packageName;
	}

	/**
	 * Getter method to wrap values into a ContentValues object for database
	 * operations
	 * 
	 * @return A ContentValues object encapsulating app details
	 */
	public ContentValues getContentValues() {
		ContentValues values = new ContentValues();

		values.put(FoveaContract.Apps.Columns.NAME, name);

		values.put(FoveaContract.Apps.Columns.PACKAGE_NAME, packageName);

		values.put(FoveaContract.Apps.Columns.FOREGROUND_TIME,
				foregroundTime);
		values.put(FoveaContract.Apps.Columns.FOVEA_USERID,
				foveaUserID);
		return values;
	}

	/**
	 * 
	 * @return a JSON Object for the calling object
	 */
	public JSONObject getJSONObject() {
		JSONObject obj = new JSONObject();
		try {

			obj.put(FoveaContract.Apps.Columns.NAME, name);
			obj.put(FoveaContract.Apps.Columns.PACKAGE_NAME, packageName);
			obj.put(FoveaContract.Apps.Columns.FOREGROUND_TIME,
					foregroundTime);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return obj;
	}

	/**
	 * Method to add certain time to foregroundTime
	 * 
	 */
	public void addForegroundTime(long time) {
		foregroundTime += time;
	}
	
	

}
