package com.cogknit.fovea;

/**
 * This class represents the Customer profile of the app
 * Created by Maithri V M on 27/08/15.
 */
public class FoveaUserProfile {
    protected String customerID;
    protected String userName;
    protected String emailId;
    protected String phoneNo;
    protected int gender;
    protected String dob;

    /**
     ** Constructor method, Customer ID is mandatory
     * @param customerID - The customer ID of the device user
     */
    public FoveaUserProfile(String customerID){
        super();
        this.customerID = customerID;
        this.gender = FoveaConstants.Gender.Undisclosed.ordinal();
    }

    /**
     ** This method will initialize the Customer profile with the given object
     * @param customerProfile object
     */
    public FoveaUserProfile(FoveaUserProfile customerProfile){
        super();
        this.customerID = customerProfile.customerID;
        this.userName = customerProfile.userName;
        this.emailId = customerProfile.emailId;
        this.phoneNo = customerProfile.phoneNo;
        this.gender = customerProfile.gender;
        this.dob = customerProfile.dob;
    }

    /**
     ** This method will initialize the Customer profile with the given values
     * @param customerID  - The customer ID of the app user
     * @param userName - The customer name of the app user
     * @param emailID - The customer emailID of the app user
     * @param phoneNumber - The customer phone number of the app user
     * @param gender - FoveaConstants.Gender enaum value
     * @param dateOfBirth - in dd/mm/YYYY format ("13/05/2000")
     */
    public FoveaUserProfile(String customerID,
                            String userName,
                            String emailID,
                            String phoneNumber,
                            FoveaConstants.Gender gender,
                            String dateOfBirth) {
        super();
        this.customerID = customerID;
        this.userName = userName;
        this.emailId = emailID;
        this.phoneNo = phoneNumber;
        this.gender = gender.ordinal();
        this.dob = dateOfBirth;
    }

    /**
     ** This method will initialize the Customer profile with the given values
     * @param userName - The customer name of the app user
     */
    public void setUserName(String userName){
        this.userName = userName;
    }

    /**
     ** This method will initialize the Customer profile with the given values
     * @param emailID - The customer emailID of the app user
     */
    public void setEmailID(String emailID){
        this.emailId = emailID;
    }

    /**
     ** This method will initialize the Customer profile with the given values
     * @param phoneNumber - The customer phone number of the app user
     */
    public void setPhoneNumber(String phoneNumber){
        this.phoneNo = phoneNumber;
    }

    /**
     ** This method will initialize the Customer profile with the given values
     * @param dateOfBirth - in dd/mm/YYYY format ("13/05/2000")
     */
    public void setDateOfBirth(String dateOfBirth){
        this.dob = dateOfBirth;
    }

    /**
     ** This method will initialize the Customer profile with the given values
     * @param gender - FoveaConstants.Gender enum value
     */
    public void setGender(FoveaConstants.Gender gender){
        this.gender = gender.ordinal();
    }
}
