package com.cogknit.fovea;

import android.content.Context;
import android.content.SharedPreferences;

import com.cogknit.fovea.providers.FoveaAppInvitee;
import com.cogknit.fovea.providers.FoveaAppInvitesManager;
import com.cogknit.fovea.providers.FoveaSynchronizationManager;
import com.cogknit.fovea.providers.FoveaUserProfileManager;
import com.cogknit.fovea.receivers.BootEventReceiver;
import com.cogknit.fovea.remote.APIConstants;
import com.cogknit.fovea.remote.FoveaRequestResponseManager;
import com.cogknit.fovea.remote.FoveaResponse;

import java.util.List;

/**
 * This class acts as the implementation for Fovea main interface
 * Created by Maithri V M on 25/08/15.
 */

class FoveaManager {

    private static String AppKey;
    private static String ClientKey;
    private Context context;
    private String TAG = "FoveaRequestResponseManager";

    public FoveaManager(String appKey, String clientKey, Context inContext) {
        context = inContext;
        AppKey = appKey;
        ClientKey = clientKey;
    }

    void initialize(android.content.Context inContext,FoveaCallback callback) {

        context = inContext;

        //Initialize with default values
        SharedPreferences settings = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        settings.edit().putString(FoveaSharedPreferences.UserProfile.AppKey, AppKey).commit();
        settings.edit().putString(FoveaSharedPreferences.UserProfile.ClientKey, ClientKey).commit();

        Boolean isSDKAuthorized = settings.getBoolean(FoveaSharedPreferences.UserProfile.isSDKAuthorized, false);

        if (isSDKAuthorized == false) {
            settings.edit().putString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, APIConstants.DefaultFoveaID).commit();
        }

        //Perform the one-time config synch
        if (APIConstants.getAPIClientURL(inContext) == null) {
            FoveaSynchronizationManager synchronizationManager = new FoveaSynchronizationManager();
            synchronizationManager.performClientConfigSynchronization(context);
        }

        //Authorize the SDK
        authorizeSDK(context, AppKey, ClientKey, callback);

    }

    private void authorizeSDK(android.content.Context contxt, String appKey, String clientKey, final FoveaCallback callback) {
        FoveaRequestResponseManager manager = new FoveaRequestResponseManager(context);
        manager.sendAuthorizationRequest(appKey, clientKey,
                new FoveaResponse.FoveaResponseListener() {
                    @Override
                    public void onSuccessResponse() {
                        //Cache the FoveaUserID
                        /*String foveaUserID = response.toString();
                        settings.edit().putString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, foveaUserID).commit();*/

                        SharedPreferences settings = context.getSharedPreferences(
                                FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
                        settings.edit().putBoolean(FoveaSharedPreferences.UserProfile.isSDKAuthorized, true).commit();
                        //String userID = settings.getString(FoveaSharedPreferences.UserProfile.FOVEA_USER_ID, "");
                        //Check if there is pending user profile synchronization
                        Boolean hasPendingUPSync = settings.getBoolean(FoveaSharedPreferences.UserProfile.hasPendingUPSync, false);
                        if (hasPendingUPSync) {
                            FoveaUserProfileManager userProfileManager = new FoveaUserProfileManager();
                            userProfileManager.performUserProfileSynchronization(context);
                        }
                        callback.onCompletion();

                        startContextMining(context);

                    }
                },
                new FoveaResponse.FoveaErrorListener() {
                    @Override
                    public void onFoveaErrorResponse(Exception error) {
                        callback.onFailure(error);
                    }
                });
    }

    /* The method to set the user profile data*/
    void setUserProfileDetails(FoveaUserProfile userProfile) {
        FoveaUserProfileManager userProfileManager = new FoveaUserProfileManager();
        userProfileManager.setUserProfile(userProfile, context);
    }

    void setFbAccessToken(String token) {
        SharedPreferences.Editor editor = context.getSharedPreferences(FoveaSharedPreferences.FB.PREFS_NAME, Context.MODE_PRIVATE).edit();
        editor.putString(FoveaSharedPreferences.FB.ACCESS_TOKEN, token).apply();
    }

    List<FoveaAppInvitee> getAppInvitees()  throws Fovea.UninitializedException {
        FoveaAppInvitesManager appInvitesManager = new FoveaAppInvitesManager();
        return appInvitesManager.getAppInvitees(context);
    }

    void feedbackOnAppInvites(List<FoveaAppInvitee> approvedInvites, List<FoveaAppInvitee> declinedInvites, String inviteMessage) throws Fovea.UninitializedException, Fovea.AppInviteException
    {
        //1. Check if SDK is authorized
        SharedPreferences settings = context.getSharedPreferences(
                FoveaSharedPreferences.FOVEA_PREFS, Context.MODE_PRIVATE);
        Boolean hasAuthenticated = settings.getBoolean(FoveaSharedPreferences.UserProfile.isSDKAuthorized, false);
        if (!hasAuthenticated)
        {
            throw new Fovea.UninitializedException();
        }
        FoveaAppInvitesManager appInvitesManager = new FoveaAppInvitesManager();
        appInvitesManager.feedbackOnAppInvites(approvedInvites, declinedInvites, inviteMessage, context);
    }

    private void startContextMining(Context context) {
        BootEventReceiver.initialize(context);
    }

}
