package com.cogknit.fovea;

import android.content.Context;
import android.content.SharedPreferences;

import com.cogknit.fovea.utils.SchedulerConstants;

import org.json.JSONArray;

import java.util.ArrayList;

/**
 * Created by Maithri V M on 27/08/15.
 */
public class FoveaConstants {

    /**
     ** This is for specifying the gender
     **/
    public enum Gender { Undisclosed, Male, Female, Other}

    /**
     ** This is for specifying the Context mining services
     **/
    public enum Services {
        APP_VIRALITY, APP_USAGE_DASHBOARD, APP_USERLOCATION_DASHBOARD, DISCOVERY, FB;

        public void activateService(Context context) {
            SharedPreferences pref = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, 0);
            pref.edit().putBoolean(this.name(),true).commit();
        }

        public boolean getStatus(Context context) {
            SharedPreferences pref = context.getSharedPreferences(FoveaSharedPreferences.FOVEA_PREFS, 0);
            return pref.getBoolean(this.name(),false);
        }

        public static Services[] getRequestedServices(JSONArray services) {
            ArrayList<FoveaConstants.Services> miningContexts = new ArrayList<Services>();
            try {
                for(int i = 0; i < services.length(); i++)
                {
                    String entry = services.getString(i);
                   switch (Services.valueOf(entry)){

                       case APP_VIRALITY:
                           miningContexts.add(APP_VIRALITY);
                           break;
                       case APP_USAGE_DASHBOARD:
                           miningContexts.add(APP_USAGE_DASHBOARD);
                           break;
                       case APP_USERLOCATION_DASHBOARD:
                           miningContexts.add(APP_USERLOCATION_DASHBOARD);
                           break;
                       case DISCOVERY:
                           miningContexts.add(DISCOVERY);
                           break;
                   }
                }
            }
            catch(Exception e) {
                System.err.println("Exception: " + e.getMessage());
            }

            FoveaConstants.Services contexts[] = new FoveaConstants.Services[miningContexts.size()];
            contexts = miningContexts.toArray(contexts);
            return contexts;
        }


    }
}

